/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Iterator;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleSafepointNode;

public final class TruffleSafepointInsertionPhase
extends Phase {
    private final Providers providers;
    private final ResolvedJavaType nodeType;
    private final ResolvedJavaType rootNodeType;
    private final ResolvedJavaType callTargetClass;
    private final ResolvedJavaField rootNodeField;
    private final ResolvedJavaField parentField;
    private final ResolvedJavaMethod executeRootMethod;

    public TruffleSafepointInsertionPhase(Providers providers) {
        this.providers = providers;
        TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
        this.nodeType = rt.resolveType(providers.getMetaAccess(), Node.class.getName());
        this.rootNodeType = rt.resolveType(providers.getMetaAccess(), RootNode.class.getName());
        this.callTargetClass = rt.resolveType(providers.getMetaAccess(), "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget");
        this.executeRootMethod = TruffleSafepointInsertionPhase.findMethod(this.callTargetClass, "executeRootNode");
        this.rootNodeField = TruffleSafepointInsertionPhase.findField(this.callTargetClass, "rootNode");
        this.parentField = TruffleSafepointInsertionPhase.findField(this.nodeType, "parent");
    }

    public static boolean allowsSafepoints(StructuredGraph graph) {
        return graph.compilationId() instanceof TruffleCompilationIdentifier;
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    protected void run(StructuredGraph graph) {
        Throwable throwable;
        Object s;
        if (!TruffleSafepointInsertionPhase.allowsSafepoints(graph)) {
            return;
        }
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            s = returnNode.withNodeSourcePosition();
            throwable = null;
            try {
                this.insertSafepoint(graph, returnNode);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (s == null) continue;
                if (throwable != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                s.close();
            }
        }
        for (LoopBeginNode loopBeginNode : graph.getNodes(LoopBeginNode.TYPE)) {
            for (LoopEndNode loopEndNode : loopBeginNode.loopEnds()) {
                if (!loopEndNode.canGuestSafepoint()) continue;
                DebugCloseable s2 = loopEndNode.withNodeSourcePosition();
                Throwable throwable4 = null;
                try {
                    this.insertSafepoint(graph, loopEndNode);
                }
                catch (Throwable throwable5) {
                    throwable4 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (s2 == null) continue;
                    if (throwable4 != null) {
                        try {
                            s2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    s2.close();
                }
            }
        }
        for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
            s = callTarget.withNodeSourcePosition();
            throwable = null;
            try {
                this.insertSafepoint(graph, (FixedNode)((Object)callTarget.invoke()));
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (s == null) continue;
                if (throwable != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                s.close();
            }
        }
    }

    private void insertSafepoint(StructuredGraph graph, FixedNode returnNode) {
        ConstantNode node = this.findTruffleNode(returnNode);
        if (node == null) {
            JavaConstant javaConstant = ((TruffleCompilationIdentifier)graph.compilationId()).getCompilable().asJavaConstant();
            JavaConstant rootNode = this.providers.getConstantReflection().readFieldValue(this.rootNodeField, javaConstant);
            ObjectStamp stamp = StampFactory.object(TypeReference.createExactTrusted(this.rootNodeField.getType().resolve(this.callTargetClass)));
            node = new ConstantNode((Constant)rootNode, (Stamp)stamp);
        }
        assert (node.asJavaConstant() != null) : "must be a java constant";
        assert (this.nodeType.isAssignableFrom(node.stamp(NodeView.DEFAULT).javaType(this.providers.getMetaAccess()))) : "must be a truffle node";
        node = graph.maybeAddOrUnique(node);
        graph.addBeforeFixed(returnNode, graph.add(new TruffleSafepointNode(node)));
    }

    private ConstantNode findTruffleNode(org.graalvm.compiler.graph.Node node) {
        for (org.graalvm.compiler.graph.Node n = node; n != null; n = n.predecessor()) {
            FrameState innerMostState;
            Iterator iterator;
            if (!(n instanceof NodeWithState) || !(iterator = ((NodeWithState)((Object)n)).states().iterator()).hasNext()) continue;
            for (FrameState state = innerMostState = (FrameState)iterator.next(); state != null; state = state.outerFrameState()) {
                ConstantNode foundTruffleConstant = this.findTruffleNode(state);
                if (foundTruffleConstant != null) {
                    return foundTruffleConstant;
                }
                if (!state.getMethod().equals(this.executeRootMethod)) continue;
                throw GraalError.shouldNotReachHere("Found a frame state of executeRootNode but not a constant node.");
            }
        }
        return null;
    }

    private ConstantNode findTruffleNode(FrameState state) {
        ObjectStamp stamp;
        JavaConstant rootNode;
        ResolvedJavaMethod method = state.getMethod();
        if (!method.hasReceiver()) {
            return null;
        }
        ResolvedJavaType receiverType = method.getDeclaringClass();
        boolean truffleNode = this.nodeType.isAssignableFrom(receiverType);
        if (!truffleNode && !this.callTargetClass.isAssignableFrom(receiverType)) {
            return null;
        }
        if (state.values() == null || state.values().size() == 0) {
            return null;
        }
        ValueNode value = (ValueNode)state.values().get(0);
        if (value == null) {
            return null;
        }
        JavaConstant javaConstant = value.asJavaConstant();
        if (javaConstant == null) {
            return null;
        }
        ResolvedJavaType javaType = value.stamp(NodeView.DEFAULT).javaType(this.providers.getMetaAccess());
        if (javaType == null) {
            return null;
        }
        if (!receiverType.isAssignableFrom(javaType)) {
            assert (false) : "unexpected case";
            return null;
        }
        if (truffleNode) {
            rootNode = this.getRootNode(javaConstant);
            if (rootNode == null) {
                return null;
            }
            stamp = StampFactory.object(TypeReference.createExactTrusted(this.rootNodeType));
        } else {
            rootNode = this.providers.getConstantReflection().readFieldValue(this.rootNodeField, javaConstant);
            stamp = StampFactory.object(TypeReference.createExactTrusted(this.rootNodeField.getType().resolve(this.callTargetClass)));
        }
        return new ConstantNode((Constant)rootNode, (Stamp)stamp);
    }

    private JavaConstant getRootNode(JavaConstant node) {
        JavaConstant current;
        JavaConstant parent = current = node;
        do {
            current = parent;
        } while (!(parent = this.providers.getConstantReflection().readFieldValue(this.parentField, current)).isNull());
        ResolvedJavaType type = this.providers.getMetaAccess().lookupJavaType(current);
        if (this.rootNodeType.isAssignableFrom(type)) {
            return current;
        }
        return null;
    }

    static ResolvedJavaMethod findMethod(ResolvedJavaType type, String name) {
        for (ResolvedJavaMethod m : type.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        throw GraalError.shouldNotReachHere("Required method " + name + " not found in " + type);
    }

    static ResolvedJavaField findField(ResolvedJavaType type, String name) {
        for (ResolvedJavaField field : type.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw GraalError.shouldNotReachHere("Required field " + name + " not found in " + type);
    }
}

