/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.util.Collections;
import java.util.LinkedHashMap;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.PerformanceInformationHandler;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.virtual.nodes.MaterializedObjectState;
import org.graalvm.compiler.virtual.nodes.VirtualObjectState;

public class FrameClearPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;
    private final CompilableTruffleAST compilable;
    private final ResolvedJavaType frameType;
    private final int tagArrayIndex;
    private final int objectArrayIndex;
    private final int primitiveArrayIndex;
    private final int illegalTag;
    private final int objectTag;
    private ValueNode nullConstant;
    private ValueNode zeroConstant;
    private NodeBitMap knownIllegals;
    private NodeBitMap knownSafe;
    private final EconomicSet<ValueNode> reported = EconomicSet.create();

    public FrameClearPhase(KnownTruffleTypes knownTruffleTypes, CanonicalizerPhase canonicalizer, CompilableTruffleAST compilable) {
        this(knownTruffleTypes.classFrameClass, knownTruffleTypes.fieldTags, knownTruffleTypes.fieldLocals, knownTruffleTypes.fieldPrimitiveLocals, canonicalizer, compilable);
    }

    private FrameClearPhase(ResolvedJavaType frameType, ResolvedJavaField tagArray, ResolvedJavaField objectArray, ResolvedJavaField primitiveArray, CanonicalizerPhase canonicalizer, CompilableTruffleAST compilable) {
        this.frameType = frameType;
        this.tagArrayIndex = FrameClearPhase.findFieldIndex(frameType, tagArray);
        this.objectArrayIndex = FrameClearPhase.findFieldIndex(frameType, objectArray);
        this.primitiveArrayIndex = FrameClearPhase.findFieldIndex(frameType, primitiveArray);
        assert (this.tagArrayIndex >= 0 && this.objectArrayIndex >= 0 && this.primitiveArrayIndex >= 0);
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        this.illegalTag = runtime.getFrameSlotKindTagForJavaKind(JavaKind.Illegal);
        this.objectTag = runtime.getFrameSlotKindTagForJavaKind(JavaKind.Object);
        this.canonicalizer = canonicalizer;
        this.compilable = compilable;
    }

    private static int findFieldIndex(ResolvedJavaType type, ResolvedJavaField field) {
        ResolvedJavaField[] fields = type.getInstanceFields(true);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equals(field)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSetNodeEventListener ec = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope scope = graph.trackNodeEvents(ec);){
            this.init(graph);
            this.doRun(graph);
            this.clear();
        }
        if (!ec.getNodes().isEmpty()) {
            this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)ec.getNodes());
        }
    }

    private void init(StructuredGraph graph) {
        this.knownIllegals = graph.createNodeBitMap();
        this.knownSafe = graph.createNodeBitMap();
        this.nullConstant = ConstantNode.defaultForKind(JavaKind.Object, graph);
        this.zeroConstant = ConstantNode.defaultForKind(JavaKind.Long, graph);
    }

    private void clear() {
        this.knownIllegals = null;
        this.knownSafe = null;
        this.nullConstant = null;
        this.zeroConstant = null;
    }

    private void doRun(StructuredGraph graph) {
        for (FrameState fs : graph.getNodes(FrameState.TYPE)) {
            EconomicMap<VirtualObjectNode, EscapeObjectState> objectStates = FrameClearPhase.getObjectStateMappings(fs);
            for (EscapeObjectState objectState : objectStates.getValues()) {
                VirtualObjectState vObjState;
                ValueNode tagArrayValue;
                if (!(objectState instanceof VirtualObjectState) || !objectState.object().type().equals(this.frameType) || !((tagArrayValue = (ValueNode)(vObjState = (VirtualObjectState)objectState).values().get(this.tagArrayIndex)) instanceof VirtualArrayNode) || !(vObjState.values().get(this.objectArrayIndex) instanceof VirtualArrayNode) || !(vObjState.values().get(this.primitiveArrayIndex) instanceof VirtualArrayNode)) continue;
                EscapeObjectState tagArrayVirtual = (EscapeObjectState)objectStates.get((Object)((VirtualArrayNode)tagArrayValue));
                EscapeObjectState objectArrayVirtual = (EscapeObjectState)objectStates.get((Object)((VirtualArrayNode)vObjState.values().get(this.objectArrayIndex)));
                EscapeObjectState primitiveArrayVirtual = (EscapeObjectState)objectStates.get((Object)((VirtualArrayNode)vObjState.values().get(this.primitiveArrayIndex)));
                assert (tagArrayVirtual instanceof VirtualObjectState && objectArrayVirtual instanceof VirtualObjectState && primitiveArrayVirtual instanceof VirtualObjectState);
                int length = ((VirtualArrayNode)tagArrayValue).entryCount();
                for (int i = 0; i < length; ++i) {
                    this.maybeClearFrameSlot((VirtualObjectState)tagArrayVirtual, (VirtualObjectState)objectArrayVirtual, (VirtualObjectState)primitiveArrayVirtual, i);
                }
            }
        }
    }

    private void maybeClearFrameSlot(VirtualObjectState tagArrayVirtual, VirtualObjectState objectArrayVirtual, VirtualObjectState primitiveArrayVirtual, int i) {
        ValueNode tagNode = (ValueNode)tagArrayVirtual.values().get(i);
        if (tagNode == null) {
            return;
        }
        if (!tagNode.isJavaConstant()) {
            assert (tagNode.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
            IntegerStamp tagStamp = (IntegerStamp)tagNode.stamp(NodeView.DEFAULT);
            boolean canBeIllegal = tagStamp.isUnrestricted() ? this.unbalancedIllegal(tagNode) : this.stampHasIllegal(tagStamp);
            if (canBeIllegal) {
                this.logPerformanceWarningClearIntroducedPhi(tagNode);
            } else if (!this.stampHasObject(tagStamp)) {
                objectArrayVirtual.values().set(i, (Object)this.nullConstant);
            }
        } else {
            int tag = tagNode.asJavaConstant().asInt();
            if (tag == this.illegalTag) {
                objectArrayVirtual.values().set(i, (Object)this.nullConstant);
                primitiveArrayVirtual.values().set(i, (Object)this.zeroConstant);
            } else {
                VirtualObjectState toClear = tag == this.objectTag ? primitiveArrayVirtual : objectArrayVirtual;
                ValueNode toSet = tag == this.objectTag ? this.zeroConstant : this.nullConstant;
                toClear.values().set(i, (Object)toSet);
            }
        }
    }

    private boolean stampHasIllegal(IntegerStamp stamp) {
        return stamp.contains(this.illegalTag);
    }

    private boolean stampHasObject(IntegerStamp stamp) {
        return stamp.contains(this.objectTag);
    }

    private boolean unbalancedIllegal(ValueNode node) {
        return new UnbalancedIllegalExplorer(node.graph()).explore(node);
    }

    private static EconomicMap<VirtualObjectNode, EscapeObjectState> getObjectStateMappings(FrameState fs) {
        EconomicMap objectStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        FrameState current = fs;
        do {
            if (current.virtualObjectMappingCount() <= 0) continue;
            for (EscapeObjectState state : current.virtualObjectMappings()) {
                if (objectStates.containsKey((Object)state.object()) || state instanceof MaterializedObjectState && ((MaterializedObjectState)state).materializedValue() == state.object()) continue;
                objectStates.put((Object)state.object(), (Object)state);
            }
        } while ((current = current.outerFrameState()) != null);
        return objectStates;
    }

    private void logPerformanceWarningClearIntroducedPhi(ValueNode location) {
        if (PerformanceInformationHandler.isWarningEnabled(PolyglotCompilerOptions.PerformanceWarningKind.FRAME_CLEAR_PHI)) {
            if (this.reported.contains((Object)location)) {
                return;
            }
            StructuredGraph graph = location.graph();
            DebugContext debug = location.getDebug();
            try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                properties.put("location", location);
                properties.put("method", this.compilable.getName());
                PerformanceInformationHandler.logPerformanceWarning(PolyglotCompilerOptions.PerformanceWarningKind.FRAME_CLEAR_PHI, this.compilable, Collections.emptyList(), "Frame clear introduces new phis in the graph. This is most likely due to a faulty liveness analysis implementation, or an unexpected control-flow construction. Make sure all control-flows in the graph are as expected.", properties);
                debug.dump(3, (Object)graph, "perf warn: Frame clear introduces new phis in the graph: %s", location);
                this.reported.add((Object)location);
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
    }

    private final class UnbalancedIllegalExplorer {
        private final NodeBitMap visited;

        private UnbalancedIllegalExplorer(Graph graph) {
            this.visited = graph.createNodeBitMap();
        }

        private boolean explore(ValueNode node) {
            ValueNode toProcess = node;
            while (toProcess instanceof ValueProxyNode) {
                toProcess = ((ValueProxyNode)toProcess).value();
            }
            if (toProcess instanceof ConstantNode) {
                assert (toProcess.getStackKind() == JavaKind.Int);
                return toProcess.asJavaConstant().asInt() == FrameClearPhase.this.illegalTag;
            }
            if (!toProcess.stamp(NodeView.DEFAULT).isUnrestricted()) {
                assert (toProcess.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
                IntegerStamp stamp = (IntegerStamp)toProcess.stamp(NodeView.DEFAULT);
                return FrameClearPhase.this.stampHasIllegal(stamp);
            }
            if (toProcess instanceof ValuePhiNode) {
                if (FrameClearPhase.this.knownIllegals.contains(toProcess)) {
                    return true;
                }
                if (this.visited.contains(toProcess) || FrameClearPhase.this.knownSafe.contains(toProcess)) {
                    return false;
                }
                this.visited.mark(node);
                for (ValueNode value : ((ValuePhiNode)toProcess).values()) {
                    if (!this.explore(value)) continue;
                    FrameClearPhase.this.knownIllegals.mark(toProcess);
                    return true;
                }
                FrameClearPhase.this.knownSafe.mark(toProcess);
                return false;
            }
            return true;
        }
    }
}

