/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameSetNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameSetNode> TYPE = NodeClass.create(VirtualFrameSetNode.class);
    @Node.Input
    private ValueNode value;

    public VirtualFrameSetNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, ValueNode value) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag);
        this.value = value;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode tagAlias = tool.getAlias(this.frame.virtualFrameTagArray);
        ValueNode dataAlias = tool.getAlias(TruffleCompilerRuntime.getRuntime().getJavaKindForFrameSlotKind(this.accessTag) == JavaKind.Object ? this.frame.virtualFrameObjectArray : this.frame.virtualFramePrimitiveArray);
        if (tagAlias instanceof VirtualObjectNode && dataAlias instanceof VirtualObjectNode) {
            VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
            VirtualObjectNode dataVirtual = (VirtualObjectNode)dataAlias;
            if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < dataVirtual.entryCount()) {
                tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstant(this.accessTag));
                ValueNode dataEntry = tool.getEntry(dataVirtual, this.frameSlotIndex);
                if (dataEntry.getStackKind() == this.value.getStackKind() && tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, this.value, this.value.getStackKind(), -1L)) {
                    tool.delete();
                    return;
                }
            }
        }
        this.insertDeoptimization(tool);
    }
}

