/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameGetNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameGetNode> TYPE = NodeClass.create(VirtualFrameGetNode.class);

    public VirtualFrameGetNode(InvocationPlugin.Receiver frame, int frameSlotIndex, JavaKind accessKind, int accessTag) {
        super(TYPE, StampFactory.forKind(accessKind), frame, frameSlotIndex, accessTag);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode tagAlias = tool.getAlias(this.frame.virtualFrameTagArray);
        ValueNode dataAlias = tool.getAlias(TruffleCompilerRuntime.getRuntime().getJavaKindForFrameSlotKind(this.accessTag) == JavaKind.Object ? this.frame.virtualFrameObjectArray : this.frame.virtualFramePrimitiveArray);
        if (tagAlias instanceof VirtualObjectNode && dataAlias instanceof VirtualObjectNode) {
            VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
            VirtualObjectNode dataVirtual = (VirtualObjectNode)dataAlias;
            if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < dataVirtual.entryCount()) {
                ValueNode dataEntry;
                ValueNode actualTag = tool.getEntry(tagVirtual, this.frameSlotIndex);
                if (!actualTag.isConstant() || actualTag.asJavaConstant().asInt() != this.accessTag) {
                    IntegerEqualsNode comparison = new IntegerEqualsNode(actualTag, this.getConstant(this.accessTag));
                    tool.addNode(comparison);
                    tool.addNode(new FixedGuardNode(comparison, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateRecompile));
                }
                if ((dataEntry = tool.getEntry(dataVirtual, this.frameSlotIndex)).getStackKind() == this.getStackKind()) {
                    tool.replaceWith(dataEntry);
                    return;
                }
            }
        }
        this.insertDeoptimization(tool);
    }
}

