/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes;

import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.nodes.util.JavaConstantFormattable;
import org.graalvm.compiler.nodes.util.JavaConstantFormatter;
import org.graalvm.word.LocationIdentity;

public final class ObjectLocationIdentity
extends LocationIdentity
implements JavaConstantFormattable {
    private final JavaConstant object;

    public static LocationIdentity create(JavaConstant object) {
        assert (object.getJavaKind() == JavaKind.Object && object.isNonNull());
        return new ObjectLocationIdentity(object);
    }

    private ObjectLocationIdentity(JavaConstant object) {
        this.object = object;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectLocationIdentity) {
            ObjectLocationIdentity that = (ObjectLocationIdentity)obj;
            return Objects.equals(that.object, this.object);
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean isImmutable() {
        return false;
    }

    public String toString() {
        return "Identity(" + this.object + ")";
    }

    @Override
    public String format(JavaConstantFormatter formatter) {
        return "Identity(" + formatter.format(this.object) + ")";
    }
}

