/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleSafepointNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public final class HotSpotTruffleSafepointLoweringSnippet
implements Snippets {
    static final HotSpotForeignCallDescriptor THREAD_LOCAL_HANDSHAKE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "HotSpotThreadLocalHandshake.doHandshake", Void.TYPE, Object.class);
    static final LocationIdentity PENDING_HANDSHAKE_LOCATION = NamedLocationIdentity.mutable("JavaThread::<pending_handshake>");

    @Fold
    public static int pendingHandshakeOffset() {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntimeIfAvailable();
        if (runtime instanceof HotSpotTruffleCompilerRuntime) {
            return ((HotSpotTruffleCompilerRuntime)runtime).getThreadLocalPendingHandshakeOffset();
        }
        return -1;
    }

    @Snippet
    private static void pollSnippet(Object node) {
        Word thread = CurrentJavaThreadNode.get();
        if (BranchProbabilityNode.probability(0.0010000000000000009, thread.readInt(HotSpotTruffleSafepointLoweringSnippet.pendingHandshakeOffset(), PENDING_HANDSHAKE_LOCATION) != 0)) {
            HotSpotTruffleSafepointLoweringSnippet.foreignPoll(THREAD_LOCAL_HANDSHAKE, node);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void foreignPoll(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    static class TruffleHotSpotSafepointLoweringExtension
    implements DefaultHotSpotLoweringProvider.Extension {
        @NativeImageReinitialize
        private Templates templates;
        @NativeImageReinitialize
        private volatile Runnable deferredInit;

        TruffleHotSpotSafepointLoweringExtension() {
        }

        public Class<TruffleSafepointNode> getNodeType() {
            return TruffleSafepointNode.class;
        }

        @Override
        public void lower(Node n, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                this.doDeferredInit();
                if (this.templates != null) {
                    this.templates.lower((TruffleSafepointNode)n, tool);
                } else {
                    GraphUtil.unlinkFixedNode((TruffleSafepointNode)n);
                    n.safeDelete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDeferredInit() {
            if (this.deferredInit != null) {
                TruffleHotSpotSafepointLoweringExtension truffleHotSpotSafepointLoweringExtension = this;
                synchronized (truffleHotSpotSafepointLoweringExtension) {
                    if (this.deferredInit != null) {
                        this.deferredInit.run();
                        this.deferredInit = null;
                    }
                }
            }
        }

        @Override
        public void initialize(HotSpotProviders providers, OptionValues options, GraalHotSpotVMConfig config, HotSpotHostForeignCallsProvider foreignCalls, Iterable<DebugHandlersFactory> factories) {
            GraalError.guarantee(this.templates == null, "cannot re-initialize %s", (Object)this);
            if (config.invokeJavaMethodAddress != 0L && config.jvmciReserved0Offset != -1) {
                this.templates = new Templates(options, factories, providers, providers.getCodeCache().getTarget());
                this.deferredInit = () -> {
                    long address = config.invokeJavaMethodAddress;
                    GraalError.guarantee(address != 0L, "Cannot lower %s as JVMCIRuntime::invoke_static_method_one_arg is missing", (Object)address);
                    ResolvedJavaType handshakeType = TruffleCompilerRuntime.getRuntime().resolveType(providers.getMetaAccess(), "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotThreadLocalHandshake");
                    HotSpotSignature sig = new HotSpotSignature(foreignCalls.getJVMCIRuntime(), "(Ljava/lang/Object;)V");
                    ResolvedJavaMethod staticMethod = handshakeType.findMethod("doHandshake", (Signature)sig);
                    assert (staticMethod != null);
                    foreignCalls.invokeJavaMethodStub(options, providers, THREAD_LOCAL_HANDSHAKE, address, staticMethod);
                };
            }
        }
    }

    static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo pollSnippet = this.snippet(HotSpotTruffleSafepointLoweringSnippet.class, "pollSnippet", PENDING_HANDSHAKE_LOCATION);

        Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
        }

        public void lower(TruffleSafepointNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.pollSnippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("node", node.location());
            SnippetTemplate template = this.template(node, args);
            template.instantiate(this.providers.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

