/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import java.lang.ref.Reference;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;

final class HotSpotTruffleGraphBuilderPlugins {
    HotSpotTruffleGraphBuilderPlugins() {
    }

    static void registerCompilationFinalReferencePlugins(InvocationPlugins plugins, final boolean canDelayIntrinsification, final HotSpotKnownTruffleTypes types) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class));
        r.register1("get", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constant;
                if (!canDelayIntrinsification && receiver.isConstant() && (constant = (JavaConstant)receiver.get().asConstant()).isNonNull() && (types.classWeakReference.isInstance(constant) || types.classSoftReference.isInstance(constant))) {
                    JavaConstant referent = b.getConstantReflection().readFieldValue(types.referenceReferent, constant);
                    b.addPush(JavaKind.Object, ConstantNode.forConstant(referent, b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
    }
}

