/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.TruffleTierConfiguration;

public final class TruffleCompilerConfiguration {
    private final TruffleCompilerRuntime runtime;
    private final GraphBuilderConfiguration.Plugins plugins;
    private final SnippetReflectionProvider provider;
    private final TruffleTierConfiguration firstTier;
    private final TruffleTierConfiguration lastTier;

    public TruffleCompilerConfiguration(TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, SnippetReflectionProvider provider, TruffleTierConfiguration firstTier, TruffleTierConfiguration lastTier) {
        this.runtime = runtime;
        this.plugins = plugins;
        this.provider = provider;
        this.firstTier = firstTier;
        this.lastTier = lastTier;
    }

    public TruffleCompilerRuntime runtime() {
        return this.runtime;
    }

    public GraphBuilderConfiguration.Plugins plugins() {
        return this.plugins;
    }

    public SnippetReflectionProvider snippetReflection() {
        return this.provider;
    }

    public TruffleTierConfiguration firstTier() {
        return this.firstTier;
    }

    public TruffleTierConfiguration lastTier() {
        return this.lastTier;
    }

    public TruffleCompilerConfiguration withFirstTier(TruffleTierConfiguration tier) {
        return new TruffleCompilerConfiguration(this.runtime, this.plugins, this.provider, tier, this.lastTier);
    }

    public List<Backend> backends() {
        if (this.lastTier.backend() == this.firstTier.backend()) {
            return Arrays.asList(this.lastTier.backend());
        }
        return Arrays.asList(this.firstTier.backend(), this.lastTier.backend());
    }

    public Architecture architecture() {
        Architecture arch = this.lastTier().backend().getTarget().arch;
        assert (arch.equals((Object)this.firstTier().backend().getTarget().arch)) : "target architecture must be the same for first and list tier.";
        return arch;
    }
}

