/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactSplitNode;

@NodeInfo(cycles=NodeCycles.CYCLES_4, cyclesRationale="mul+cmp", size=NodeSize.SIZE_2)
public class IntegerMulExactOverflowNode
extends IntegerExactOverflowNode
implements Simplifiable,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerMulExactOverflowNode> TYPE = NodeClass.create(IntegerMulExactOverflowNode.class);

    public IntegerMulExactOverflowNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerMulExactOverflowNode(forY, forX).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return IntegerMulExactOverflowNode.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && ((c = forY.asJavaConstant().asLong()) == 1L || c == 0L)) {
            return LogicConstantNode.forBoolean(false);
        }
        if (!IntegerStamp.multiplicationCanOverflow((IntegerStamp)this.x.stamp(NodeView.DEFAULT), (IntegerStamp)this.y.stamp(NodeView.DEFAULT))) {
            return LogicConstantNode.forBoolean(false);
        }
        return this;
    }

    private static LogicConstantNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind());
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                Math.multiplyExact(xConst.asInt(), yConst.asInt());
            } else {
                assert (xConst.getJavaKind() == JavaKind.Long);
                Math.multiplyExact(xConst.asLong(), yConst.asLong());
            }
        }
        catch (ArithmeticException ex) {
            return LogicConstantNode.forBoolean(true);
        }
        return LogicConstantNode.forBoolean(false);
    }

    @Override
    protected IntegerExactArithmeticSplitNode createSplit(Stamp splitStamp, AbstractBeginNode next, AbstractBeginNode overflow) {
        return new IntegerMulExactSplitNode(splitStamp, this.x, this.y, next, overflow);
    }

    @Override
    protected Class<? extends BinaryNode> getCoupledType() {
        return IntegerMulExactNode.class;
    }
}

