/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LoadSnippetVarargParameterNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<LoadSnippetVarargParameterNode> TYPE = NodeClass.create(LoadSnippetVarargParameterNode.class);
    @Node.Input
    ValueNode index;
    @Node.Input
    NodeInputList<ParameterNode> parameters;

    public LoadSnippetVarargParameterNode(ParameterNode[] locals, ValueNode index, Stamp stamp) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.index = index;
        this.parameters = new NodeInputList((Node)this, (Node[])locals);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        int indexValue;
        if (this.index.isConstant() && (indexValue = this.index.asJavaConstant().asInt()) < this.parameters.size()) {
            return this.parameters.get(indexValue);
        }
        return this;
    }
}

