/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.ArrayList;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ExplodeLoopNode
extends FixedWithNextNode {
    public static final NodeClass<ExplodeLoopNode> TYPE = NodeClass.create(ExplodeLoopNode.class);

    public ExplodeLoopNode() {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
    }

    public LoopBeginNode findLoopBegin() {
        Node currentNext = this.next();
        ArrayList<Node> succs = new ArrayList<Node>();
        while (!(currentNext instanceof LoopBeginNode)) {
            assert (currentNext != null) : "cannot find loop after " + this;
            for (Node node : currentNext.cfgSuccessors()) {
                succs.add(node);
            }
            if (succs.size() == 1 && succs.get(0) != currentNext) {
                currentNext = (Node)succs.get(0);
                continue;
            }
            return null;
        }
        return (LoopBeginNode)currentNext;
    }

    @Node.NodeIntrinsic
    public static native void explodeLoop();
}

