/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.gc;

import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.extended.NullCheckNode;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.gc.WriteBarrierSnippets;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class G1WriteBarrierSnippets
extends WriteBarrierSnippets
implements Snippets {
    public static final LocationIdentity GC_LOG_LOCATION = NamedLocationIdentity.mutable("GC-Log");
    public static final LocationIdentity GC_INDEX_LOCATION = NamedLocationIdentity.mutable("GC-Index");
    public static final LocationIdentity SATB_QUEUE_MARKING_LOCATION = NamedLocationIdentity.mutable("GC-Queue-Marking");
    public static final LocationIdentity SATB_QUEUE_INDEX_LOCATION = NamedLocationIdentity.mutable("GC-Queue-Index");
    public static final LocationIdentity SATB_QUEUE_BUFFER_LOCATION = NamedLocationIdentity.mutable("GC-Queue-Buffer");
    public static final LocationIdentity CARD_QUEUE_INDEX_LOCATION = NamedLocationIdentity.mutable("GC-Card-Queue-Index");
    public static final LocationIdentity CARD_QUEUE_BUFFER_LOCATION = NamedLocationIdentity.mutable("GC-Card-Queue-Buffer");
    protected static final LocationIdentity[] KILLED_PRE_WRITE_BARRIER_STUB_LOCATIONS = new LocationIdentity[]{SATB_QUEUE_INDEX_LOCATION, SATB_QUEUE_BUFFER_LOCATION, GC_LOG_LOCATION, GC_INDEX_LOCATION};
    protected static final LocationIdentity[] KILLED_POST_WRITE_BARRIER_STUB_LOCATIONS = new LocationIdentity[]{CARD_QUEUE_INDEX_LOCATION, CARD_QUEUE_BUFFER_LOCATION, GC_LOG_LOCATION, GC_INDEX_LOCATION, GC_CARD_LOCATION};

    @Snippet
    public void g1PreWriteBarrier(AddressNode.Address address, Object object, Object expectedObject, @Snippet.ConstantParameter boolean doLoad, @Snippet.ConstantParameter boolean nullCheck, @Snippet.ConstantParameter int traceStartCycle, @Snippet.ConstantParameter Counters counters) {
        this.satbBarrier(address, object, expectedObject, doLoad, nullCheck, traceStartCycle, counters, false);
    }

    @Snippet
    public void g1ReferentReadBarrier(AddressNode.Address address, Object object, Object expectedObject, @Snippet.ConstantParameter boolean isDynamicCheck, Word offset, @Snippet.ConstantParameter int traceStartCycle, @Snippet.ConstantParameter Counters counters) {
        if (!isDynamicCheck || BranchProbabilityNode.probability(0.09999999999999998, offset == WordFactory.unsigned((long)this.referentOffset()))) {
            this.satbBarrier(address, object, expectedObject, false, false, traceStartCycle, counters, isDynamicCheck);
        }
    }

    private void satbBarrier(AddressNode.Address address, Object object, Object expectedObject, boolean doLoad, boolean nullCheck, int traceStartCycle, Counters counters, boolean checkForReferenceType) {
        if (nullCheck) {
            NullCheckNode.nullCheck(address);
        }
        Word thread = this.getThread();
        this.verifyOop(object);
        Word field = Word.fromAddress(address);
        byte markingValue = thread.readByte(this.satbQueueMarkingOffset(), SATB_QUEUE_MARKING_LOCATION);
        boolean trace = this.isTracingActive(traceStartCycle);
        int gcCycle = 0;
        if (trace) {
            Pointer gcTotalCollectionsAddress = (Pointer)WordFactory.pointer((long)this.gcTotalCollectionsAddress());
            gcCycle = gcTotalCollectionsAddress.readInt(0, LocationIdentity.any());
            this.log(trace, "[%d] G1-Pre Thread %p Object %p\n", gcCycle, thread.rawValue(), Word.objectToTrackedPointer(object).rawValue());
            this.log(trace, "[%d] G1-Pre Thread %p Expected Object %p\n", gcCycle, thread.rawValue(), Word.objectToTrackedPointer(expectedObject).rawValue());
            this.log(trace, "[%d] G1-Pre Thread %p Field %p\n", gcCycle, thread.rawValue(), field.rawValue());
            this.log(trace, "[%d] G1-Pre Thread %p Marking %d\n", gcCycle, thread.rawValue(), markingValue);
            this.log(trace, "[%d] G1-Pre Thread %p DoLoad %d\n", gcCycle, thread.rawValue(), doLoad ? 1L : 0L);
        }
        counters.g1AttemptedPreWriteBarrierCounter.inc();
        if (BranchProbabilityNode.probability(0.09999999999999998, markingValue != 0)) {
            Object previousObject;
            if (doLoad) {
                previousObject = field.readObject(0, OnHeapMemoryAccess.BarrierType.NONE, LocationIdentity.any());
                if (trace) {
                    this.log(trace, "[%d] G1-Pre Thread %p Previous Object %p\n ", gcCycle, thread.rawValue(), Word.objectToTrackedPointer(previousObject).rawValue());
                    this.verifyOop(previousObject);
                }
            } else {
                previousObject = FixedValueAnchorNode.getObject(expectedObject);
            }
            counters.g1EffectivePreWriteBarrierCounter.inc();
            if (BranchProbabilityNode.probability(0.9, previousObject != null)) {
                counters.g1ExecutedPreWriteBarrierCounter.inc();
                if (!checkForReferenceType || BranchProbabilityNode.probability(0.09999999999999998, InstanceOfNode.doInstanceof(this.referenceType(), object))) {
                    Word indexAddress = thread.add(this.satbQueueIndexOffset());
                    Word indexValue = (Word)indexAddress.readWord(0, SATB_QUEUE_INDEX_LOCATION);
                    if (BranchProbabilityNode.probability(0.9, indexValue.notEqual(0))) {
                        Word bufferAddress = (Word)thread.readWord(this.satbQueueBufferOffset(), SATB_QUEUE_BUFFER_LOCATION);
                        Word nextIndex = indexValue.subtract(this.wordSize());
                        Word logAddress = bufferAddress.add(nextIndex);
                        Word previousOop = Word.objectToTrackedPointer(previousObject);
                        logAddress.writeWord(0, (WordBase)previousOop, GC_LOG_LOCATION);
                        indexAddress.writeWord(0, (WordBase)nextIndex, GC_INDEX_LOCATION);
                    } else {
                        this.g1PreBarrierStub(previousObject);
                    }
                }
            }
        }
    }

    @Snippet
    public void g1PostWriteBarrier(AddressNode.Address address, Object object, Object value, @Snippet.ConstantParameter boolean usePrecise, @Snippet.ConstantParameter int traceStartCycle, @Snippet.ConstantParameter Counters counters) {
        Word oop;
        Word thread = this.getThread();
        Object fixedValue = FixedValueAnchorNode.getObject(value);
        this.verifyOop(object);
        this.verifyOop(fixedValue);
        this.validateObject(object, fixedValue);
        if (usePrecise) {
            oop = Word.fromAddress(address);
        } else {
            if (this.verifyBarrier()) {
                G1WriteBarrierSnippets.verifyNotArray(object);
            }
            oop = Word.objectToTrackedPointer(object);
        }
        boolean trace = this.isTracingActive(traceStartCycle);
        int gcCycle = 0;
        if (trace) {
            Pointer gcTotalCollectionsAddress = (Pointer)WordFactory.pointer((long)this.gcTotalCollectionsAddress());
            gcCycle = gcTotalCollectionsAddress.readInt(0, LocationIdentity.any());
            this.log(trace, "[%d] G1-Post Thread: %p Object: %p\n", gcCycle, thread.rawValue(), Word.objectToTrackedPointer(object).rawValue());
            this.log(trace, "[%d] G1-Post Thread: %p Field: %p\n", gcCycle, thread.rawValue(), oop.rawValue());
        }
        Word writtenValue = Word.objectToTrackedPointer(fixedValue);
        int logOfHeapRegionGrainBytes = this.logOfHeapRegionGrainBytes();
        UnsignedWord xorResult = oop.xor(writtenValue).unsignedShiftRight(logOfHeapRegionGrainBytes);
        counters.g1AttemptedPostWriteBarrierCounter.inc();
        if (BranchProbabilityNode.probability(0.9, xorResult.notEqual(0))) {
            counters.g1EffectiveAfterXORPostWriteBarrierCounter.inc();
            if (BranchProbabilityNode.probability(0.9, writtenValue.notEqual(0))) {
                Word cardAddress = this.cardTableAddress(oop);
                byte cardByte = cardAddress.readByte(0, GC_CARD_LOCATION);
                counters.g1EffectiveAfterNullPostWriteBarrierCounter.inc();
                if (BranchProbabilityNode.probability(0.09999999999999998, cardByte != this.youngCardValue())) {
                    MembarNode.memoryBarrier(4, GC_CARD_LOCATION);
                    byte cardByteReload = cardAddress.readByte(0, GC_CARD_LOCATION);
                    if (BranchProbabilityNode.probability(0.09999999999999998, cardByteReload != this.dirtyCardValue())) {
                        this.log(trace, "[%d] G1-Post Thread: %p Card: %p \n", gcCycle, thread.rawValue(), WordFactory.unsigned((int)cardByte).rawValue());
                        cardAddress.writeByte(0, this.dirtyCardValue(), GC_CARD_LOCATION);
                        counters.g1ExecutedPostWriteBarrierCounter.inc();
                        Word indexValue = (Word)thread.readWord(this.cardQueueIndexOffset(), CARD_QUEUE_INDEX_LOCATION);
                        if (BranchProbabilityNode.probability(0.9, indexValue.notEqual(0))) {
                            Word bufferAddress = (Word)thread.readWord(this.cardQueueBufferOffset(), CARD_QUEUE_BUFFER_LOCATION);
                            Word nextIndex = indexValue.subtract(this.wordSize());
                            Word logAddress = bufferAddress.add(nextIndex);
                            Word indexAddress = thread.add(this.cardQueueIndexOffset());
                            logAddress.writeWord(0, (WordBase)cardAddress, GC_LOG_LOCATION);
                            indexAddress.writeWord(0, (WordBase)nextIndex, GC_INDEX_LOCATION);
                        } else {
                            this.g1PostBarrierStub(cardAddress);
                        }
                    }
                }
            }
        }
    }

    @Snippet
    public void g1ArrayRangePreWriteBarrier(AddressNode.Address address, int length, @Snippet.ConstantParameter int elementStride) {
        Word thread = this.getThread();
        byte markingValue = thread.readByte(this.satbQueueMarkingOffset(), SATB_QUEUE_MARKING_LOCATION);
        if (BranchProbabilityNode.probability(0.9, markingValue == 0 || length == 0)) {
            return;
        }
        Word bufferAddress = (Word)thread.readWord(this.satbQueueBufferOffset(), SATB_QUEUE_BUFFER_LOCATION);
        Word indexAddress = thread.add(this.satbQueueIndexOffset());
        long indexValue = indexAddress.readWord(0, SATB_QUEUE_INDEX_LOCATION).rawValue();
        int scale = this.objectArrayIndexScale();
        Word start = G1WriteBarrierSnippets.getPointerToFirstArrayElement(address, length, elementStride);
        for (int i = 0; i < length; ++i) {
            Word arrElemPtr = start.add(i * scale);
            Object previousObject = arrElemPtr.readObject(0, OnHeapMemoryAccess.BarrierType.NONE, LocationIdentity.any());
            this.verifyOop(previousObject);
            if (!BranchProbabilityNode.probability(0.9, previousObject != null)) continue;
            if (BranchProbabilityNode.probability(0.9, indexValue != 0L)) {
                Word logAddress = bufferAddress.add((Word)WordFactory.unsigned((long)(indexValue -= (long)this.wordSize())));
                Word previousOop = Word.objectToTrackedPointer(previousObject);
                logAddress.writeWord(0, (WordBase)previousOop, GC_LOG_LOCATION);
                indexAddress.writeWord(0, (WordBase)WordFactory.unsigned((long)indexValue), GC_INDEX_LOCATION);
                continue;
            }
            this.g1PreBarrierStub(previousObject);
        }
    }

    @Snippet
    public void g1ArrayRangePostWriteBarrier(AddressNode.Address address, int length, @Snippet.ConstantParameter int elementStride) {
        if (BranchProbabilityNode.probability(0.09999999999999998, length == 0)) {
            return;
        }
        Word thread = this.getThread();
        Word bufferAddress = (Word)thread.readWord(this.cardQueueBufferOffset(), CARD_QUEUE_BUFFER_LOCATION);
        Word indexAddress = thread.add(this.cardQueueIndexOffset());
        long indexValue = thread.readWord(this.cardQueueIndexOffset(), CARD_QUEUE_INDEX_LOCATION).rawValue();
        Word start = this.cardTableAddress(G1WriteBarrierSnippets.getPointerToFirstArrayElement(address, length, elementStride));
        Word end = this.cardTableAddress(G1WriteBarrierSnippets.getPointerToLastArrayElement(address, length, elementStride));
        Word cur = start;
        do {
            byte cardByte;
            if (!BranchProbabilityNode.probability(0.09999999999999998, (cardByte = cur.readByte(0, GC_CARD_LOCATION)) != this.youngCardValue())) continue;
            MembarNode.memoryBarrier(4, GC_CARD_LOCATION);
            byte cardByteReload = cur.readByte(0, GC_CARD_LOCATION);
            if (!BranchProbabilityNode.probability(0.09999999999999998, cardByteReload != this.dirtyCardValue())) continue;
            cur.writeByte(0, this.dirtyCardValue(), GC_CARD_LOCATION);
            if (BranchProbabilityNode.probability(0.9, indexValue != 0L)) {
                Word logAddress = bufferAddress.add((Word)WordFactory.unsigned((long)(indexValue -= (long)this.wordSize())));
                logAddress.writeWord(0, (WordBase)cur, GC_LOG_LOCATION);
                indexAddress.writeWord(0, (WordBase)WordFactory.unsigned((long)indexValue), GC_INDEX_LOCATION);
                continue;
            }
            this.g1PostBarrierStub(cur);
        } while ((cur = cur.add(1)).belowOrEqual(end));
    }

    protected abstract Word getThread();

    protected abstract int wordSize();

    protected abstract int objectArrayIndexScale();

    protected abstract int satbQueueMarkingOffset();

    protected abstract int satbQueueBufferOffset();

    protected abstract int satbQueueIndexOffset();

    protected abstract int cardQueueBufferOffset();

    protected abstract int cardQueueIndexOffset();

    protected abstract byte dirtyCardValue();

    protected abstract byte youngCardValue();

    protected abstract Word cardTableAddress(Pointer var1);

    protected abstract int logOfHeapRegionGrainBytes();

    protected abstract ForeignCallDescriptor preWriteBarrierCallDescriptor();

    protected abstract ForeignCallDescriptor postWriteBarrierCallDescriptor();

    protected abstract boolean verifyOops();

    protected abstract boolean verifyBarrier();

    protected abstract long gcTotalCollectionsAddress();

    protected abstract ForeignCallDescriptor verifyOopCallDescriptor();

    protected abstract ForeignCallDescriptor validateObjectCallDescriptor();

    protected abstract ForeignCallDescriptor printfCallDescriptor();

    protected abstract ResolvedJavaType referenceType();

    protected abstract long referentOffset();

    private boolean isTracingActive(int traceStartCycle) {
        return traceStartCycle > 0 && ((Pointer)WordFactory.pointer((long)this.gcTotalCollectionsAddress())).readInt(0) > traceStartCycle;
    }

    private void log(boolean enabled, String format, long value1, long value2, long value3) {
        if (enabled) {
            G1WriteBarrierSnippets.printf(this.printfCallDescriptor(), CStringConstant.cstring(format), value1, value2, value3);
        }
    }

    private void validateObject(Object parent, Object child) {
        if (this.verifyOops() && child != null) {
            Word parentWord = Word.objectToTrackedPointer(parent);
            Word childWord = Word.objectToTrackedPointer(child);
            boolean success = G1WriteBarrierSnippets.validateOop(this.validateObjectCallDescriptor(), parentWord, childWord);
            AssertionNode.dynamicAssert(success, "Verification ERROR, Parent: %p Child: %p\n", parentWord.rawValue(), childWord.rawValue());
        }
    }

    private void verifyOop(Object object) {
        if (this.verifyOops()) {
            G1WriteBarrierSnippets.verifyOopStub(this.verifyOopCallDescriptor(), object);
        }
    }

    private void g1PreBarrierStub(Object previousObject) {
        G1WriteBarrierSnippets.g1PreBarrierStub(this.preWriteBarrierCallDescriptor(), previousObject);
    }

    private void g1PostBarrierStub(Word cardAddress) {
        G1WriteBarrierSnippets.g1PostBarrierStub(this.postWriteBarrierCallDescriptor(), cardAddress);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object verifyOopStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native boolean validateOop(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void g1PreBarrierStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void g1PostBarrierStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void printf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, long var2, long var4, long var6);

    public static abstract class G1WriteBarrierLowerer {
        private final Counters counters;

        public G1WriteBarrierLowerer(SnippetCounter.Group.Factory factory) {
            this.counters = new Counters(factory);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo snippet, G1PreWriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            AddressNode address = barrier.getAddress();
            args.add("address", address);
            if (address instanceof OffsetAddressNode) {
                args.add("object", ((OffsetAddressNode)address).getBase());
            } else {
                args.add("object", null);
            }
            ValueNode expected = barrier.getExpectedObject();
            if (expected != null && expected.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp) {
                expected = this.uncompress(expected);
            }
            args.add("expectedObject", expected);
            args.addConst("doLoad", barrier.doLoad());
            args.addConst("nullCheck", barrier.getNullCheck());
            args.addConst("traceStartCycle", G1WriteBarrierLowerer.traceStartCycle(barrier.graph()));
            args.addConst("counters", this.counters);
            templates.template(barrier, args).instantiate(templates.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo snippet, G1ReferentFieldReadBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            args.add("address", address);
            args.add("object", address.getBase());
            ValueNode expected = barrier.getExpectedObject();
            if (expected != null && expected.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp) {
                expected = this.uncompress(expected);
            }
            args.add("expectedObject", expected);
            args.addConst("isDynamicCheck", barrier.isDynamicCheck());
            args.add("offset", address.getOffset());
            args.addConst("traceStartCycle", G1WriteBarrierLowerer.traceStartCycle(barrier.graph()));
            args.addConst("counters", this.counters);
            templates.template(barrier, args).instantiate(templates.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo snippet, G1PostWriteBarrier barrier, LoweringTool tool) {
            if (barrier.alwaysNull()) {
                barrier.graph().removeFixed(barrier);
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            AddressNode address = barrier.getAddress();
            args.add("address", address);
            if (address instanceof OffsetAddressNode) {
                args.add("object", ((OffsetAddressNode)address).getBase());
            } else {
                assert (barrier.usePrecise()) : "found imprecise barrier that's not an object access " + barrier;
                args.add("object", null);
            }
            ValueNode value = barrier.getValue();
            if (value.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp) {
                value = this.uncompress(value);
            }
            args.add("value", value);
            args.addConst("usePrecise", barrier.usePrecise());
            args.addConst("traceStartCycle", G1WriteBarrierLowerer.traceStartCycle(barrier.graph()));
            args.addConst("counters", this.counters);
            templates.template(barrier, args).instantiate(templates.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo snippet, G1ArrayRangePreWriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("address", barrier.getAddress());
            args.add("length", barrier.getLength());
            args.addConst("elementStride", barrier.getElementStride());
            templates.template(barrier, args).instantiate(templates.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo snippet, G1ArrayRangePostWriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("address", barrier.getAddress());
            args.add("length", barrier.getLength());
            args.addConst("elementStride", barrier.getElementStride());
            templates.template(barrier, args).instantiate(templates.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private static int traceStartCycle(StructuredGraph graph) {
            return GraalOptions.GCDebugStartCycle.getValue(graph.getOptions());
        }

        protected abstract ValueNode uncompress(ValueNode var1);
    }

    public static class Counters {
        final SnippetCounter g1AttemptedPreWriteBarrierCounter;
        final SnippetCounter g1EffectivePreWriteBarrierCounter;
        final SnippetCounter g1ExecutedPreWriteBarrierCounter;
        final SnippetCounter g1AttemptedPostWriteBarrierCounter;
        final SnippetCounter g1EffectiveAfterXORPostWriteBarrierCounter;
        final SnippetCounter g1EffectiveAfterNullPostWriteBarrierCounter;
        final SnippetCounter g1ExecutedPostWriteBarrierCounter;

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group countersWriteBarriers = factory.createSnippetCounterGroup("G1 WriteBarriers");
            this.g1AttemptedPreWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1AttemptedPreWriteBarrier", "Number of attempted G1 Pre Write Barriers");
            this.g1EffectivePreWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1EffectivePreWriteBarrier", "Number of effective G1 Pre Write Barriers");
            this.g1ExecutedPreWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1ExecutedPreWriteBarrier", "Number of executed G1 Pre Write Barriers");
            this.g1AttemptedPostWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1AttemptedPostWriteBarrier", "Number of attempted G1 Post Write Barriers");
            this.g1EffectiveAfterXORPostWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1EffectiveAfterXORPostWriteBarrier", "Number of effective G1 Post Write Barriers (after passing the XOR test)");
            this.g1EffectiveAfterNullPostWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1EffectiveAfterNullPostWriteBarrier", "Number of effective G1 Post Write Barriers (after passing the NULL test)");
            this.g1ExecutedPostWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "g1ExecutedPostWriteBarrier", "Number of executed G1 Post Write Barriers");
        }
    }
}

