/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

public interface ArrayCopy
extends Virtualizable,
SingleMemoryKill,
MemoryAccess,
Lowerable,
DeoptimizingNode.DeoptDuring {
    public static final int SRC_ARG = 0;
    public static final int SRC_POS_ARG = 1;
    public static final int DEST_ARG = 2;
    public static final int DEST_POS_ARG = 3;
    public static final int LENGTH_ARG = 4;

    public NodeInputList<ValueNode> args();

    default public ValueNode getSource() {
        return (ValueNode)this.args().get(0);
    }

    default public ValueNode getSourcePosition() {
        return (ValueNode)this.args().get(1);
    }

    default public ValueNode getDestination() {
        return (ValueNode)this.args().get(2);
    }

    default public ValueNode getDestinationPosition() {
        return (ValueNode)this.args().get(3);
    }

    default public ValueNode getLength() {
        return (ValueNode)this.args().get(4);
    }

    public int getBci();

    public JavaKind getElementKind();

    default public boolean checkBounds(int position, int length, VirtualObjectNode virtualObject) {
        if (!1.$assertionsDisabled && length < 0) {
            throw new AssertionError();
        }
        return position >= 0 && position <= virtualObject.entryCount() - length;
    }

    default public boolean checkEntryTypes(int srcPos, int length, VirtualObjectNode src, ResolvedJavaType destComponentType, VirtualizerTool tool) {
        if (destComponentType.getJavaKind() == JavaKind.Object && !destComponentType.isJavaLangObject()) {
            for (int i = 0; i < length; ++i) {
                ValueNode entry = tool.getEntry(src, srcPos + i);
                ResolvedJavaType type = StampTool.typeOrNull(entry);
                if (type != null && destComponentType.isAssignableFrom(type)) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean isExact() {
        ResolvedJavaType srcType = StampTool.typeOrNull(this.getSource().stamp(NodeView.DEFAULT));
        ResolvedJavaType destType = StampTool.typeOrNull(this.getDestination().stamp(NodeView.DEFAULT));
        if (srcType == null || !srcType.isArray() || destType == null || !destType.isArray()) {
            return false;
        }
        if (srcType.getComponentType().getJavaKind().isPrimitive() && destType.getComponentType().equals(srcType.getComponentType()) || this.getSource() == this.getDestination()) {
            return true;
        }
        return StampTool.isExactType(this.getDestination().stamp(NodeView.DEFAULT)) && destType != null && destType.isAssignableFrom(srcType);
    }

    @Override
    default public void virtualize(VirtualizerTool tool) {
        ValueNode sourcePosition = tool.getAlias(this.getSourcePosition());
        ValueNode destinationPosition = tool.getAlias(this.getDestinationPosition());
        ValueNode replacedLength = tool.getAlias(this.getLength());
        if (sourcePosition.isConstant() && destinationPosition.isConstant() && replacedLength.isConstant()) {
            int srcPosInt = sourcePosition.asJavaConstant().asInt();
            int destPosInt = destinationPosition.asJavaConstant().asInt();
            int len = replacedLength.asJavaConstant().asInt();
            ValueNode destAlias = tool.getAlias(this.getDestination());
            if (destAlias instanceof VirtualArrayNode) {
                VirtualArrayNode destVirtual = (VirtualArrayNode)destAlias;
                if (len < 0 || !this.checkBounds(destPosInt, len, destVirtual)) {
                    return;
                }
                ValueNode srcAlias = tool.getAlias(this.getSource());
                if (srcAlias instanceof VirtualObjectNode) {
                    int i;
                    if (!(srcAlias instanceof VirtualArrayNode)) {
                        return;
                    }
                    VirtualArrayNode srcVirtual = (VirtualArrayNode)srcAlias;
                    if (destVirtual.componentType().getJavaKind() != srcVirtual.componentType().getJavaKind()) {
                        return;
                    }
                    if (!this.checkBounds(srcPosInt, len, srcVirtual)) {
                        return;
                    }
                    if (!this.checkEntryTypes(srcPosInt, len, srcVirtual, destVirtual.type().getComponentType(), tool)) {
                        return;
                    }
                    if (srcVirtual == destVirtual && srcPosInt < destPosInt) {
                        for (i = len - 1; i >= 0; --i) {
                            tool.setVirtualEntry(destVirtual, destPosInt + i, tool.getEntry(srcVirtual, srcPosInt + i));
                        }
                    } else {
                        for (i = 0; i < len; ++i) {
                            tool.setVirtualEntry(destVirtual, destPosInt + i, tool.getEntry(srcVirtual, srcPosInt + i));
                        }
                    }
                    tool.delete();
                    DebugContext debug = this.asNode().getDebug();
                    if (debug.isLogEnabled()) {
                        debug.log("virtualized arraycopy(%s, %d, %s, %d, %d)", this.getSource(), (Object)srcPosInt, (Object)this.getDestination(), (Object)destPosInt, (Object)len);
                    }
                } else {
                    ResolvedJavaType destComponentType;
                    ResolvedJavaType sourceType = StampTool.typeOrNull(srcAlias);
                    if (sourceType == null || !sourceType.isArray()) {
                        return;
                    }
                    ResolvedJavaType sourceComponentType = sourceType.getComponentType();
                    if (!sourceComponentType.equals(destComponentType = destVirtual.type().getComponentType())) {
                        return;
                    }
                    for (int i = 0; i < len; ++i) {
                        LoadIndexedNode load = new LoadIndexedNode(this.asNode().graph().getAssumptions(), srcAlias, ConstantNode.forInt(i + srcPosInt, this.asNode().graph()), null, destComponentType.getJavaKind());
                        load.setNodeSourcePosition(this.asNode().getNodeSourcePosition());
                        tool.addNode(load);
                        tool.setVirtualEntry(destVirtual, destPosInt + i, load);
                    }
                    tool.delete();
                }
            }
        }
    }

    @Override
    default public boolean canDeoptimize() {
        return true;
    }

    @Override
    default public boolean hasSideEffect() {
        return !this.getKilledLocationIdentity().isInit();
    }

    @Override
    default public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring = currentStateAfter.duplicateModifiedDuringCall(this.getBci(), this.asNode().getStackKind());
        this.setStateDuring(newStateDuring);
    }

    public static JavaKind selectComponentKind(ArrayCopy arraycopy) {
        ResolvedJavaType srcType = StampTool.typeOrNull(arraycopy.getSource().stamp(NodeView.DEFAULT));
        ResolvedJavaType destType = StampTool.typeOrNull(arraycopy.getDestination().stamp(NodeView.DEFAULT));
        if (srcType == null || !srcType.isArray() || destType == null || !destType.isArray()) {
            return null;
        }
        if (!destType.getComponentType().isAssignableFrom(srcType.getComponentType())) {
            return null;
        }
        if (!arraycopy.isExact()) {
            return null;
        }
        return srcType.getComponentType().getJavaKind();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

