/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.amd64.AMD64StringUTF16CompressNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;

@ClassSubstitution(className={"java.lang.StringUTF16"}, optional=true)
public class AMD64StringUTF16Substitutions {
    static final MetaAccessProvider INJECTED = null;

    private static int length(byte[] value) {
        return value.length >> 1;
    }

    @MethodSubstitution
    public static int indexOfCharUnsafe(byte[] value, int ch, int fromIndex, int max) {
        return AMD64ArrayIndexOf.indexOf1Char(value, max, fromIndex, (char)ch);
    }

    private static Word pointer(byte[] target) {
        return Word.objectToTrackedPointer(target).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED));
    }

    private static Word charOffsetPointer(byte[] value, int offset) {
        return AMD64StringUTF16Substitutions.pointer(value).add(offset * ReplacementsUtil.charArrayIndexScale(INJECTED));
    }

    private static native char getChar(byte[] var0, int var1);

    @MethodSubstitution
    public static int indexOfUnsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfUnsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfUnsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= AMD64StringUTF16Substitutions.length(target), "StringUTF16.indexOfUnsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfUnsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return AMD64ArrayIndexOf.indexOf1Char(source, sourceCount, fromIndex, AMD64StringUTF16Substitutions.getChar(target, 0));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        int offset = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            Word targetPointer;
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, offset, AMD64StringUTF16Substitutions.getChar(target, 0), AMD64StringUTF16Substitutions.getChar(target, 1));
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            offset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return offset;
            }
            Word cmpSourcePointer = AMD64StringUTF16Substitutions.charOffsetPointer(source, offset);
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = AMD64StringUTF16Substitutions.pointer(target), targetCount, JavaKind.Char))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static int indexOfLatin1Unsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfLatin1Unsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= target.length, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfLatin1Unsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return AMD64ArrayIndexOf.indexOf1Char(source, sourceCount, fromIndex, (char)Byte.toUnsignedInt(target[0]));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        int offset = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            Word targetPointer;
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, offset, (char)Byte.toUnsignedInt(target[0]), (char)Byte.toUnsignedInt(target[1]));
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            offset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return offset;
            }
            Word cmpSourcePointer = AMD64StringUTF16Substitutions.charOffsetPointer(source, offset);
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = AMD64StringUTF16Substitutions.pointer(target), targetCount, JavaKind.Char, JavaKind.Byte))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static int compress(char[] src, int srcIndex, byte[] dest, int destIndex, int len) {
        AMD64StringUTF16Substitutions.checkLimits(src.length, srcIndex, dest.length, destIndex, len);
        Word srcPointer = Word.objectToTrackedPointer(src).add(ReplacementsUtil.charArrayBaseOffset(INJECTED)).add(srcIndex * ReplacementsUtil.charArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED)).add(destIndex * ReplacementsUtil.byteArrayIndexScale(INJECTED));
        return AMD64StringUTF16CompressNode.compress(srcPointer, destPointer, len, JavaKind.Char);
    }

    @MethodSubstitution
    public static int compress(byte[] src, int srcIndex, byte[] dest, int destIndex, int len) {
        AMD64StringUTF16Substitutions.checkLimits(src.length >> 1, srcIndex, dest.length, destIndex, len);
        Word srcPointer = Word.objectToTrackedPointer(src).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED)).add(srcIndex * 2 * ReplacementsUtil.byteArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED)).add(destIndex * ReplacementsUtil.byteArrayIndexScale(INJECTED));
        return AMD64StringUTF16CompressNode.compress(srcPointer, destPointer, len, JavaKind.Byte);
    }

    private static void checkLimits(int srcLen, int srcIndex, int destLen, int destIndex, int len) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, len < 0) || GraalDirectives.injectBranchProbability(1.0E-4, srcIndex < 0) || GraalDirectives.injectBranchProbability(1.0E-4, srcIndex + len > srcLen) || GraalDirectives.injectBranchProbability(1.0E-4, destIndex < 0) || GraalDirectives.injectBranchProbability(1.0E-4, destIndex + len > destLen)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
    }
}

