/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public final class AMD64StringLatin1InflateNode
extends FixedWithNextNode
implements LIRLowerable,
MultiMemoryKill,
MemoryAccess {
    public static final NodeClass<AMD64StringLatin1InflateNode> TYPE = NodeClass.create(AMD64StringLatin1InflateNode.class);
    @Node.Input
    private ValueNode src;
    @Node.Input
    private ValueNode dst;
    @Node.Input
    private ValueNode len;
    private final JavaKind writeKind;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lla;

    public AMD64StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, JavaKind writeKind) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.writeKind = writeKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(JavaKind.Byte);
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(this.writeKind)};
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lgt = gen.getLIRGeneratorTool();
        lgt.emitStringLatin1Inflate(gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len));
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lla;
    }

    @Override
    public void setLastLocationAccess(MemoryKill newlla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lla), ValueNodeUtil.asNode(newlla));
        this.lla = newlla;
    }

    @Node.NodeIntrinsic
    public static native void inflate(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter JavaKind var3);
}

