/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.amd64.AMD64CountLeadingZerosNode;
import org.graalvm.compiler.replacements.amd64.AMD64CountTrailingZerosNode;
import org.graalvm.compiler.replacements.amd64.AMD64IntegerSubstitutions;
import org.graalvm.compiler.replacements.nodes.BitScanForwardNode;
import org.graalvm.compiler.replacements.nodes.BitScanReverseNode;

@ClassSubstitution(value=Long.class)
public class AMD64LongSubstitutions {
    @MethodSubstitution
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"}, justification="foldable method parameters are injected")
    public static int numberOfLeadingZeros(long i) {
        if (AMD64IntegerSubstitutions.lzcnt(NodeIntrinsificationProvider.INJECTED_TARGET)) {
            return AMD64CountLeadingZerosNode.countLeadingZeros(i);
        }
        if (i == 0L) {
            return 64;
        }
        return 63 - BitScanReverseNode.unsafeScan(i);
    }

    @MethodSubstitution
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"}, justification="foldable method parameters are injected")
    public static int numberOfTrailingZeros(long i) {
        if (AMD64IntegerSubstitutions.tzcnt(NodeIntrinsificationProvider.INJECTED_TARGET)) {
            return AMD64CountTrailingZerosNode.countTrailingZeros(i);
        }
        if (i == 0L) {
            return 64;
        }
        return BitScanForwardNode.unsafeScan(i);
    }
}

