/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.UnaryArithmeticNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_1)
public final class AMD64FloatConvertNode
extends UnaryArithmeticNode<ArithmeticOpTable.FloatConvertOp>
implements ArithmeticLIRLowerable {
    public static final NodeClass<AMD64FloatConvertNode> TYPE = NodeClass.create(AMD64FloatConvertNode.class);
    protected final FloatConvert op;

    public AMD64FloatConvertNode(FloatConvert op, ValueNode value) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(value).getFloatConvert(op), value);
        this.op = op;
        this.stamp = this.stamp.meet(this.createInexactCaseStamp());
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.FloatConvertOp> getOp(ArithmeticOpTable table) {
        return table.getFloatConvert(this.op);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        return this;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        Stamp foldedStamp = super.foldStamp(newStamp);
        return foldedStamp.meet(this.createInexactCaseStamp());
    }

    private Stamp createInexactCaseStamp() {
        IntegerStamp intStamp = (IntegerStamp)this.stamp;
        long inexactValue = intStamp.getBits() <= 32 ? 0x80000000L : Long.MIN_VALUE;
        return StampFactory.forConstant((JavaConstant)JavaConstant.forPrimitiveInt((int)intStamp.getBits(), (long)inexactValue));
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitFloatConvert(this.op, nodeValueMap.operand(this.getValue())));
    }
}

