/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class AMD64ArrayRegionEqualsWithMaskNode
extends FixedWithNextNode
implements Lowerable,
MemoryAccess,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<AMD64ArrayRegionEqualsWithMaskNode> TYPE = NodeClass.create(AMD64ArrayRegionEqualsWithMaskNode.class);
    private final JavaKind arrayKind;
    private final JavaKind kind1;
    private final JavaKind kind2;
    private final JavaKind kindMask;
    @Node.Input
    private ValueNode array1;
    @Node.Input
    private ValueNode fromIndex1;
    @Node.Input
    private ValueNode array2;
    @Node.Input
    private ValueNode fromIndex2;
    @Node.Input
    private ValueNode arrayMask;
    @Node.Input
    private ValueNode length;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public AMD64ArrayRegionEqualsWithMaskNode(ValueNode array1, ValueNode fromIndex1, ValueNode array2, ValueNode fromIndex2, ValueNode arrayMask, ValueNode length, @Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind kind1, @Node.ConstantNodeParameter JavaKind kind2, @Node.ConstantNodeParameter JavaKind kindMask) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.arrayKind = arrayKind;
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.kindMask = kindMask;
        this.array1 = array1;
        this.fromIndex1 = fromIndex1;
        this.array2 = array2;
        this.fromIndex2 = fromIndex2;
        this.arrayMask = arrayMask;
        this.length = length;
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getKind1() {
        return this.kind1;
    }

    public JavaKind getKind2() {
        return this.kind2;
    }

    public JavaKind getKindMask() {
        return this.kindMask;
    }

    public ValueNode getArray1() {
        return this.array1;
    }

    public ValueNode getFromIndex1() {
        return this.fromIndex1;
    }

    public ValueNode getArray2() {
        return this.array2;
    }

    public ValueNode getFromIndex2() {
        return this.fromIndex2;
    }

    public ValueNode getArrayMask() {
        return this.arrayMask;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public boolean sameKinds() {
        return this.kind1 == this.arrayKind && this.kind2 == this.arrayKind && this.kindMask == this.arrayKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.sameKinds() ? LocationIdentity.ANY_LOCATION : NamedLocationIdentity.getArrayLocation(this.arrayKind);
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Node.NodeIntrinsic
    private static native boolean regionEquals(Object var0, int var1, Object var2, int var3, Object var4, int var5, @Node.ConstantNodeParameter JavaKind var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter JavaKind var8, @Node.ConstantNodeParameter JavaKind var9);

    public static boolean regionEquals(byte[] value, int fromIndex1, byte[] value2, int fromIndex2, byte[] mask) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(value, fromIndex1, value2, fromIndex2, mask, mask.length, JavaKind.Byte, JavaKind.Byte, JavaKind.Byte, JavaKind.Byte);
    }

    public static boolean regionEquals(char[] value, int fromIndex1, char[] value2, int fromIndex2, char[] mask) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(value, fromIndex1, value2, fromIndex2, mask, mask.length, JavaKind.Char, JavaKind.Char, JavaKind.Char, JavaKind.Char);
    }

    public static boolean regionEquals(byte[] value, int fromIndex1, byte[] value2, int fromIndex2, byte[] mask, int length, JavaKind kind1, JavaKind kind2, JavaKind kindMask) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(value, fromIndex1, value2, fromIndex2, mask, length, JavaKind.Byte, kind1, kind2, kindMask);
    }
}

