/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public class AMD64ArrayIndexOfWithMaskNode
extends FixedWithNextNode
implements Lowerable,
MemoryAccess,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<AMD64ArrayIndexOfWithMaskNode> TYPE = NodeClass.create(AMD64ArrayIndexOfWithMaskNode.class);
    private final JavaKind arrayKind;
    private final JavaKind valueKind;
    private final boolean findTwoConsecutive;
    @Node.Input
    private ValueNode arrayPointer;
    @Node.Input
    private ValueNode arrayLength;
    @Node.Input
    private ValueNode fromIndex;
    @Node.Input
    private ValueNode searchValue;
    @Node.Input
    private ValueNode mask;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public AMD64ArrayIndexOfWithMaskNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode searchValue, ValueNode mask) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.arrayKind = arrayKind;
        this.valueKind = valueKind;
        this.findTwoConsecutive = findTwoConsecutive;
        this.arrayPointer = arrayPointer;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValue = searchValue;
        this.mask = mask;
    }

    public boolean isFindTwoConsecutive() {
        return this.findTwoConsecutive;
    }

    public ValueNode getArrayPointer() {
        return this.arrayPointer;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getFromIndex() {
        return this.fromIndex;
    }

    public ValueNode getSearchValue() {
        return this.searchValue;
    }

    public ValueNode getMask() {
        return this.mask;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getValueKind() {
        return this.valueKind;
    }

    public JavaKind getComparisonKind() {
        return this.findTwoConsecutive ? (this.valueKind == JavaKind.Byte ? JavaKind.Char : JavaKind.Int) : this.valueKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.arrayKind);
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, int var6, int var7);

    public static int indexOfWithMask(byte[] array, int arrayLength, int fromIndex, byte searchValue, byte mask) {
        return AMD64ArrayIndexOfWithMaskNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, searchValue, mask);
    }

    public static int indexOfWithMask(char[] array, int arrayLength, int fromIndex, char searchValue, char mask) {
        return AMD64ArrayIndexOfWithMaskNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, searchValue, mask);
    }

    public static int indexOfWithMask(byte[] array, int arrayLength, int fromIndex, char searchValue, char mask) {
        return AMD64ArrayIndexOfWithMaskNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, searchValue, mask);
    }

    public static int indexOf2ConsecutiveBytesWithMask(byte[] array, int arrayLength, int fromIndex, int searchValue, int mask) {
        return AMD64ArrayIndexOfWithMaskNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, true, (Object)array, arrayLength, fromIndex, searchValue, mask);
    }

    public static int indexOf2ConsecutiveCharsWithMask(char[] array, int arrayLength, int fromIndex, int searchValue, int mask) {
        return AMD64ArrayIndexOfWithMaskNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, true, (Object)array, arrayLength, fromIndex, searchValue, mask);
    }

    public static int indexOf2ConsecutiveCharsWithMask(byte[] array, int arrayLength, int fromIndex, int searchValue, int mask) {
        return AMD64ArrayIndexOfWithMaskNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, true, (Object)array, arrayLength, fromIndex, searchValue, mask);
    }
}

