/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public class AMD64ArrayIndexOfNode
extends FixedWithNextNode
implements LIRLowerable,
MemoryAccess {
    public static final NodeClass<AMD64ArrayIndexOfNode> TYPE = NodeClass.create(AMD64ArrayIndexOfNode.class);
    protected final JavaKind arrayKind;
    protected final JavaKind valueKind;
    protected final boolean findTwoConsecutive;
    @Node.Input
    protected ValueNode arrayPointer;
    @Node.Input
    protected ValueNode arrayLength;
    @Node.Input
    protected ValueNode fromIndex;
    @Node.Input
    protected NodeInputList<ValueNode> searchValues;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;

    public AMD64ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, arrayKind, valueKind, findTwoConsecutive, arrayPointer, arrayLength, fromIndex, searchValues);
    }

    protected AMD64ArrayIndexOfNode(NodeClass<? extends AMD64ArrayIndexOfNode> c, @Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super((NodeClass<? extends FixedWithNextNode>)c, StampFactory.forKind(JavaKind.Int));
        this.arrayKind = arrayKind;
        this.valueKind = valueKind;
        this.findTwoConsecutive = findTwoConsecutive;
        this.arrayPointer = arrayPointer;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.arrayKind);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Value[] searchValueOperands = new Value[this.searchValues.size()];
        for (int i = 0; i < this.searchValues.size(); ++i) {
            searchValueOperands[i] = gen.operand((Node)this.searchValues.get(i));
        }
        int arrayBaseOffset = gen.getLIRGeneratorTool().getMetaAccess().getArrayBaseOffset(this.arrayKind);
        Variable result = gen.getLIRGeneratorTool().emitArrayIndexOf(arrayBaseOffset, this.valueKind, this.findTwoConsecutive, gen.operand(this.arrayPointer), gen.operand(this.arrayLength), gen.operand(this.fromIndex), searchValueOperands);
        gen.setResult(this, (Value)result);
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7, byte var8);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7, byte var8, byte var9);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7, char var8);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7, char var8, char var9);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, int var6);
}

