/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.aarch64;

import java.lang.reflect.Type;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbsNode;
import org.graalvm.compiler.nodes.calc.IntegerMulHighNode;
import org.graalvm.compiler.nodes.calc.MaxNode;
import org.graalvm.compiler.nodes.calc.MinNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.replacements.aarch64.AArch64BitCountNode;
import org.graalvm.compiler.replacements.aarch64.AArch64CountLeadingZerosNode;
import org.graalvm.compiler.replacements.aarch64.AArch64CountTrailingZerosNode;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.FusedMultiplyAddNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class AArch64GraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    @Override
    public void register(GraphBuilderConfiguration.Plugins plugins, Replacements replacements, Architecture arch, boolean explicitUnsafeNullChecks, boolean registerForeignCallMath, boolean useFMAIntrinsics, OptionValues options) {
        AArch64GraphBuilderPlugins.register(plugins, replacements, registerForeignCallMath, useFMAIntrinsics, options);
    }

    public static void register(GraphBuilderConfiguration.Plugins plugins, final Replacements replacements, final boolean registerForeignCallMath, final boolean useFMAIntrinsics, final OptionValues options) {
        final InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                AArch64GraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Int, replacements);
                AArch64GraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Long, replacements);
                AArch64GraphBuilderPlugins.registerMathPlugins(invocationPlugins, registerForeignCallMath, useFMAIntrinsics);
                if (JavaVersionUtil.JAVA_SPEC >= 9 && GraalOptions.EmitStringSubstitutions.getValue(options).booleanValue()) {
                    AArch64GraphBuilderPlugins.registerStringLatin1Plugins(invocationPlugins, replacements);
                    AArch64GraphBuilderPlugins.registerStringUTF16Plugins(invocationPlugins, replacements);
                }
            }
        });
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, JavaKind kind, Replacements replacements) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass, replacements);
        r.register1("numberOfLeadingZeros", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ValueNode folded = AArch64CountLeadingZerosNode.tryFold(value);
                if (folded != null) {
                    b.addPush(JavaKind.Int, folded);
                } else {
                    b.addPush(JavaKind.Int, new AArch64CountLeadingZerosNode(value));
                }
                return true;
            }
        });
        r.register1("numberOfTrailingZeros", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ValueNode folded = AArch64CountTrailingZerosNode.tryFold(value);
                if (folded != null) {
                    b.addPush(JavaKind.Int, folded);
                } else {
                    b.addPush(JavaKind.Int, new AArch64CountTrailingZerosNode(value));
                }
                return true;
            }
        });
        r.register1("bitCount", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new AArch64BitCountNode(value).canonical(null)));
                return true;
            }
        });
    }

    private static void registerMathPlugins(InvocationPlugins plugins, boolean registerForeignCallMath, boolean useFMAIntrinsics) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Math.class));
        if (registerForeignCallMath) {
            AArch64GraphBuilderPlugins.registerUnaryMath(r, "sin", UnaryMathIntrinsicNode.UnaryOperation.SIN);
            AArch64GraphBuilderPlugins.registerUnaryMath(r, "cos", UnaryMathIntrinsicNode.UnaryOperation.COS);
            AArch64GraphBuilderPlugins.registerUnaryMath(r, "tan", UnaryMathIntrinsicNode.UnaryOperation.TAN);
            AArch64GraphBuilderPlugins.registerUnaryMath(r, "exp", UnaryMathIntrinsicNode.UnaryOperation.EXP);
            AArch64GraphBuilderPlugins.registerUnaryMath(r, "log", UnaryMathIntrinsicNode.UnaryOperation.LOG);
            AArch64GraphBuilderPlugins.registerUnaryMath(r, "log10", UnaryMathIntrinsicNode.UnaryOperation.LOG10);
            r.register2("pow", Double.TYPE, Double.TYPE, new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(JavaKind.Double, b.append(BinaryMathIntrinsicNode.create(x, y, BinaryMathIntrinsicNode.BinaryOperation.POW)));
                    return true;
                }
            });
        }
        if (useFMAIntrinsics && JavaVersionUtil.JAVA_SPEC > 8) {
            AArch64GraphBuilderPlugins.registerFMA(r);
        }
        AArch64GraphBuilderPlugins.registerIntegerAbs(r);
        if (JavaVersionUtil.JAVA_SPEC >= 10) {
            r.register2("multiplyHigh", Long.TYPE, Long.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(JavaKind.Long, b.append(new IntegerMulHighNode(x, y)));
                    return true;
                }
            });
        }
        AArch64GraphBuilderPlugins.registerMinMax(r);
    }

    private static void registerFMA(InvocationPlugins.Registration r) {
        r.register3("fma", Double.TYPE, Double.TYPE, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Double, b.append(new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
        r.register3("fma", Float.TYPE, Float.TYPE, Float.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode na, ValueNode nb, ValueNode nc) {
                b.push(JavaKind.Float, b.append(new FusedMultiplyAddNode(na, nb, nc)));
                return true;
            }
        });
    }

    private static void registerIntegerAbs(InvocationPlugins.Registration r) {
        r.register1("abs", Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        r.register1("abs", Long.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Long, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
    }

    private static void registerMinMax(InvocationPlugins.Registration r) {
        JavaKind[] supportedKinds;
        for (final JavaKind kind : supportedKinds = new JavaKind[]{JavaKind.Float, JavaKind.Double}) {
            r.register2("max", kind.toJavaClass(), kind.toJavaClass(), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(kind, b.append(MaxNode.create(x, y, NodeView.DEFAULT)));
                    return true;
                }
            });
            r.register2("min", kind.toJavaClass(), kind.toJavaClass(), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(kind, b.append(MinNode.create(x, y, NodeView.DEFAULT)));
                    return true;
                }
            });
        }
    }

    private static void registerUnaryMath(InvocationPlugins.Registration r, String name, final UnaryMathIntrinsicNode.UnaryOperation operation) {
        r.register1(name, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(UnaryMathIntrinsicNode.create(value, operation)));
                return true;
            }
        });
    }

    private static void registerStringLatin1Plugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC >= 9) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringLatin1", replacements);
            r.setAllowOverwrite(true);
            r.register2("compareTo", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Byte, JavaKind.Byte));
            r.register2("compareToUTF16", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Byte, JavaKind.Char));
        }
    }

    private static void registerStringUTF16Plugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC >= 9) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
            r.setAllowOverwrite(true);
            r.register2("compareTo", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Char, JavaKind.Char));
            r.register2("compareToLatin1", (Type)((Object)byte[].class), (Type)((Object)byte[].class), new ArrayCompareToPlugin(JavaKind.Char, JavaKind.Byte, true));
        }
    }

    private static final class ArrayCompareToPlugin
    implements InvocationPlugin {
        private final JavaKind valueKind;
        private final JavaKind otherKind;
        private final boolean swapped;

        private ArrayCompareToPlugin(JavaKind valueKind, JavaKind otherKind, boolean swapped) {
            this.valueKind = valueKind;
            this.otherKind = otherKind;
            this.swapped = swapped;
        }

        private ArrayCompareToPlugin(JavaKind valueKind, JavaKind otherKind) {
            this(valueKind, otherKind, false);
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode other) {
            ArrayLengthNode valueLength = b.add(new ArrayLengthNode(value));
            ArrayLengthNode otherLength = b.add(new ArrayLengthNode(other));
            if (this.swapped) {
                b.addPush(JavaKind.Int, new ArrayCompareToNode(other, value, otherLength, valueLength, this.valueKind, this.otherKind));
            } else {
                b.addPush(JavaKind.Int, new ArrayCompareToNode(value, other, valueLength, otherLength, this.valueKind, this.otherKind));
            }
            return true;
        }
    }
}

