/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.replacements.SnippetTemplateCache;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.iterators.NodePredicates;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableControlSinkNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.AbstractBoxingNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryAnchorNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MemoryMap;
import org.graalvm.compiler.nodes.memory.MemoryMapNode;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.MemoryEdgeProxy;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.FloatingReadPhase;
import org.graalvm.compiler.phases.common.GuardLoweringPhase;
import org.graalvm.compiler.phases.common.IncrementalCanonicalizerPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.phases.common.SnippetFrameStateAssignment;
import org.graalvm.compiler.phases.common.WriteBarrierAdditionPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PlaceholderWithExceptionNode;
import org.graalvm.compiler.replacements.SnippetCounterNode;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.compiler.replacements.nodes.LoadSnippetVarargParameterNode;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.util.CollectionsUtil;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

public class SnippetTemplate {
    private boolean mayRemoveLocation = false;
    private static final TimerKey SnippetTemplateCreationTime = DebugContext.timer("SnippetTemplateCreationTime");
    private static final CounterKey SnippetTemplates = DebugContext.counter("SnippetTemplateCount");
    private static final Object UNUSED_PARAMETER = "UNUSED_PARAMETER";
    private static final Object CONSTANT_PARAMETER = "CONSTANT_PARAMETER";
    private final SnippetReflectionProvider snippetReflection;
    private final StructuredGraph snippet;
    private final SnippetInfo info;
    private final Object[] parameters;
    private final ReturnNode returnNode;
    private final FixedWithNextNode unwindPath;
    private final MemoryAnchorNode memoryAnchor;
    private final ArrayList<StateSplit> sideEffectNodes;
    private final ArrayList<DeoptimizingNode> deoptNodes;
    private SnippetFrameStateAssignment.SnippetFrameStateAssignmentClosure frameStateAssignment;
    private final ArrayList<ValueNode> placeholderStampedNodes;
    private final ArrayList<Node> nodes;
    public static final UsageReplacer DEFAULT_REPLACER = new UsageReplacer(){

        @Override
        public void replace(ValueNode oldNode, ValueNode newNode) {
            if (newNode == null) {
                assert (oldNode.hasNoUsages());
            } else {
                oldNode.replaceAtUsages(newNode);
            }
        }
    };

    protected SnippetTemplate(OptionValues options, DebugContext debug, Providers providers, SnippetReflectionProvider snippetReflection, Arguments args, boolean trackNodeSourcePosition, Node replacee, PhaseSuite<Providers> midTierPhases) {
        this.snippetReflection = snippetReflection;
        this.info = args.info;
        Object[] constantArgs = this.getConstantArgs(args);
        boolean shouldTrackNodeSourcePosition1 = trackNodeSourcePosition || providers.getCodeCache() != null && providers.getCodeCache().shouldDebugNonSafepoints();
        StructuredGraph snippetGraph = providers.getReplacements().getSnippet(args.info.method, args.info.original, constantArgs, shouldTrackNodeSourcePosition1, replacee.getNodeSourcePosition(), options);
        assert (snippetGraph.getAssumptions() == null) : snippetGraph;
        ResolvedJavaMethod method = snippetGraph.method();
        Signature signature = method.getSignature();
        StructuredGraph snippetCopy = new StructuredGraph.Builder(options, debug).name(snippetGraph.name).method(snippetGraph.method()).trackNodeSourcePosition(snippetGraph.trackNodeSourcePosition()).setIsSubstitution(true).build();
        snippetCopy.setGuardsStage(snippetGraph.getGuardsStage());
        assert (!GraalOptions.TrackNodeSourcePosition.getValue(options).booleanValue() || snippetCopy.trackNodeSourcePosition());
        try (DebugContext.Scope scope = debug.scope((Object)"SpecializeSnippet", snippetCopy);){
            boolean needsMergeStateMap;
            DebugContext.Scope s;
            Object parameter;
            if (!snippetGraph.isUnsafeAccessTrackingEnabled()) {
                snippetCopy.disableUnsafeAccessTracking();
            }
            assert (snippetCopy.isSubstitution());
            EconomicMap nodeReplacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            nodeReplacements.put((Object)snippetGraph.start(), (Object)snippetCopy.start());
            MetaAccessProvider metaAccess = providers.getMetaAccess();
            assert (SnippetTemplate.checkTemplate(metaAccess, args, method, signature));
            int parameterCount = args.info.getParameterCount();
            VarargsPlaceholderNode[] placeholders = new VarargsPlaceholderNode[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                parameter = snippetGraph.getParameter(i);
                if (parameter == null) continue;
                if (args.info.isConstantParameter(i)) {
                    ConstantNode constantNode;
                    Object arg = args.values[i];
                    JavaKind kind = signature.getParameterKind(i);
                    if (arg instanceof Constant) {
                        Stamp stamp = args.constStamps[i];
                        if (stamp == null) {
                            assert (arg instanceof JavaConstant) : "could not determine type of constant " + arg;
                            constantNode = ConstantNode.forConstant((JavaConstant)arg, metaAccess, snippetCopy);
                        } else {
                            constantNode = ConstantNode.forConstant(stamp, (Constant)arg, metaAccess, snippetCopy);
                        }
                    } else {
                        constantNode = ConstantNode.forConstant(snippetReflection.forBoxed(kind, arg), metaAccess, snippetCopy);
                    }
                    nodeReplacements.put(parameter, (Object)constantNode);
                    continue;
                }
                if (args.info.isVarargsParameter(i)) {
                    Varargs varargs = (Varargs)args.values[i];
                    VarargsPlaceholderNode placeholder = snippetCopy.unique(new VarargsPlaceholderNode(varargs, providers.getMetaAccess()));
                    nodeReplacements.put(parameter, (Object)placeholder);
                    placeholders[i] = placeholder;
                    continue;
                }
                if (!args.info.isNonNullParameter(i)) continue;
                ((ValueNode)parameter).setStamp(((ValueNode)parameter).stamp(NodeView.DEFAULT).join(StampFactory.objectNonNull()));
            }
            InliningLog.UpdateScope updateScope = snippetCopy.getInliningLog().openDefaultUpdateScope();
            parameter = null;
            try {
                UnmodifiableEconomicMap<Node, Node> duplicates = snippetCopy.addDuplicates(snippetGraph.getNodes(), (Graph)snippetGraph, snippetGraph.getNodeCount(), (EconomicMap<Node, Node>)nodeReplacements);
                if (updateScope != null) {
                    snippetCopy.getInliningLog().replaceLog(duplicates, snippetGraph.getInliningLog());
                }
            }
            catch (Throwable duplicates) {
                parameter = duplicates;
                throw duplicates;
            }
            finally {
                if (updateScope != null) {
                    if (parameter != null) {
                        try {
                            updateScope.close();
                        }
                        catch (Throwable duplicates) {
                            ((Throwable)parameter).addSuppressed(duplicates);
                        }
                    } else {
                        updateScope.close();
                    }
                }
            }
            debug.dump(2, snippetCopy, "Before specialization");
            this.parameters = new Object[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                if (args.info.isConstantParameter(i)) {
                    this.parameters[i] = CONSTANT_PARAMETER;
                    continue;
                }
                if (args.info.isVarargsParameter(i)) {
                    assert (snippetCopy.getParameter(i) == null);
                    Varargs varargs = (Varargs)args.values[i];
                    int length = varargs.length;
                    ParameterNode[] params = new ParameterNode[length];
                    Stamp stamp = varargs.stamp;
                    for (int j = 0; j < length; ++j) {
                        ParameterNode parameterNode;
                        assert (parameterCount < 10000);
                        int idx = (i + 1) * 10000 + j;
                        assert (idx >= parameterCount) : "collision in parameter numbering";
                        params[j] = parameterNode = snippetCopy.addOrUnique(new ParameterNode(idx, StampPair.createSingle(stamp)));
                    }
                    this.parameters[i] = params;
                    VarargsPlaceholderNode placeholder = placeholders[i];
                    if (placeholder == null) continue;
                    for (Node node : placeholder.usages().snapshot()) {
                        if (node instanceof LoadIndexedNode) {
                            LoadIndexedNode loadIndexed = (LoadIndexedNode)node;
                            debug.dump(2, (Object)snippetCopy, "Before replacing %s", loadIndexed);
                            LoadSnippetVarargParameterNode loadSnippetParameter = snippetCopy.add(new LoadSnippetVarargParameterNode(params, loadIndexed.index(), loadIndexed.stamp(NodeView.DEFAULT)));
                            snippetCopy.replaceFixedWithFixed(loadIndexed, loadSnippetParameter);
                            debug.dump(2, (Object)snippetCopy, "After replacing %s", loadIndexed);
                            continue;
                        }
                        if (!(node instanceof StoreIndexedNode)) continue;
                        throw new GraalError("Can't store into VarargsParameter array");
                    }
                    continue;
                }
                ParameterNode local = snippetCopy.getParameter(i);
                this.parameters[i] = local == null ? UNUSED_PARAMETER : local;
            }
            SnippetTemplate.explodeLoops(snippetCopy, providers);
            List<UnwindNode> unwindNodes = snippetCopy.getNodes().filter(UnwindNode.class).snapshot();
            if (unwindNodes.size() == 0) {
                this.unwindPath = null;
            } else {
                if (unwindNodes.size() > 1) {
                    throw GraalError.shouldNotReachHere("Graph has more than one UnwindNode");
                }
                UnwindNode unwindNode = unwindNodes.get(0);
                GraalError.guarantee(unwindNode.predecessor() instanceof ExceptionObjectNode, "Currently only a single direct exception unwind path is supported in snippets");
                ExceptionObjectNode exceptionObjectNode = (ExceptionObjectNode)unwindNode.predecessor();
                this.unwindPath = snippetCopy.add(new BeginNode());
                exceptionObjectNode.replaceAtPredecessor(this.unwindPath);
                GraphUtil.killCFG(exceptionObjectNode);
                this.unwindPath.setNext(snippetCopy.add(new UnreachableControlSinkNode()));
            }
            CanonicalizerPhase canonicalizer = GraalOptions.ImmutableCode.getValue(snippetCopy.getOptions()) != false ? CanonicalizerPhase.createWithoutReadCanonicalization() : CanonicalizerPhase.create();
            StructuredGraph.GuardsStage guardsStage = args.cacheKey.guardsStage;
            boolean needsPEA = false;
            boolean needsCE = false;
            LoweringTool.LoweringStage loweringStage = args.cacheKey.loweringStage;
            for (Node node : snippetCopy.getNodes()) {
                if (node instanceof AbstractNewObjectNode || node instanceof AbstractBoxingNode) {
                    needsPEA = true;
                    break;
                }
                if (!(node instanceof LogicNode)) continue;
                needsCE = true;
            }
            if (needsPEA) {
                new PartialEscapePhase(true, true, canonicalizer, null, options, SchedulePhase.SchedulingStrategy.LATEST).apply(snippetCopy, providers);
            }
            if (needsCE) {
                new IterativeConditionalEliminationPhase(canonicalizer, false).apply(snippetCopy, providers);
            }
            try {
                s = debug.scope((Object)"LoweringSnippetTemplate_HIGH_TIER", snippetCopy);
                Throwable throwable = null;
                try {
                    new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.HIGH_TIER).apply(snippetCopy, providers);
                }
                catch (Throwable loadIndexed) {
                    Throwable throwable2 = loadIndexed;
                    throw loadIndexed;
                }
                finally {
                    if (s != null) {
                        if (throwable != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable loadIndexed) {
                                throwable.addSuppressed(loadIndexed);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            if (loweringStage != LoweringTool.StandardLoweringStage.HIGH_TIER) {
                assert (!guardsStage.allowsFloatingGuards()) : guardsStage;
                new IncrementalCanonicalizerPhase<Object>(canonicalizer, new FloatingReadPhase(true, true)).apply(snippetCopy, providers);
                new GuardLoweringPhase().apply(snippetCopy, providers);
                new IncrementalCanonicalizerPhase<Object>(canonicalizer, new RemoveValueProxyPhase()).apply(snippetCopy, providers);
                try {
                    s = debug.scope((Object)"LoweringSnippetTemplate_MID_TIER", snippetCopy);
                    Throwable throwable = null;
                    try {
                        new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.MID_TIER).apply(snippetCopy, providers);
                        snippetCopy.setGuardsStage(StructuredGraph.GuardsStage.AFTER_FSA);
                        snippetCopy.disableFrameStateVerification();
                    }
                    catch (Throwable loadIndexed) {
                        Throwable throwable3 = loadIndexed;
                        throw loadIndexed;
                    }
                    finally {
                        if (s != null) {
                            if (throwable != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable loadIndexed) {
                                    throwable.addSuppressed(loadIndexed);
                                }
                            } else {
                                s.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
                if (loweringStage != LoweringTool.StandardLoweringStage.MID_TIER) {
                    if (midTierPhases != null) {
                        midTierPhases.apply(snippetCopy, providers);
                    }
                    new WriteBarrierAdditionPhase().apply(snippetCopy, providers);
                    try {
                        s = debug.scope((Object)"LoweringSnippetTemplate_LOW_TIER", snippetCopy);
                        Throwable throwable = null;
                        try {
                            new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.LOW_TIER).apply(snippetCopy, providers);
                        }
                        catch (Throwable loadIndexed) {
                            Throwable throwable4 = loadIndexed;
                            throw loadIndexed;
                        }
                        finally {
                            if (s != null) {
                                if (throwable != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable loadIndexed) {
                                        throwable.addSuppressed(loadIndexed);
                                    }
                                } else {
                                    s.close();
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                    new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(snippetCopy);
                }
            }
            assert (SnippetTemplate.checkAllVarargPlaceholdersAreDeleted(parameterCount, placeholders));
            ArrayList<StateSplit> curSideEffectNodes = new ArrayList<StateSplit>();
            ArrayList<DeoptimizingNode> arrayList = new ArrayList<DeoptimizingNode>();
            ArrayList<ValueNode> curPlaceholderStampedNodes = new ArrayList<ValueNode>();
            boolean containsMerge = false;
            boolean containsLoopExit = false;
            for (Node node : snippetCopy.getNodes()) {
                DeoptimizingNode deoptNode;
                ValueNode valueNode;
                if (node instanceof AbstractMergeNode) {
                    containsMerge = true;
                }
                if (node instanceof LoopExitNode) {
                    containsLoopExit = true;
                }
                if (node instanceof ValueNode && (valueNode = (ValueNode)node).stamp(NodeView.DEFAULT) == PiNode.PlaceholderStamp.singleton()) {
                    curPlaceholderStampedNodes.add(valueNode);
                }
                if (node instanceof StateSplit) {
                    StateSplit stateSplit = (StateSplit)((Object)node);
                    FrameState frameState = stateSplit.stateAfter();
                    if (stateSplit.hasSideEffect()) {
                        curSideEffectNodes.add((StateSplit)((Object)node));
                    }
                    if (frameState != null) {
                        stateSplit.setStateAfter(null);
                    }
                }
                if (!(node instanceof DeoptimizingNode) || !(deoptNode = (DeoptimizingNode)((Object)node)).canDeoptimize()) continue;
                arrayList.add(deoptNode);
            }
            this.snippet = snippetCopy;
            StartNode entryPointNode = this.snippet.start();
            MemoryAnchorNode anchor = snippetCopy.add(new MemoryAnchorNode(this.info.privateLocations));
            snippetCopy.start().replaceAtUsages((Node)anchor, InputType.Memory);
            debug.dump(5, (Object)snippetCopy, "After adding memory anchor %s", anchor);
            if (anchor.hasNoUsages()) {
                anchor.safeDelete();
                this.memoryAnchor = null;
            } else {
                boolean needsAnchor;
                boolean needsMemoryMaps = false;
                for (ReturnNode retNode : this.snippet.getNodes(ReturnNode.TYPE)) {
                    MemoryMapNode memoryMap = retNode.getMemoryMap();
                    if (memoryMap.getLocations().size() <= 1 && memoryMap.getLastLocationAccess(LocationIdentity.any()) == anchor) continue;
                    needsMemoryMaps = true;
                    break;
                }
                if (needsMemoryMaps) {
                    needsAnchor = true;
                } else {
                    needsAnchor = anchor.usages().filter(NodePredicates.isNotA(MemoryMapNode.class)).isNotEmpty();
                    Node memoryMap = null;
                    for (ReturnNode retNode : this.snippet.getNodes(ReturnNode.TYPE)) {
                        if (memoryMap == null) {
                            memoryMap = retNode.getMemoryMap();
                        } else assert (memoryMap == retNode.getMemoryMap());
                        retNode.setMemoryMap(null);
                    }
                    if (memoryMap != null) {
                        memoryMap.safeDelete();
                    }
                }
                if (needsAnchor) {
                    snippetCopy.addAfterFixed(snippetCopy.start(), anchor);
                    this.memoryAnchor = anchor;
                } else {
                    anchor.safeDelete();
                    this.memoryAnchor = null;
                }
            }
            debug.dump(2, this.snippet, "SnippetTemplate after fixing memory anchoring");
            List<ReturnNode> returnNodes = this.snippet.getNodes(ReturnNode.TYPE).snapshot();
            if (returnNodes.isEmpty()) {
                this.returnNode = null;
            } else if (returnNodes.size() == 1) {
                this.returnNode = returnNodes.get(0);
            } else {
                AbstractMergeNode merge = this.snippet.add(new MergeNode());
                ArrayList<MemoryMapNode> memMaps = new ArrayList<MemoryMapNode>();
                for (ReturnNode retNode : returnNodes) {
                    MemoryMapNode memoryMapNode = retNode.getMemoryMap();
                    if (memoryMapNode == null) continue;
                    memMaps.add(memoryMapNode);
                }
                containsMerge = true;
                ValueNode returnValue = InliningUtil.mergeReturns(merge, returnNodes);
                this.returnNode = this.snippet.add(new ReturnNode(returnValue));
                if (!memMaps.isEmpty()) {
                    FloatingReadPhase.MemoryMapImpl mmap = FloatingReadPhase.mergeMemoryMaps(merge, memMaps);
                    MemoryMapNode memoryMap = this.snippet.unique(new MemoryMapNode(mmap.getMap()));
                    this.returnNode.setMemoryMap(memoryMap);
                    for (MemoryMapNode mm : memMaps) {
                        if (mm == memoryMap || !mm.isAlive()) continue;
                        assert (mm.hasNoUsages());
                        GraphUtil.killWithUnusedFloatingInputs(mm);
                    }
                }
                merge.setNext(this.returnNode);
            }
            debug.dump(2, this.snippet, "After fixing returns");
            boolean bl = needsMergeStateMap = !guardsStage.areFrameStatesAtDeopts() && (containsMerge || containsLoopExit);
            if (needsMergeStateMap) {
                this.frameStateAssignment = new SnippetFrameStateAssignment.SnippetFrameStateAssignmentClosure(snippetCopy);
                ReentrantNodeIterator.apply(this.frameStateAssignment, snippetCopy.start(), SnippetFrameStateAssignment.NodeStateAssignment.BEFORE_BCI);
                assert (this.frameStateAssignment.verify()) : this.info;
            } else {
                this.frameStateAssignment = null;
            }
            assert (SnippetTemplate.verifyIntrinsicsProcessed(snippetCopy));
            this.sideEffectNodes = curSideEffectNodes;
            this.deoptNodes = arrayList;
            this.placeholderStampedNodes = curPlaceholderStampedNodes;
            this.nodes = new ArrayList(this.snippet.getNodeCount());
            for (Node node : this.snippet.getNodes()) {
                if (node == entryPointNode || node == entryPointNode.stateAfter()) continue;
                this.nodes.add(node);
            }
            if (debug.areMetricsEnabled()) {
                DebugContext.counter("SnippetTemplateNodeCount[%#s]", args).add(debug, this.nodes.size());
            }
            debug.dump(2, this.snippet, "SnippetTemplate final state");
            this.snippet.freeze();
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    private static boolean verifyIntrinsicsProcessed(StructuredGraph snippetCopy) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            return true;
        }
        for (MethodCallTargetNode target : snippetCopy.getNodes(MethodCallTargetNode.TYPE)) {
            ResolvedJavaMethod targetMethod = target.targetMethod();
            if (targetMethod != null) assert (targetMethod.getAnnotation(Fold.class) == null && targetMethod.getAnnotation(Node.NodeIntrinsic.class) == null) : "plugin should have been processed";
        }
        return true;
    }

    public static void explodeLoops(StructuredGraph snippetCopy, CoreProviders providers) {
        boolean exploded = false;
        do {
            exploded = false;
            ExplodeLoopNode explodeLoop = snippetCopy.getNodes().filter(ExplodeLoopNode.class).first();
            if (explodeLoop == null) continue;
            LoopBeginNode loopBegin = explodeLoop.findLoopBegin();
            if (loopBegin != null) {
                LoopEx loop = providers.getLoopsDataProvider().getLoopsData(snippetCopy).loop(loopBegin);
                Graph.Mark mark = snippetCopy.getMark();
                CanonicalizerPhase canonicalizer = null;
                canonicalizer = GraalOptions.ImmutableCode.getValue(snippetCopy.getOptions()) != false ? CanonicalizerPhase.createWithoutReadCanonicalization() : CanonicalizerPhase.create();
                try {
                    LoopTransformations.fullUnroll(loop, providers, canonicalizer);
                }
                catch (RetryableBailoutException e) {
                    throw new GraalError((Throwable)((Object)e), snippetCopy.toString(), new Object[0]);
                }
                CanonicalizerPhase.create().applyIncremental(snippetCopy, providers, mark, false);
                loop.deleteUnusedNodes();
            }
            GraphUtil.removeFixedWithUnusedInputs(explodeLoop);
            exploded = true;
        } while (exploded);
    }

    protected Object[] getConstantArgs(Arguments args) {
        Object[] constantArgs = (Object[])args.values.clone();
        for (int i = 0; i < args.info.getParameterCount(); ++i) {
            if (!args.info.isConstantParameter(i)) {
                constantArgs[i] = null;
                continue;
            }
            assert (constantArgs[i] != null) : "Can't pass raw null through as argument";
        }
        return constantArgs;
    }

    private static boolean checkAllVarargPlaceholdersAreDeleted(int parameterCount, VarargsPlaceholderNode[] placeholders) {
        for (int i = 0; i < parameterCount; ++i) {
            if (placeholders[i] != null) assert (placeholders[i].isDeleted()) : placeholders[i];
        }
        return true;
    }

    private static boolean checkConstantArgument(MetaAccessProvider metaAccess, ResolvedJavaMethod method, Signature signature, int paramIndex, String name, Object arg, JavaKind kind) {
        ResolvedJavaType type = signature.getParameterType(paramIndex, method.getDeclaringClass()).resolve(method.getDeclaringClass());
        if (metaAccess.lookupJavaType(WordBase.class).isAssignableFrom(type)) {
            assert (arg instanceof Constant || arg instanceof ConstantNode) : method + ": word constant parameters must be passed boxed in a Constant value: " + arg;
            return true;
        }
        if (kind != JavaKind.Object) assert (arg != null && kind.toBoxedJavaClass() == arg.getClass()) : method + ": wrong value kind for " + name + ": expected " + kind + ", got " + (arg == null ? "null" : arg.getClass().getSimpleName());
        return true;
    }

    private static boolean checkVarargs(MetaAccessProvider metaAccess, ResolvedJavaMethod method, Signature signature, int i, String name, Varargs varargs) {
        ResolvedJavaType type = (ResolvedJavaType)signature.getParameterType(i, method.getDeclaringClass());
        assert (type.isArray()) : "varargs parameter must be an array type";
        assert (type.getComponentType().isAssignableFrom(metaAccess.lookupJavaType(varargs.componentType))) : "componentType for " + name + " not matching " + type.toJavaName() + " instance: " + varargs.componentType;
        return true;
    }

    private static boolean checkNonNull(ResolvedJavaMethod method, String parameterName, Object arg) {
        if (arg instanceof ValueNode) {
            assert (StampTool.isPointerNonNull((ValueNode)arg)) : method + ": non-null Node for argument " + parameterName + " must have non-null stamp: " + arg;
        } else if (arg instanceof Constant) {
            assert (JavaConstant.isNull((Constant)((Constant)arg))) : method + ": non-null Constant for argument " + parameterName + " must not represent null";
        } else assert (arg != null) : method + ": non-null object for argument " + parameterName + " must not be null";
        return true;
    }

    private EconomicMap<Node, Node> bind(StructuredGraph replaceeGraph, MetaAccessProvider metaAccess, Arguments args) {
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        assert (args.info.getParameterCount() == this.parameters.length) : "number of args (" + args.info.getParameterCount() + ") != number of parameters (" + this.parameters.length + ")";
        for (int i = 0; i < this.parameters.length; ++i) {
            Object parameter = this.parameters[i];
            assert (parameter != null) : this + " has no parameter named " + args.info.getParameterName(i);
            Object argument = args.values[i];
            if (parameter instanceof ParameterNode) {
                if (argument instanceof ValueNode) {
                    replacements.put((Object)((ParameterNode)parameter), (Object)((ValueNode)argument));
                    continue;
                }
                JavaKind kind = ((ParameterNode)parameter).getStackKind();
                assert (argument != null || kind == JavaKind.Object) : this + " cannot accept null for non-object parameter named " + args.info.getParameterName(i);
                JavaConstant constant = this.forBoxed(argument, kind);
                replacements.put((Object)((ParameterNode)parameter), (Object)ConstantNode.forConstant(constant, metaAccess, replaceeGraph));
                continue;
            }
            if (parameter instanceof ParameterNode[]) {
                ParameterNode[] params = (ParameterNode[])parameter;
                Varargs varargs = (Varargs)argument;
                int length = params.length;
                List list = null;
                Object array = null;
                if (varargs.value instanceof List) {
                    list = (List)varargs.value;
                    assert (list.size() == length) : length + " != " + list.size();
                } else {
                    array = varargs.value;
                    assert (array != null && array.getClass().isArray());
                    assert (Array.getLength(array) == length) : length + " != " + Array.getLength(array);
                }
                for (int j = 0; j < length; ++j) {
                    Object value;
                    ParameterNode param = params[j];
                    assert (param != null);
                    Object object = value = list != null ? list.get(j) : Array.get(array, j);
                    if (value instanceof ValueNode) {
                        replacements.put((Object)param, (Object)((ValueNode)value));
                        continue;
                    }
                    JavaConstant constant = this.forBoxed(value, param.getStackKind());
                    ConstantNode element = ConstantNode.forConstant(constant, metaAccess, replaceeGraph);
                    replacements.put((Object)param, (Object)element);
                }
                continue;
            }
            assert (parameter.equals(CONSTANT_PARAMETER) || parameter.equals(UNUSED_PARAMETER)) : "unexpected entry for parameter: " + args.info.getParameterName(i) + " -> " + parameter;
        }
        return replacements;
    }

    protected JavaConstant forBoxed(Object argument, JavaKind localKind) {
        assert (localKind == localKind.getStackKind());
        if (localKind == JavaKind.Int) {
            return JavaConstant.forBoxedPrimitive((Object)argument);
        }
        return this.snippetReflection.forBoxed(localKind, argument);
    }

    private boolean assertSnippetKills(ValueNode replacee) {
        if (!replacee.graph().isAfterFloatingReadPhase()) {
            return true;
        }
        if (this.returnNode == null) {
            return true;
        }
        MemoryMapNode memoryMap = this.returnNode.getMemoryMap();
        if (memoryMap == null || memoryMap.isEmpty()) {
            return true;
        }
        EconomicSet kills = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        kills.addAll(memoryMap.getLocations());
        if (replacee instanceof SingleMemoryKill) {
            LocationIdentity locationIdentity = ((SingleMemoryKill)((Object)replacee)).getKilledLocationIdentity();
            if (locationIdentity.isAny()) {
                return true;
            }
            assert (kills.contains((Object)locationIdentity)) : replacee + " kills " + locationIdentity + ", but snippet doesn't contain a kill to this location";
            kills.remove((Object)locationIdentity);
        }
        assert (!(replacee instanceof MultiMemoryKill)) : replacee + " multi not supported (yet)";
        if (memoryMap.getLastLocationAccess(LocationIdentity.any()) instanceof MemoryAnchorNode) {
            kills.remove((Object)LocationIdentity.any());
        }
        assert (!kills.contains((Object)LocationIdentity.any())) : "snippet graph contains a kill to ANY_LOCATION, but replacee (" + replacee + ") doesn't kill ANY_LOCATION.  kills: " + kills;
        for (LocationIdentity p : this.info.privateLocations) {
            kills.remove((Object)p);
        }
        assert (kills.isEmpty()) : "snippet graph kills non-private locations " + kills + " that replacee (" + replacee + ") doesn't kill";
        return true;
    }

    private void rewireMemoryGraph(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        if (replacee.graph().isAfterFloatingReadPhase()) {
            MemoryMapNode memoryMap;
            ReturnNode ret;
            this.replaceMemoryUsages(replacee, new MemoryOutputMap(replacee, duplicates));
            if (this.returnNode != null && (ret = (ReturnNode)duplicates.get((Object)this.returnNode)) != null && (memoryMap = ret.getMemoryMap()) != null) {
                ret.setMemoryMap(null);
                memoryMap.safeDelete();
            }
            if (this.memoryAnchor != null) {
                MemoryAnchorNode memoryDuplicate = (MemoryAnchorNode)duplicates.get((Object)this.memoryAnchor);
                this.replaceMemoryUsages(memoryDuplicate, new MemoryInputMap(replacee));
                if (memoryDuplicate.hasNoUsages()) {
                    if (memoryDuplicate.next() != null) {
                        memoryDuplicate.graph().removeFixed(memoryDuplicate);
                    } else {
                        memoryDuplicate.safeDelete();
                    }
                }
            }
        }
    }

    private static LocationIdentity getLocationIdentity(Node node) {
        if (node instanceof MemoryAccess) {
            return ((MemoryAccess)((Object)node)).getLocationIdentity();
        }
        if (node instanceof MemoryEdgeProxy) {
            return ((MemoryEdgeProxy)((Object)node)).getLocationIdentity();
        }
        if (node instanceof MemoryPhiNode) {
            return ((MemoryPhiNode)node).getLocationIdentity();
        }
        return null;
    }

    private void replaceMemoryUsages(ValueNode node, MemoryMap map) {
        for (Node usage : node.usages().snapshot()) {
            LocationIdentity location;
            if (usage instanceof MemoryMapNode || (location = SnippetTemplate.getLocationIdentity(usage)) == null) continue;
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != InputType.Memory || pos.get(usage) != node) continue;
                MemoryKill replacement = map.getLastLocationAccess(location);
                if (replacement == null) {
                    assert (this.mayRemoveLocation || LocationIdentity.any().equals(location) || CollectionsUtil.anyMatch(this.info.privateLocations, Predicate.isEqual(location))) : "Snippet " + this.info.method.format("%h.%n") + " contains access to the non-private location " + location + ", but replacee doesn't access this location." + map.getLocations();
                    continue;
                }
                pos.set(usage, replacement.asNode());
            }
        }
    }

    public UnmodifiableEconomicMap<Node, Node> instantiate(MetaAccessProvider metaAccess, FixedNode replacee, UsageReplacer replacer, Arguments args) {
        return this.instantiate(metaAccess, replacee, replacer, args, true);
    }

    public UnmodifiableEconomicMap<Node, Node> instantiate(MetaAccessProvider metaAccess, FixedNode replacee, UsageReplacer replacer, Arguments args, boolean killReplacee) {
        DebugContext debug = replacee.getDebug();
        assert (this.assertSnippetKills(replacee));
        try (DebugCloseable a = args.info.instantiationTimer.start(debug);){
            AbstractBeginNode exceptionEdge;
            args.info.instantiationCounter.increment(debug);
            FixedNode replaceeGraphPredecessor = (FixedNode)replacee.predecessor();
            StartNode entryPointNode = this.snippet.start();
            FixedNode firstCFGNode = entryPointNode.next();
            StructuredGraph replaceeGraph = replacee.graph();
            EconomicMap<Node, Node> replacements = this.bind(replaceeGraph, metaAccess, args);
            replacements.put((Object)entryPointNode, (Object)AbstractBeginNode.prevBegin(replacee));
            UnmodifiableEconomicMap<Node, Node> duplicates = this.inlineSnippet(replacee, debug, replaceeGraph, replacements);
            FixedNode firstCFGNodeDuplicate = (FixedNode)duplicates.get((Object)firstCFGNode);
            replacee.replaceAtPredecessor(firstCFGNodeDuplicate);
            if (replacee.graph().getGuardsStage().areFrameStatesAtSideEffects()) {
                boolean replacementHasSideEffect;
                boolean replaceeHasSideEffect = replacee instanceof StateSplit && ((StateSplit)((Object)replacee)).hasSideEffect();
                boolean bl = replacementHasSideEffect = !this.sideEffectNodes.isEmpty();
                if (replacementHasSideEffect) {
                    GraalError.guarantee(replaceeHasSideEffect, "Lowering node %s without side-effect to snippet %s with sideeffects=%s", (Object)replacee, (Object)this.info, this.sideEffectNodes);
                }
            }
            this.rewireFrameStates(replacee, duplicates, replaceeGraphPredecessor);
            this.updateStamps(replacee, duplicates);
            this.rewireMemoryGraph(replacee, duplicates);
            ValueNode returnValue = null;
            Node originalWithExceptionNextNode = null;
            if (this.returnNode != null && !(replacee instanceof ControlSinkNode)) {
                ReturnNode returnDuplicate = (ReturnNode)duplicates.get((Object)this.returnNode);
                returnValue = returnDuplicate.result();
                if (returnValue == null && replacee.usages().isNotEmpty() && replacee instanceof MemoryKill) {
                    replacer.replace(replacee, null);
                } else {
                    assert (returnValue != null || replacee.hasNoUsages());
                    replacer.replace(replacee, returnValue);
                }
                if (returnDuplicate.isAlive()) {
                    FixedNode next = null;
                    if (replacee instanceof FixedWithNextNode) {
                        FixedWithNextNode fwn = (FixedWithNextNode)replacee;
                        next = fwn.next();
                        fwn.setNext(null);
                    } else if (replacee instanceof WithExceptionNode) {
                        WithExceptionNode withExceptionNode = (WithExceptionNode)replacee;
                        originalWithExceptionNextNode = withExceptionNode.next();
                        next = originalWithExceptionNextNode;
                        withExceptionNode.setNext(null);
                    }
                    returnDuplicate.replaceAndDelete(next);
                }
            }
            if (this.unwindPath != null) {
                GraalError.guarantee(!replacee.graph().isAfterFloatingReadPhase(), "Using a snippet with an UnwindNode after floating reads would require support for the memory graph");
                GraalError.guarantee(replacee instanceof WithExceptionNode, "Snippet has an UnwindNode, but replacee is not a node with an exception handler");
                FixedWithNextNode unwindPathDuplicate = (FixedWithNextNode)duplicates.get((Object)this.unwindPath);
                WithExceptionNode withExceptionNode = (WithExceptionNode)replacee;
                exceptionEdge = withExceptionNode.exceptionEdge();
                withExceptionNode.setExceptionEdge(null);
                unwindPathDuplicate.replaceAtPredecessor(exceptionEdge);
                GraphUtil.killCFG(unwindPathDuplicate);
            } else if (replacee instanceof WithExceptionNode) {
                GraalError.guarantee(!replacee.graph().isAfterFloatingReadPhase(), "Using a snippet with an UnwindNode after floating reads would require support for the memory graph");
                GraalError.guarantee(originalWithExceptionNextNode != null, "Need to have next node to link placeholder to.");
                WithExceptionNode newExceptionNode = replacee.graph().add(new PlaceholderWithExceptionNode());
                ((FixedWithNextNode)originalWithExceptionNextNode.predecessor()).setNext(newExceptionNode);
                newExceptionNode.setNext((AbstractBeginNode)originalWithExceptionNextNode);
                WithExceptionNode oldExceptionNode = (WithExceptionNode)replacee;
                exceptionEdge = oldExceptionNode.exceptionEdge();
                oldExceptionNode.setExceptionEdge(null);
                newExceptionNode.setExceptionEdge(exceptionEdge);
            }
            if (killReplacee) {
                GraphUtil.killCFG(replacee);
            }
            debug.dump(4, replaceeGraph, "After lowering %s with %s", replacee, this);
            UnmodifiableEconomicMap<Node, Node> unmodifiableEconomicMap = duplicates;
            return unmodifiableEconomicMap;
        }
    }

    private UnmodifiableEconomicMap<Node, Node> inlineSnippet(Node replacee, DebugContext debug, StructuredGraph replaceeGraph, EconomicMap<Node, Node> replacements) {
        Graph.Mark mark = replaceeGraph.getMark();
        try (InliningLog.UpdateScope scope = replaceeGraph.getInliningLog().openUpdateScope((oldNode, newNode) -> {
            InliningLog log = replaceeGraph.getInliningLog();
            if (oldNode == null) {
                log.trackNewCallsite((Invokable)newNode);
            }
        });){
            UnmodifiableEconomicMap<Node, Node> duplicates = replaceeGraph.addDuplicates(this.nodes, (Graph)this.snippet, this.snippet.getNodeCount(), replacements);
            if (scope != null) {
                replaceeGraph.getInliningLog().addLog(duplicates, this.snippet.getInliningLog());
            }
            NodeSourcePosition position = replacee.getNodeSourcePosition();
            InliningUtil.updateSourcePosition(replaceeGraph, duplicates, mark, position, true);
            debug.dump(4, (Object)replaceeGraph, "After inlining snippet %s", this.snippet.method());
            UnmodifiableEconomicMap<Node, Node> unmodifiableEconomicMap = duplicates;
            return unmodifiableEconomicMap;
        }
    }

    private void propagateStamp(Node node) {
        PhiNode phi;
        if (node instanceof PhiNode && (phi = (PhiNode)node).inferStamp()) {
            for (Node usage : node.usages()) {
                this.propagateStamp(usage);
            }
        }
    }

    private void updateStamps(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        for (ValueNode node : this.placeholderStampedNodes) {
            ValueNode dup = (ValueNode)duplicates.get((Object)node);
            Stamp replaceeStamp = replacee.stamp(NodeView.DEFAULT);
            if (node instanceof PiNode.Placeholder) {
                PiNode.Placeholder placeholderDup = (PiNode.Placeholder)dup;
                placeholderDup.makeReplacement(replaceeStamp);
                continue;
            }
            dup.setStamp(replaceeStamp);
        }
        for (ParameterNode paramNode : this.snippet.getNodes(ParameterNode.TYPE)) {
            for (Node usage : paramNode.usages()) {
                Node usageDup = (Node)duplicates.get((Object)usage);
                this.propagateStamp(usageDup);
            }
        }
    }

    public StructuredGraph copySpecializedGraph(DebugContext debugForCopy) {
        return (StructuredGraph)this.snippet.copy(debugForCopy);
    }

    public void instantiate(MetaAccessProvider metaAccess, FloatingNode replacee, UsageReplacer replacer, LoweringTool tool, Arguments args) {
        DebugContext debug = replacee.getDebug();
        assert (this.assertSnippetKills(replacee));
        try (DebugCloseable a = args.info.instantiationTimer.start(debug);){
            args.info.instantiationCounter.increment(debug);
            StartNode entryPointNode = this.snippet.start();
            FixedNode firstCFGNode = entryPointNode.next();
            StructuredGraph replaceeGraph = replacee.graph();
            EconomicMap<Node, Node> replacements = this.bind(replaceeGraph, metaAccess, args);
            replacements.put((Object)entryPointNode, (Object)tool.getCurrentGuardAnchor().asNode());
            UnmodifiableEconomicMap<Node, Node> duplicates = this.inlineSnippet(replacee, debug, replaceeGraph, replacements);
            FixedWithNextNode lastFixedNode = tool.lastFixedNode();
            assert (lastFixedNode != null && lastFixedNode.isAlive()) : replaceeGraph + " lastFixed=" + lastFixedNode;
            FixedNode next = lastFixedNode.next();
            lastFixedNode.setNext(null);
            FixedNode firstCFGNodeDuplicate = (FixedNode)duplicates.get((Object)firstCFGNode);
            replaceeGraph.addAfterFixed(lastFixedNode, firstCFGNodeDuplicate);
            assert (!(replacee instanceof StateSplit));
            this.updateStamps(replacee, duplicates);
            this.rewireMemoryGraph(replacee, duplicates);
            this.rewireFrameStates(replacee, duplicates, lastFixedNode);
            ReturnNode returnDuplicate = (ReturnNode)duplicates.get((Object)this.returnNode);
            ValueNode returnValue = returnDuplicate.result();
            assert (returnValue != null || replacee.hasNoUsages());
            replacer.replace(replacee, returnValue);
            if (returnDuplicate.isAlive()) {
                returnDuplicate.replaceAndDelete(next);
            }
            debug.dump(4, replaceeGraph, "After lowering %s with %s", replacee, this);
        }
    }

    public void instantiate(MetaAccessProvider metaAccess, FloatingNode replacee, UsageReplacer replacer, Arguments args) {
        DebugContext debug = replacee.getDebug();
        assert (this.assertSnippetKills(replacee));
        try (DebugCloseable a = args.info.instantiationTimer.start(debug);){
            args.info.instantiationCounter.increment(debug);
            StartNode entryPointNode = this.snippet.start();
            assert (entryPointNode.next() == (this.memoryAnchor == null ? this.returnNode : this.memoryAnchor)) : entryPointNode.next();
            StructuredGraph replaceeGraph = replacee.graph();
            EconomicMap<Node, Node> replacements = this.bind(replaceeGraph, metaAccess, args);
            MemoryAnchorNode anchorDuplicate = null;
            if (this.memoryAnchor != null) {
                anchorDuplicate = replaceeGraph.add(new MemoryAnchorNode(this.info.privateLocations));
                replacements.put((Object)this.memoryAnchor, (Object)anchorDuplicate);
            }
            ArrayList<Node> floatingNodes = new ArrayList<Node>(this.nodes.size() - 2);
            for (Node n : this.nodes) {
                if (n == entryPointNode || n == this.returnNode) continue;
                floatingNodes.add(n);
            }
            UnmodifiableEconomicMap<Node, Node> duplicates = this.inlineSnippet(replacee, debug, replaceeGraph, replacements);
            assert (!(replacee instanceof StateSplit));
            this.updateStamps(replacee, duplicates);
            this.rewireMemoryGraph(replacee, duplicates);
            assert (anchorDuplicate == null || anchorDuplicate.isDeleted());
            ValueNode returnValue = (ValueNode)duplicates.get((Object)this.returnNode.result());
            replacer.replace(replacee, returnValue);
            debug.dump(4, replaceeGraph, "After lowering %s with %s", replacee, this);
        }
    }

    protected void rewireFrameStates(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FixedNode replaceeGraphCFGPredecessor) {
        if (replacee.graph().getGuardsStage().areFrameStatesAtSideEffects() && this.requiresFrameStateProcessingBeforeFSA(replacee)) {
            this.rewireFrameStatesBeforeFSA(replacee, duplicates, replaceeGraphCFGPredecessor);
        } else if (replacee.graph().getGuardsStage().areFrameStatesAtDeopts() && replacee instanceof DeoptimizingNode) {
            this.rewireFrameStatesAfterFSA(replacee, duplicates);
        }
    }

    private boolean requiresFrameStateProcessingBeforeFSA(ValueNode replacee) {
        return replacee instanceof StateSplit || this.frameStateAssignment != null;
    }

    private void rewireFrameStatesBeforeFSA(final ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FixedNode replaceeGraphCFGPredecessor) {
        if (replacee instanceof StateSplit && ((StateSplit)((Object)replacee)).hasSideEffect() && ((StateSplit)((Object)replacee)).stateAfter() != null) {
            for (StateSplit sideEffectNode : this.sideEffectNodes) {
                assert (((StateSplit)((Object)replacee)).hasSideEffect());
                Node sideEffectDup = (Node)duplicates.get((Object)sideEffectNode.asNode());
                assert (sideEffectDup != null) : sideEffectNode;
                FrameState stateAfter = ((StateSplit)((Object)replacee)).stateAfter();
                assert (stateAfter != null) : "Replacee " + replacee + " has no state after";
                if (sideEffectDup instanceof DeoptBciSupplier && replacee instanceof DeoptBciSupplier) {
                    ((DeoptBciSupplier)((Object)sideEffectDup)).setBci(((DeoptBciSupplier)((Object)replacee)).bci());
                }
                if (stateAfter.values().contains(replacee)) {
                    FrameState duplicated = stateAfter.duplicate();
                    ValueNode valueInReplacement = (ValueNode)duplicates.get((Object)this.returnNode.result());
                    if (valueInReplacement instanceof ValuePhiNode) {
                        valueInReplacement = (ValueNode)sideEffectDup;
                    }
                    final ValueNode replacement = valueInReplacement;
                    duplicated.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

                        @Override
                        public void apply(Node from, Position p) {
                            if (p.get(from) == replacee) {
                                p.set(from, replacement);
                            }
                        }
                    });
                    ((StateSplit)((Object)sideEffectDup)).setStateAfter(duplicated);
                    continue;
                }
                ((StateSplit)((Object)sideEffectDup)).setStateAfter(((StateSplit)((Object)replacee)).stateAfter());
            }
        }
        if (this.frameStateAssignment != null) {
            this.assignNecessaryFrameStates(replacee, duplicates, replaceeGraphCFGPredecessor);
        }
    }

    private void assignNecessaryFrameStates(final ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates, FixedNode replaceeGraphCFGPredecessor) {
        FrameState stateAfter = null;
        if (replacee instanceof StateSplit && ((StateSplit)((Object)replacee)).hasSideEffect()) {
            stateAfter = ((StateSplit)((Object)replacee)).stateAfter();
            assert (stateAfter != null) : "Statesplit with side-effect needs a framestate " + replacee;
        } else {
            stateAfter = SnippetTemplate.findLastFrameState(replaceeGraphCFGPredecessor);
        }
        NodeMap<SnippetFrameStateAssignment.NodeStateAssignment> assignedStateMappings = this.frameStateAssignment.getStateMapping();
        MapCursor<Node, SnippetFrameStateAssignment.NodeStateAssignment> stateAssignments = assignedStateMappings.getEntries();
        while (stateAssignments.advance()) {
            Node nodeRequiringState = (Node)stateAssignments.getKey();
            SnippetFrameStateAssignment.NodeStateAssignment assignment = (SnippetFrameStateAssignment.NodeStateAssignment)((Object)stateAssignments.getValue());
            switch (assignment) {
                case AFTER_BCI: {
                    FrameState newState = stateAfter.duplicate();
                    if (stateAfter.values().contains(replacee)) {
                        final ValueNode valueInReplacement = (ValueNode)duplicates.get((Object)this.returnNode.result());
                        newState.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

                            @Override
                            public void apply(Node from, Position p) {
                                if (p.get(from) == replacee) {
                                    p.set(from, valueInReplacement);
                                }
                            }
                        });
                    }
                    ((StateSplit)duplicates.get((Object)nodeRequiringState)).setStateAfter(newState);
                    break;
                }
                case BEFORE_BCI: {
                    FrameState stateBeforeSnippet = SnippetTemplate.findLastFrameState(replaceeGraphCFGPredecessor);
                    ((StateSplit)duplicates.get((Object)nodeRequiringState)).setStateAfter(stateBeforeSnippet.duplicate());
                    break;
                }
                case INVALID: {
                    throw GraalError.shouldNotReachHere("Invalid snippet replacing a node before frame state assignment with node " + nodeRequiringState + " for replacee " + replacee);
                }
                default: {
                    throw GraalError.shouldNotReachHere("Unknown StateAssigment:" + (Object)((Object)assignment));
                }
            }
            replacee.graph().getDebug().dump(5, (Object)replacee.graph(), "After duplicating after state for node %s in snippet", duplicates.get((Object)nodeRequiringState));
        }
    }

    private void rewireFrameStatesAfterFSA(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
        DeoptimizingNode replaceeDeopt = (DeoptimizingNode)((Object)replacee);
        FrameState stateBefore = null;
        FrameState stateDuring = null;
        FrameState stateAfter = null;
        if (replaceeDeopt.canDeoptimize()) {
            if (replaceeDeopt instanceof DeoptimizingNode.DeoptBefore) {
                stateBefore = ((DeoptimizingNode.DeoptBefore)replaceeDeopt).stateBefore();
            }
            if (replaceeDeopt instanceof DeoptimizingNode.DeoptDuring) {
                stateDuring = ((DeoptimizingNode.DeoptDuring)replaceeDeopt).stateDuring();
            }
            if (replaceeDeopt instanceof DeoptimizingNode.DeoptAfter) {
                stateAfter = ((DeoptimizingNode.DeoptAfter)replaceeDeopt).stateAfter();
            }
        }
        for (DeoptimizingNode deoptNode : this.deoptNodes) {
            DeoptimizingNode deoptDup = (DeoptimizingNode)duplicates.get((Object)deoptNode.asNode());
            if (!deoptDup.canDeoptimize()) continue;
            if (deoptDup instanceof DeoptimizingNode.DeoptBefore) {
                ((DeoptimizingNode.DeoptBefore)deoptDup).setStateBefore(stateBefore);
            }
            if (deoptDup instanceof DeoptimizingNode.DeoptDuring) {
                DeoptimizingNode.DeoptDuring deoptDupDuring = (DeoptimizingNode.DeoptDuring)deoptDup;
                if (stateDuring != null) {
                    deoptDupDuring.setStateDuring(stateDuring);
                } else if (stateAfter != null) {
                    deoptDupDuring.computeStateDuring(stateAfter);
                } else if (stateBefore != null) {
                    assert (((DeoptimizingNode.DeoptBefore)replaceeDeopt).canUseAsStateDuring() || !deoptDupDuring.hasSideEffect()) : "can't use stateBefore as stateDuring for state split " + deoptDupDuring;
                    deoptDupDuring.setStateDuring(stateBefore);
                }
            }
            if (!(deoptDup instanceof DeoptimizingNode.DeoptAfter)) continue;
            DeoptimizingNode.DeoptAfter deoptDupAfter = (DeoptimizingNode.DeoptAfter)deoptDup;
            if (stateAfter != null) {
                deoptDupAfter.setStateAfter(stateAfter);
                continue;
            }
            assert (!deoptDupAfter.hasSideEffect()) : "can't use stateBefore as stateAfter for state split " + deoptDupAfter;
            deoptDupAfter.setStateAfter(stateBefore);
        }
    }

    public static FrameState findLastFrameState(FixedNode start) {
        FrameState state = SnippetTemplate.findLastFrameState(start, false);
        assert (state != null) : "Must find a prev state (this can be transitively broken) for node " + start + " " + SnippetTemplate.findLastFrameState(start, true);
        return state;
    }

    public static FrameState findLastFrameState(FixedNode start, boolean log) {
        assert (start != null);
        Node lastFixedNode = null;
        FixedNode currentStart = start;
        while (true) {
            for (FixedNode fixed : GraphUtil.predecessorIterable(currentStart)) {
                if (fixed instanceof StateSplit) {
                    StateSplit stateSplit = (StateSplit)((Object)fixed);
                    assert (!stateSplit.hasSideEffect() || stateSplit.stateAfter() != null) : "Found state split with side-effect without framestate=" + stateSplit;
                    if (stateSplit.stateAfter() != null) {
                        return stateSplit.stateAfter();
                    }
                }
                lastFixedNode = fixed;
            }
            if (!(lastFixedNode instanceof LoopBeginNode)) break;
            currentStart = ((LoopBeginNode)lastFixedNode).forwardEnd();
        }
        if (log) {
            NodeSourcePosition p = lastFixedNode.getNodeSourcePosition();
            DebugContext debug = start.getDebug();
            debug.log(5, "Last fixed node %s\n with source position -> %s", (Object)lastFixedNode, (Object)(p == null ? "null" : p.toString()));
            if (lastFixedNode instanceof MergeNode) {
                MergeNode merge = (MergeNode)lastFixedNode;
                debug.log(5, "Last fixed node is a merge with predecessors:");
                for (EndNode end : merge.forwardEnds()) {
                    Iterator iterator = GraphUtil.predecessorIterable(end).iterator();
                    while (iterator.hasNext()) {
                        FixedNode fixed;
                        NodeSourcePosition sp = (fixed = (FixedNode)iterator.next()).getNodeSourcePosition();
                        debug.log(5, "%s:source position%s", (Object)fixed, (Object)(sp != null ? sp.toString() : "null"));
                    }
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.snippet.toString()).append('(');
        String sep = "";
        for (int i = 0; i < this.parameters.length; ++i) {
            String name = "[" + i + "]";
            Object value = this.parameters[i];
            buf.append(sep);
            sep = ", ";
            if (value == null) {
                buf.append("<null> ").append(name);
                continue;
            }
            if (value.equals(UNUSED_PARAMETER)) {
                buf.append("<unused> ").append(name);
                continue;
            }
            if (value.equals(CONSTANT_PARAMETER)) {
                buf.append("<constant> ").append(name);
                continue;
            }
            if (value instanceof ParameterNode) {
                ParameterNode param = (ParameterNode)value;
                buf.append(param.getStackKind().getJavaName()).append(' ').append(name);
                continue;
            }
            ParameterNode[] params = (ParameterNode[])value;
            String kind = params.length == 0 ? "?" : params[0].getStackKind().getJavaName();
            buf.append(kind).append('[').append(params.length).append("] ").append(name);
        }
        return buf.append(')').toString();
    }

    private static boolean checkTemplate(MetaAccessProvider metaAccess, Arguments args, ResolvedJavaMethod method, Signature signature) {
        int offset;
        for (int i = offset = args.info.hasReceiver() ? 1 : 0; i < args.info.getParameterCount(); ++i) {
            if (args.info.isConstantParameter(i)) {
                JavaKind kind = signature.getParameterKind(i - offset);
                assert (Services.IS_IN_NATIVE_IMAGE || SnippetTemplate.checkConstantArgument(metaAccess, method, signature, i - offset, args.info.getParameterName(i), args.values[i], kind));
                continue;
            }
            if (args.info.isVarargsParameter(i)) {
                assert (args.values[i] instanceof Varargs);
                Varargs varargs = (Varargs)args.values[i];
                assert (Services.IS_IN_NATIVE_IMAGE || SnippetTemplate.checkVarargs(metaAccess, method, signature, i - offset, args.info.getParameterName(i), varargs));
                continue;
            }
            if (args.info.isNonNullParameter(i)) assert (SnippetTemplate.checkNonNull(method, args.info.getParameterName(i), args.values[i]));
        }
        return true;
    }

    public void setMayRemoveLocation(boolean mayRemoveLocation) {
        this.mayRemoveLocation = mayRemoveLocation;
    }

    private class MemoryOutputMap
    extends MemoryInputMap {
        private final UnmodifiableEconomicMap<Node, Node> duplicates;

        MemoryOutputMap(ValueNode replacee, UnmodifiableEconomicMap<Node, Node> duplicates) {
            super(replacee);
            this.duplicates = duplicates;
        }

        @Override
        public MemoryKill getLastLocationAccess(LocationIdentity locationIdentity) {
            MemoryMapNode memoryMap = SnippetTemplate.this.returnNode.getMemoryMap();
            assert (memoryMap != null) : "no memory map stored for this snippet graph (snippet doesn't have a ReturnNode?)";
            MemoryKill lastLocationAccess = memoryMap.getLastLocationAccess(locationIdentity);
            assert (lastLocationAccess != null) : locationIdentity;
            if (lastLocationAccess == SnippetTemplate.this.memoryAnchor) {
                return super.getLastLocationAccess(locationIdentity);
            }
            return (MemoryKill)this.duplicates.get((Object)ValueNodeUtil.asNode(lastLocationAccess));
        }

        @Override
        public Collection<LocationIdentity> getLocations() {
            return SnippetTemplate.this.returnNode.getMemoryMap().getLocations();
        }
    }

    private static class MemoryInputMap
    implements MemoryMap {
        private final LocationIdentity locationIdentity;
        private final MemoryKill lastLocationAccess;

        MemoryInputMap(ValueNode replacee) {
            if (replacee instanceof MemoryAccess) {
                MemoryAccess access = (MemoryAccess)((Object)replacee);
                this.locationIdentity = access.getLocationIdentity();
                this.lastLocationAccess = access.getLastLocationAccess();
            } else {
                this.locationIdentity = null;
                this.lastLocationAccess = null;
            }
        }

        @Override
        public MemoryKill getLastLocationAccess(LocationIdentity location) {
            if (this.locationIdentity != null && this.locationIdentity.equals(location)) {
                return this.lastLocationAccess;
            }
            return null;
        }

        public Collection<LocationIdentity> getLocations() {
            if (this.locationIdentity == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.locationIdentity);
        }
    }

    public static interface UsageReplacer {
        public void replace(ValueNode var1, ValueNode var2);
    }

    private static final class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int maxCacheSize;

        LRUCache(int initialCapacity, int maxCacheSize) {
            super(initialCapacity, 0.75f, true);
            this.maxCacheSize = maxCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCacheSize;
        }
    }

    public static abstract class AbstractTemplates
    implements SnippetTemplateCache {
        protected final OptionValues options;
        protected final Providers providers;
        protected final MetaAccessProvider metaAccess;
        protected final SnippetReflectionProvider snippetReflection;
        protected final Iterable<DebugHandlersFactory> factories;
        protected final TargetDescription target;
        private final Map<CacheKey, SnippetTemplate> templates;
        static final AtomicInteger nextSnippetTemplateId = new AtomicInteger();

        protected AbstractTemplates(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            this.options = options;
            this.providers = providers;
            this.metaAccess = providers.getMetaAccess();
            this.snippetReflection = snippetReflection;
            this.target = target;
            this.factories = factories;
            if (Options.UseSnippetTemplateCache.getValue(options).booleanValue()) {
                int size = Options.MaxTemplatesPerSnippet.getValue(options);
                this.templates = Collections.synchronizedMap(new LRUCache(size, size));
            } else {
                this.templates = null;
            }
        }

        public MetaAccessProvider getMetaAccess() {
            return this.metaAccess;
        }

        public static Method findMethod(Class<?> declaringClass, String methodName, Method except) {
            for (Method m : declaringClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodName) || m.equals(except)) continue;
                return m;
            }
            return null;
        }

        public static ResolvedJavaMethod findMethod(MetaAccessProvider metaAccess, Class<?> declaringClass, String methodName) {
            ResolvedJavaType type = metaAccess.lookupJavaType(declaringClass);
            ResolvedJavaMethod result = null;
            for (ResolvedJavaMethod m : type.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                if (!Assertions.assertionsEnabled()) {
                    return m;
                }
                assert (result == null) : "multiple definitions found";
                result = m;
            }
            if (result == null) {
                throw new GraalError("Could not find method in " + declaringClass + " named " + methodName);
            }
            return result;
        }

        protected SnippetInfo snippet(Class<? extends Snippets> declaringClass, String methodName, LocationIdentity ... initialPrivateLocations) {
            return this.snippet(declaringClass, methodName, null, (Object)null, initialPrivateLocations);
        }

        protected SnippetInfo snippet(Class<? extends Snippets> declaringClass, String methodName, ResolvedJavaMethod original, Object receiver, LocationIdentity ... initialPrivateLocations) {
            LocationIdentity[] privateLocations;
            assert (methodName != null);
            ResolvedJavaMethod javaMethod = AbstractTemplates.findMethod(this.getMetaAccess(), declaringClass, methodName);
            assert (javaMethod != null) : "did not find @" + Snippet.class.getSimpleName() + " method in " + declaringClass + " named " + methodName;
            this.providers.getReplacements().registerSnippet(javaMethod, original, receiver, GraalOptions.TrackNodeSourcePosition.getValue(this.options), this.options);
            LocationIdentity[] locationIdentityArray = privateLocations = GraalOptions.SnippetCounters.getValue(this.options) != false ? SnippetCounterNode.addSnippetCounters(initialPrivateLocations) : initialPrivateLocations;
            if (Services.IS_IN_NATIVE_IMAGE || GraalOptions.EagerSnippets.getValue(this.options).booleanValue()) {
                SnippetParameterInfo snippetParameterInfo = this.providers.getReplacements().getSnippetParameterInfo(javaMethod);
                return new EagerSnippetInfo(javaMethod, original, privateLocations, receiver, snippetParameterInfo);
            }
            return new LazySnippetInfo(javaMethod, original, privateLocations, receiver);
        }

        private DebugContext openDebugContext(DebugContext outer, Arguments args) {
            if (DebugOptions.DebugStubsAndSnippets.getValue(this.options).booleanValue()) {
                DebugContext.Description description = new DebugContext.Description(args.cacheKey.method, "SnippetTemplate_" + nextSnippetTemplateId.incrementAndGet());
                return new DebugContext.Builder(this.options, this.factories).globalMetrics(outer.getGlobalMetrics()).description(description).build();
            }
            return DebugContext.disabled(this.options);
        }

        public SnippetTemplate template(ValueNode replacee, Arguments args) {
            SnippetTemplate template;
            StructuredGraph graph = replacee.graph();
            DebugContext outer = graph.getDebug();
            SnippetTemplate snippetTemplate = template = Options.UseSnippetTemplateCache.getValue(this.options) != false && args.cacheable ? this.templates.get(args.cacheKey) : null;
            if (template == null || graph.trackNodeSourcePosition() && !template.snippet.trackNodeSourcePosition()) {
                try (DebugContext debug = this.openDebugContext(outer, args);){
                    try (DebugCloseable a = SnippetTemplateCreationTime.start(debug);
                         DebugContext.Scope s = debug.scope((Object)"SnippetSpecialization", args.info.method);){
                        SnippetTemplates.increment(debug);
                        OptionValues snippetOptions = new OptionValues(this.options, GraalOptions.TraceInlining, GraalOptions.TraceInliningForStubsAndSnippets.getValue(this.options), new Object[0]);
                        template = new SnippetTemplate(snippetOptions, debug, this.providers, this.snippetReflection, args, graph.trackNodeSourcePosition(), replacee, this.createMidTierPhases());
                        if (Options.UseSnippetTemplateCache.getValue(snippetOptions).booleanValue() && args.cacheable) {
                            this.templates.put(args.cacheKey, template);
                        }
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                }
            }
            return template;
        }

        protected PhaseSuite<Providers> createMidTierPhases() {
            return null;
        }
    }

    static class Options {
        @Option(help={"Use a LRU cache for snippet templates."})
        public static final OptionKey<Boolean> UseSnippetTemplateCache = new OptionKey<Boolean>(true);
        @Option(help={""})
        static final OptionKey<Integer> MaxTemplatesPerSnippet = new OptionKey<Integer>(50);

        Options() {
        }
    }

    static class CacheKey {
        private final ResolvedJavaMethod method;
        private final Object[] values;
        private final StructuredGraph.GuardsStage guardsStage;
        private final LoweringTool.LoweringStage loweringStage;
        private int hash;

        protected CacheKey(SnippetInfo info, StructuredGraph.GuardsStage guardsStage, LoweringTool.LoweringStage loweringStage) {
            this.method = info.method;
            this.guardsStage = guardsStage;
            this.loweringStage = loweringStage;
            this.values = new Object[info.getParameterCount()];
            this.hash = info.method.hashCode() + 31 * guardsStage.ordinal();
        }

        protected void setParam(int paramIdx, Object value) {
            this.values[paramIdx] = value;
            this.hash = this.hash * 31 ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!this.method.equals(other.method)) {
                return false;
            }
            if (this.guardsStage != other.guardsStage || this.loweringStage != other.loweringStage) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null || this.values[i].equals(other.values[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    static final class VarargsPlaceholderNode
    extends FloatingNode
    implements ArrayLengthProvider {
        public static final NodeClass<VarargsPlaceholderNode> TYPE = NodeClass.create(VarargsPlaceholderNode.class);
        protected final Varargs varargs;

        protected VarargsPlaceholderNode(Varargs varargs, MetaAccessProvider metaAccess) {
            super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(metaAccess.lookupJavaType(varargs.componentType).getArrayClass())));
            this.varargs = varargs;
        }

        @Override
        public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
            return ConstantNode.forInt(this.varargs.length);
        }
    }

    static class Varargs {
        protected final Class<?> componentType;
        protected final Stamp stamp;
        protected final Object value;
        protected final int length;

        protected Varargs(Class<?> componentType, Stamp stamp, Object value) {
            this.componentType = componentType;
            this.stamp = stamp;
            this.value = value;
            this.length = value instanceof List ? ((List)value).size() : Array.getLength(value);
        }

        public String toString() {
            if (this.value instanceof boolean[]) {
                return Arrays.toString((boolean[])this.value);
            }
            if (this.value instanceof byte[]) {
                return Arrays.toString((byte[])this.value);
            }
            if (this.value instanceof char[]) {
                return Arrays.toString((char[])this.value);
            }
            if (this.value instanceof short[]) {
                return Arrays.toString((short[])this.value);
            }
            if (this.value instanceof int[]) {
                return Arrays.toString((int[])this.value);
            }
            if (this.value instanceof long[]) {
                return Arrays.toString((long[])this.value);
            }
            if (this.value instanceof float[]) {
                return Arrays.toString((float[])this.value);
            }
            if (this.value instanceof double[]) {
                return Arrays.toString((double[])this.value);
            }
            if (this.value instanceof Object[]) {
                return Arrays.toString((Object[])this.value);
            }
            return String.valueOf(this.value);
        }
    }

    public static class Arguments
    implements Formattable {
        protected final SnippetInfo info;
        protected final CacheKey cacheKey;
        protected final Object[] values;
        protected final Stamp[] constStamps;
        protected boolean cacheable;
        protected int nextParamIdx;

        public Arguments(SnippetInfo info, StructuredGraph.GuardsStage guardsStage, LoweringTool.LoweringStage loweringStage) {
            this.info = info;
            this.cacheKey = new CacheKey(info, guardsStage, loweringStage);
            this.values = new Object[info.getParameterCount()];
            this.constStamps = new Stamp[info.getParameterCount()];
            this.cacheable = true;
            if (info.hasReceiver()) {
                this.addConst("this", info.getReceiver());
            }
        }

        public Arguments add(String name, Object value) {
            assert (this.check(name, false, false));
            this.values[this.nextParamIdx] = value;
            ++this.nextParamIdx;
            return this;
        }

        public Arguments addConst(String name, Object value) {
            assert (value != null);
            if (value instanceof CStringConstant) {
                return this.addConst(name, value, StampFactory.pointer());
            }
            return this.addConst(name, value, null);
        }

        public Arguments addConst(String name, Object value, Stamp stamp) {
            assert (this.check(name, true, false));
            this.values[this.nextParamIdx] = value;
            this.constStamps[this.nextParamIdx] = stamp;
            this.cacheKey.setParam(this.nextParamIdx, value);
            ++this.nextParamIdx;
            return this;
        }

        public Arguments addVarargs(String name, Class<?> componentType, Stamp argStamp, Object value) {
            assert (this.check(name, false, true));
            Varargs varargs = new Varargs(componentType, argStamp, value);
            this.values[this.nextParamIdx] = varargs;
            this.cacheKey.setParam(this.nextParamIdx, varargs.length);
            ++this.nextParamIdx;
            return this;
        }

        public void setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
        }

        private boolean check(String name, boolean constParam, boolean varargsParam) {
            assert (this.nextParamIdx < this.info.getParameterCount()) : "too many parameters: " + name + "  " + this;
            assert (this.info.getParameterName(this.nextParamIdx) == null || this.info.getParameterName(this.nextParamIdx).equals(name)) : "wrong parameter name at " + this.nextParamIdx + " : " + name + "  " + this;
            assert (constParam == this.info.isConstantParameter(this.nextParamIdx)) : "Parameter " + (constParam ? "not " : "") + "annotated with @" + Snippet.ConstantParameter.class.getSimpleName() + ": " + name + "  " + this;
            assert (varargsParam == this.info.isVarargsParameter(this.nextParamIdx)) : "Parameter " + (varargsParam ? "not " : "") + "annotated with @" + Snippet.VarargsParameter.class.getSimpleName() + ": " + name + "  " + this;
            return true;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Parameters<").append(this.info.method.format("%h.%n")).append(" [");
            String sep = "";
            for (int i = 0; i < this.info.getParameterCount(); ++i) {
                result.append(sep);
                if (this.info.isConstantParameter(i)) {
                    result.append("const ");
                } else if (this.info.isVarargsParameter(i)) {
                    result.append("varargs ");
                }
                result.append(this.info.getParameterName(i)).append(" = ").append(this.values[i]);
                sep = ", ";
            }
            result.append(">");
            return result.toString();
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            if ((flags & 4) == 0) {
                formatter.format(DebugContext.applyFormattingFlagsAndWidth(this.toString(), flags, width), new Object[0]);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(this.info.method.getName()).append('(');
                String sep = "";
                for (int i = 0; i < this.info.getParameterCount(); ++i) {
                    if (!this.info.isConstantParameter(i)) continue;
                    sb.append(sep);
                    if (this.info.getParameterName(i) != null) {
                        sb.append(this.info.getParameterName(i));
                    } else {
                        sb.append(i);
                    }
                    sb.append('=').append(this.values[i]);
                    sep = ", ";
                }
                sb.append(")");
                String string = sb.toString();
                if (string.indexOf(37) != -1) {
                    string = string.replace("%", "%%");
                }
                formatter.format(DebugContext.applyFormattingFlagsAndWidth(string, flags & 0xFFFFFFFB, width), new Object[0]);
            }
        }
    }

    public static class EagerSnippetInfo
    extends SnippetInfo {
        protected final SnippetParameterInfo snippetParameterInfo;

        protected EagerSnippetInfo(ResolvedJavaMethod method, ResolvedJavaMethod original, LocationIdentity[] privateLocations, Object receiver, SnippetParameterInfo snippetParameterInfo) {
            super(method, original, privateLocations, receiver);
            this.snippetParameterInfo = snippetParameterInfo;
        }

        @Override
        protected SnippetParameterInfo info() {
            return this.snippetParameterInfo;
        }
    }

    protected static class LazySnippetInfo
    extends SnippetInfo {
        protected final AtomicReference<SnippetParameterInfo> lazy = new AtomicReference<Object>(null);

        protected LazySnippetInfo(ResolvedJavaMethod method, ResolvedJavaMethod original, LocationIdentity[] privateLocations, Object receiver) {
            super(method, original, privateLocations, receiver);
        }

        @Override
        protected SnippetParameterInfo info() {
            if (this.lazy.get() == null) {
                this.lazy.compareAndSet(null, new SnippetParameterInfo(this.method));
            }
            return this.lazy.get();
        }
    }

    public static abstract class SnippetInfo {
        protected final ResolvedJavaMethod method;
        protected final ResolvedJavaMethod original;
        protected final LocationIdentity[] privateLocations;
        protected final Object receiver;
        private final TimerKey instantiationTimer;
        private final CounterKey instantiationCounter;

        public Object getReceiver() {
            return this.receiver;
        }

        boolean hasReceiver() {
            assert (SnippetInfo.hasReceiver(this.method) == (this.receiver != null)) : "Snippet with the receiver must have it set as constant. Snippet: " + this;
            return SnippetInfo.hasReceiver(this.method);
        }

        static boolean hasReceiver(ResolvedJavaMethod method) {
            return method.hasReceiver();
        }

        protected abstract SnippetParameterInfo info();

        protected SnippetInfo(ResolvedJavaMethod method, ResolvedJavaMethod original, LocationIdentity[] privateLocations, Object receiver) {
            this.method = method;
            this.original = original;
            this.privateLocations = privateLocations;
            this.instantiationCounter = DebugContext.counter("SnippetInstantiationCount[%s]", method.getName());
            this.instantiationTimer = DebugContext.timer("SnippetInstantiationTime[%s]", method.getName());
            this.receiver = receiver;
        }

        public ResolvedJavaMethod getMethod() {
            return this.method;
        }

        public int getParameterCount() {
            return this.info().getParameterCount();
        }

        public boolean isConstantParameter(int paramIdx) {
            return this.info().isConstantParameter(paramIdx);
        }

        public boolean isVarargsParameter(int paramIdx) {
            return this.info().isVarargsParameter(paramIdx);
        }

        public boolean isNonNullParameter(int paramIdx) {
            return this.info().isNonNullParameter(paramIdx);
        }

        public String getParameterName(int paramIdx) {
            return this.info().getParameterName(paramIdx);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.method.format("%h.%n");
        }
    }
}

