/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;

@ClassSubstitution(value=String.class)
public class JDK9StringSubstitutions {
    @MethodSubstitution(isStatic=false)
    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="reference equality on the receiver is what we want")
    public static boolean equals(String thisString, Object obj) {
        if (thisString == obj) {
            return true;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        String thatString = (String)obj;
        if (thisString.length() != thatString.length()) {
            return false;
        }
        if (thisString.length() == 0) {
            return true;
        }
        if (JDK9StringSubstitutions.getCoder(thisString) != JDK9StringSubstitutions.getCoder(thatString)) {
            return false;
        }
        byte[] array1 = JDK9StringSubstitutions.getValue(thisString);
        byte[] array2 = JDK9StringSubstitutions.getValue(thatString);
        return ArrayEqualsNode.equals(array1, array2, array1.length);
    }

    public static native byte[] getValue(String var0);

    public static native int getCoder(String var0);

    public static boolean isCompactString(String s) {
        return JDK9StringSubstitutions.getCoder(s) == 0;
    }
}

