/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionValues;

public class IntrinsicGraphBuilder
implements GraphBuilderContext,
InvocationPlugin.Receiver {
    protected final CoreProviders providers;
    protected final StructuredGraph graph;
    protected final Bytecode code;
    protected final ResolvedJavaMethod method;
    protected final int invokeBci;
    protected FixedWithNextNode lastInstr;
    protected ValueNode[] arguments;
    protected ValueNode returnValue;

    private FrameState createStateAfterStartOfReplacementGraph(ResolvedJavaMethod original, GraphBuilderConfiguration graphBuilderConfig) {
        FrameStateBuilder startFrameState = new FrameStateBuilder(this, this.code, this.graph, graphBuilderConfig.retainLocalVariables());
        startFrameState.initializeForMethodStart(this.graph.getAssumptions(), false, graphBuilderConfig.getPlugins());
        return startFrameState.createInitialIntrinsicFrameState(original);
    }

    public IntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code, int invokeBci) {
        this(options, debug, providers, code, invokeBci, StructuredGraph.AllowAssumptions.YES, null);
    }

    public IntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code, int invokeBci, StructuredGraph.AllowAssumptions allowAssumptions) {
        this(options, debug, providers, code, invokeBci, allowAssumptions, null);
    }

    protected IntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code, int invokeBci, StructuredGraph.AllowAssumptions allowAssumptions, GraphBuilderConfiguration graphBuilderConfig) {
        this.providers = providers;
        this.code = code;
        this.method = code.getMethod();
        this.graph = new StructuredGraph.Builder(options, debug, allowAssumptions).method(this.method).setIsSubstitution(true).trackNodeSourcePosition(true).build();
        this.invokeBci = invokeBci;
        this.lastInstr = this.graph.start();
        if (graphBuilderConfig != null && !this.method.isNative()) {
            this.graph.start().setStateAfter(this.createStateAfterStartOfReplacementGraph(this.method, graphBuilderConfig));
        }
        Signature sig = this.method.getSignature();
        int max = sig.getParameterCount(false);
        this.arguments = new ValueNode[max + (this.method.isStatic() ? 0 : 1)];
        int javaIndex = 0;
        int index = 0;
        if (!this.method.isStatic()) {
            ValueNode receiver;
            ObjectStamp receiverStamp = StampFactory.objectNonNull(TypeReference.createWithoutAssumptions(this.method.getDeclaringClass()));
            this.arguments[index] = receiver = (ValueNode)this.graph.addWithoutUnique(new ParameterNode(javaIndex, StampPair.createSingle(receiverStamp)));
            javaIndex = 1;
            index = 1;
        }
        ResolvedJavaType accessingClass = this.method.getDeclaringClass();
        for (int i = 0; i < max; ++i) {
            ValueNode param;
            ResolvedJavaType type = sig.getParameterType(i, accessingClass).resolve(accessingClass);
            JavaKind kind = type.getJavaKind();
            Stamp stamp = kind == JavaKind.Object && type instanceof ResolvedJavaType ? StampFactory.object(TypeReference.createWithoutAssumptions(type)) : StampFactory.forKind(kind);
            this.arguments[index] = param = (ValueNode)this.graph.addWithoutUnique(new ParameterNode(index, StampPair.createSingle(stamp)));
            javaIndex += kind.getSlotCount();
            ++index;
        }
    }

    private <T extends ValueNode> void updateLastInstruction(T v) {
        if (v instanceof FixedNode) {
            FixedNode fixedNode = (FixedNode)v;
            if (this.lastInstr != null) {
                this.lastInstr.setNext(fixedNode);
            }
            if (fixedNode instanceof FixedWithNextNode) {
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)fixedNode;
                assert (fixedWithNextNode.next() == null) : "cannot append instruction to instruction which isn't end";
                this.lastInstr = fixedWithNextNode;
            } else if (fixedNode instanceof WithExceptionNode) {
                WithExceptionNode withExceptionNode = (WithExceptionNode)fixedNode;
                AbstractBeginNode normalSuccessor = this.graph.add(withExceptionNode.createNextBegin());
                ExceptionObjectNode exceptionSuccessor = this.graph.add(new ExceptionObjectNode(this.getMetaAccess()));
                this.setExceptionState(exceptionSuccessor);
                exceptionSuccessor.setNext(this.graph.add(new UnwindNode(exceptionSuccessor)));
                withExceptionNode.setNext(normalSuccessor);
                withExceptionNode.setExceptionEdge(exceptionSuccessor);
                this.lastInstr = normalSuccessor;
            } else {
                this.lastInstr = null;
            }
        }
    }

    @Override
    public AbstractBeginNode genExplicitExceptionEdge(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... exceptionArguments) {
        BytecodeExceptionNode exceptionNode = this.graph.add(new BytecodeExceptionNode(this.getMetaAccess(), exceptionKind, exceptionArguments));
        this.setExceptionState(exceptionNode);
        exceptionNode.setNext(this.graph.add(new UnwindNode(exceptionNode)));
        return BeginNode.begin(exceptionNode);
    }

    protected void setExceptionState(StateSplit exceptionObject) {
        throw GraalError.shouldNotReachHere("unsupported by this IntrinsicGraphBuilder");
    }

    protected void mergeUnwinds() {
        if (this.getGraph().getNodes().filter(UnwindNode.class).count() > 1) {
            throw GraalError.shouldNotReachHere("mergeUnwinds unsupported by this IntrinsicGraphBuilder");
        }
    }

    @Override
    public <T extends ValueNode> T append(T v) {
        if (v.graph() != null) {
            return v;
        }
        T added = this.graph.addOrUniqueWithInputs(v);
        if (added == v) {
            this.updateLastInstruction(v);
        }
        return added;
    }

    @Override
    public void push(JavaKind kind, ValueNode value) {
        assert (kind != JavaKind.Void);
        GraalError.guarantee(this.returnValue == null, "can only push one value");
        this.returnValue = value;
    }

    @Override
    public ValueNode pop(JavaKind slotKind) {
        GraalError.guarantee(this.returnValue != null, "no value pushed");
        ValueNode result = this.returnValue;
        this.returnValue = null;
        return result;
    }

    @Override
    public Invoke handleReplacedInvoke(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, boolean forceInlineEverything) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void handleReplacedInvoke(CallTargetNode callTarget, JavaKind resultType) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public StampProvider getStampProvider() {
        return this.providers.getStampProvider();
    }

    @Override
    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    @Override
    public ConstantReflectionProvider getConstantReflection() {
        return this.providers.getConstantReflection();
    }

    @Override
    public ConstantFieldProvider getConstantFieldProvider() {
        return this.providers.getConstantFieldProvider();
    }

    @Override
    public Replacements getReplacements() {
        return this.providers.getReplacements();
    }

    @Override
    public StructuredGraph getGraph() {
        return this.graph;
    }

    @Override
    public void setStateAfter(StateSplit sideEffect) {
        assert (sideEffect.hasSideEffect());
        FrameState stateAfter = this.getGraph().add(new FrameState(-3));
        sideEffect.setStateAfter(stateAfter);
    }

    @Override
    public GraphBuilderContext getParent() {
        return null;
    }

    @Override
    public Bytecode getCode() {
        return this.code;
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    @Override
    public int bci() {
        return this.invokeBci;
    }

    @Override
    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.method.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Virtual;
    }

    @Override
    public JavaType getInvokeReturnType() {
        return this.method.getSignature().getReturnType(this.method.getDeclaringClass());
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public boolean parsingIntrinsic() {
        return true;
    }

    @Override
    public IntrinsicContext getIntrinsic() {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public BailoutException bailout(String string) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public ValueNode get(boolean performNullCheck) {
        return this.arguments[0];
    }

    public StructuredGraph buildGraph(InvocationPlugin plugin) {
        NodeSourcePosition position = this.graph.trackNodeSourcePosition() ? NodeSourcePosition.placeholder(this.method) : null;
        try (DebugCloseable context = this.graph.withNodeSourcePosition(position);){
            IntrinsicGraphBuilder receiver;
            IntrinsicGraphBuilder intrinsicGraphBuilder = receiver = this.method.isStatic() ? null : this;
            if (plugin.execute(this, this.method, receiver, this.arguments)) {
                assert (this.returnValue != null == (this.method.getSignature().getReturnKind() != JavaKind.Void)) : this.method;
                assert (this.lastInstr != null) : "ReturnNode must be linked into control flow";
                this.append(new ReturnNode(this.returnValue));
                this.mergeUnwinds();
                StructuredGraph structuredGraph = this.graph;
                return structuredGraph;
            }
            StructuredGraph structuredGraph = null;
            return structuredGraph;
        }
    }

    @Override
    public boolean intrinsify(BytecodeProvider bytecodeProvider, ResolvedJavaMethod targetMethod, ResolvedJavaMethod substitute, InvocationPlugin.Receiver receiver, ValueNode[] args) {
        return false;
    }

    @Override
    public boolean intrinsify(ResolvedJavaMethod targetMethod, StructuredGraph substituteGraph, InvocationPlugin.Receiver receiver, ValueNode[] argsIncludingReceiver) {
        return false;
    }

    public String toString() {
        return String.format("%s:intrinsic", this.method.format("%H.%n(%p)"));
    }
}

