/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnpackEndianHalfNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.debug.VerifyHeapNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ClassIsArrayNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GuardedUnsafeLoadNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.LoadArrayComponentHubNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.LoadHubOrNullNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.extended.UnsafeMemoryLoadNode;
import org.graalvm.compiler.nodes.extended.UnsafeMemoryStoreNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.AccessIndexedNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndAddNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.LogicCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.LoweredAtomicReadAndAddNode;
import org.graalvm.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.RegisterFinalizerNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.ValueCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.SideEffectFreeWrite;
import org.graalvm.compiler.nodes.memory.VolatileReadNode;
import org.graalvm.compiler.nodes.memory.VolatileWriteNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.IndexAddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.BoxingSnippets;
import org.graalvm.compiler.replacements.ConstantStringIndexOfSnippets;
import org.graalvm.compiler.replacements.IdentityHashCodeSnippets;
import org.graalvm.compiler.replacements.IsArraySnippets;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetCounterNode;
import org.graalvm.compiler.replacements.SnippetLowerableMemoryNode;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.StringIndexOfNode;
import org.graalvm.compiler.replacements.StringLatin1IndexOfNode;
import org.graalvm.compiler.replacements.StringUTF16IndexOfNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.IdentityHashCodeNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.word.LocationIdentity;

public abstract class DefaultJavaLoweringProvider
implements LoweringProvider {
    protected final MetaAccessProvider metaAccess;
    protected final ForeignCallsProvider foreignCalls;
    protected final BarrierSet barrierSet;
    protected final MetaAccessExtensionProvider metaAccessExtensionProvider;
    protected final TargetDescription target;
    private final boolean useCompressedOops;
    protected Replacements replacements;
    private BoxingSnippets.Templates boxingSnippets;
    private ConstantStringIndexOfSnippets.Templates indexOfSnippets;
    protected IdentityHashCodeSnippets.Templates identityHashCodeSnippets;
    protected IsArraySnippets.Templates isArraySnippets;
    public static final IntegerStamp POSITIVE_ARRAY_INDEX_STAMP = StampFactory.forInteger(32, 0L, 0x7FFFFFFEL);

    public DefaultJavaLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target, boolean useCompressedOops) {
        this.metaAccess = metaAccess;
        this.foreignCalls = foreignCalls;
        this.barrierSet = platformConfig.getBarrierSet();
        this.metaAccessExtensionProvider = metaAccessExtensionProvider;
        this.target = target;
        this.useCompressedOops = useCompressedOops;
    }

    public void initialize(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, Providers providers, SnippetReflectionProvider snippetReflection) {
        this.boxingSnippets = new BoxingSnippets.Templates(options, factories, factory, providers, snippetReflection, this.target);
        this.indexOfSnippets = new ConstantStringIndexOfSnippets.Templates(options, factories, providers, snippetReflection, this.target);
        this.replacements = providers.getReplacements();
        providers.getReplacements().registerSnippetTemplateCache(new SnippetCounterNode.SnippetCounterSnippets.Templates(options, factories, providers, snippetReflection, this.target));
    }

    public final TargetDescription getTarget() {
        return this.target;
    }

    public MetaAccessProvider getMetaAccess() {
        return this.metaAccess;
    }

    public BarrierSet getBarrierSet() {
        return this.barrierSet;
    }

    public MetaAccessExtensionProvider getMetaAccessExtensionProvider() {
        return this.metaAccessExtensionProvider;
    }

    public Replacements getReplacements() {
        return this.replacements;
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        block51: {
            assert (n instanceof Lowerable);
            try (DebugCloseable context = n.withNodeSourcePosition();){
                if (n instanceof LoadFieldNode) {
                    this.lowerLoadFieldNode((LoadFieldNode)n, tool);
                    break block51;
                }
                if (n instanceof StoreFieldNode) {
                    this.lowerStoreFieldNode((StoreFieldNode)n, tool);
                    break block51;
                }
                if (n instanceof LoadIndexedNode) {
                    this.lowerLoadIndexedNode((LoadIndexedNode)n, tool);
                    break block51;
                }
                if (n instanceof StoreIndexedNode) {
                    this.lowerStoreIndexedNode((StoreIndexedNode)n, tool);
                    break block51;
                }
                if (n instanceof IndexAddressNode) {
                    this.lowerIndexAddressNode((IndexAddressNode)n);
                    break block51;
                }
                if (n instanceof ArrayLengthNode) {
                    this.lowerArrayLengthNode((ArrayLengthNode)n, tool);
                    break block51;
                }
                if (n instanceof LoadHubNode) {
                    this.lowerLoadHubNode((LoadHubNode)n, tool);
                    break block51;
                }
                if (n instanceof LoadHubOrNullNode) {
                    this.lowerLoadHubOrNullNode((LoadHubOrNullNode)n, tool);
                    break block51;
                }
                if (n instanceof LoadArrayComponentHubNode) {
                    this.lowerLoadArrayComponentHubNode((LoadArrayComponentHubNode)n);
                    break block51;
                }
                if (n instanceof UnsafeCompareAndSwapNode) {
                    this.lowerCompareAndSwapNode((UnsafeCompareAndSwapNode)n);
                    break block51;
                }
                if (n instanceof UnsafeCompareAndExchangeNode) {
                    this.lowerCompareAndExchangeNode((UnsafeCompareAndExchangeNode)n);
                    break block51;
                }
                if (n instanceof AtomicReadAndWriteNode) {
                    this.lowerAtomicReadAndWriteNode((AtomicReadAndWriteNode)n);
                    break block51;
                }
                if (n instanceof AtomicReadAndAddNode) {
                    this.lowerAtomicReadAndAddNode((AtomicReadAndAddNode)n);
                    break block51;
                }
                if (n instanceof RawLoadNode) {
                    this.lowerUnsafeLoadNode((RawLoadNode)n, tool);
                    break block51;
                }
                if (n instanceof UnsafeMemoryLoadNode) {
                    this.lowerUnsafeMemoryLoadNode((UnsafeMemoryLoadNode)n);
                    break block51;
                }
                if (n instanceof RawStoreNode) {
                    this.lowerUnsafeStoreNode((RawStoreNode)n);
                    break block51;
                }
                if (n instanceof UnsafeMemoryStoreNode) {
                    this.lowerUnsafeMemoryStoreNode((UnsafeMemoryStoreNode)n);
                    break block51;
                }
                if (n instanceof JavaReadNode) {
                    this.lowerJavaReadNode((JavaReadNode)n);
                    break block51;
                }
                if (n instanceof JavaWriteNode) {
                    this.lowerJavaWriteNode((JavaWriteNode)n);
                    break block51;
                }
                if (n instanceof CommitAllocationNode) {
                    this.lowerCommitAllocationNode((CommitAllocationNode)n, tool);
                    break block51;
                }
                if (n instanceof BoxNode) {
                    if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.MID_TIER) {
                        this.boxingSnippets.lower((BoxNode)n, tool);
                    }
                    break block51;
                }
                if (n instanceof UnboxNode) {
                    if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.MID_TIER) {
                        this.boxingSnippets.lower((UnboxNode)n, tool);
                    }
                    break block51;
                }
                if (n instanceof VerifyHeapNode) {
                    this.lowerVerifyHeap((VerifyHeapNode)n);
                    break block51;
                }
                if (n instanceof UnaryMathIntrinsicNode) {
                    this.lowerUnaryMath((UnaryMathIntrinsicNode)n, tool);
                    break block51;
                }
                if (n instanceof BinaryMathIntrinsicNode) {
                    this.lowerBinaryMath((BinaryMathIntrinsicNode)n, tool);
                    break block51;
                }
                if (n instanceof StringIndexOfNode) {
                    this.lowerIndexOf((StringIndexOfNode)n);
                    break block51;
                }
                if (n instanceof StringLatin1IndexOfNode) {
                    this.lowerLatin1IndexOf((StringLatin1IndexOfNode)n);
                    break block51;
                }
                if (n instanceof StringUTF16IndexOfNode) {
                    this.lowerUTF16IndexOf((StringUTF16IndexOfNode)n);
                    break block51;
                }
                if (n instanceof UnpackEndianHalfNode) {
                    this.lowerSecondHalf((UnpackEndianHalfNode)n);
                    break block51;
                }
                if (n instanceof VolatileReadNode) break block51;
                if (n instanceof VolatileWriteNode) {
                    break block51;
                }
                if (n instanceof RegisterFinalizerNode) {
                    return;
                }
                if (n instanceof IdentityHashCodeNode) {
                    this.identityHashCodeSnippets.lower((IdentityHashCodeNode)n, tool);
                    break block51;
                }
                if (n instanceof ObjectIsArrayNode || n instanceof ClassIsArrayNode) {
                    this.isArraySnippets.lower((LogicNode)n, tool);
                    break block51;
                }
                throw GraalError.shouldNotReachHere("Node implementing Lowerable not handled: " + n);
            }
        }
    }

    private void lowerSecondHalf(UnpackEndianHalfNode n) {
        ByteOrder byteOrder = this.target.arch.getByteOrder();
        n.lower(byteOrder);
    }

    private void lowerIndexOf(StringIndexOfNode n) {
        if (n.getArgument(3).isConstant()) {
            SnippetLowerableMemoryNode.SnippetLowering lowering = new SnippetLowerableMemoryNode.SnippetLowering(){

                @Override
                public void lower(SnippetLowerableMemoryNode node, LoweringTool tool) {
                    if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                        return;
                    }
                    DefaultJavaLoweringProvider.this.indexOfSnippets.lower(node, tool);
                }
            };
            SnippetLowerableMemoryNode snippetLower = new SnippetLowerableMemoryNode(lowering, NamedLocationIdentity.getArrayLocation(JavaKind.Char), n.stamp(NodeView.DEFAULT), n.toArgumentArray());
            n.graph().add(snippetLower);
            n.graph().replaceFixedWithFixed(n, snippetLower);
        }
    }

    private void lowerLatin1IndexOf(StringLatin1IndexOfNode n) {
        if (n.getArgument(2).isConstant()) {
            SnippetLowerableMemoryNode.SnippetLowering lowering = new SnippetLowerableMemoryNode.SnippetLowering(){

                @Override
                public void lower(SnippetLowerableMemoryNode node, LoweringTool tool) {
                    if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                        return;
                    }
                    DefaultJavaLoweringProvider.this.indexOfSnippets.lowerLatin1(node, tool);
                }
            };
            SnippetLowerableMemoryNode snippetLower = new SnippetLowerableMemoryNode(lowering, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), n.stamp(NodeView.DEFAULT), n.toArgumentArray());
            n.graph().add(snippetLower);
            n.graph().replaceFixedWithFixed(n, snippetLower);
        }
    }

    private void lowerUTF16IndexOf(StringUTF16IndexOfNode n) {
        if (n.getArgument(2).isConstant()) {
            SnippetLowerableMemoryNode.SnippetLowering lowering = new SnippetLowerableMemoryNode.SnippetLowering(){

                @Override
                public void lower(SnippetLowerableMemoryNode node, LoweringTool tool) {
                    if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                        return;
                    }
                    DefaultJavaLoweringProvider.this.indexOfSnippets.lowerUTF16(node, tool);
                }
            };
            SnippetLowerableMemoryNode snippetLower = new SnippetLowerableMemoryNode(lowering, NamedLocationIdentity.getArrayLocation(JavaKind.Byte), n.stamp(NodeView.DEFAULT), n.toArgumentArray());
            n.graph().add(snippetLower);
            n.graph().replaceFixedWithFixed(n, snippetLower);
        }
    }

    private void lowerBinaryMath(BinaryMathIntrinsicNode math, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        ResolvedJavaMethod method = math.graph().method();
        if (method != null) {
            if (this.replacements.isSnippet(method)) {
                return;
            }
            if (method.getName().equalsIgnoreCase(math.getOperation().name()) && tool.getMetaAccess().lookupJavaType(Math.class).equals(method.getDeclaringClass())) {
                return;
            }
        }
        StructuredGraph graph = math.graph();
        ForeignCallNode call = graph.add(new ForeignCallNode(this.foreignCalls, math.getOperation().foreignCallSignature, math.getX(), math.getY()));
        graph.addAfterFixed(tool.lastFixedNode(), call);
        math.replaceAtUsages(call);
    }

    private void lowerUnaryMath(UnaryMathIntrinsicNode math, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        ResolvedJavaMethod method = math.graph().method();
        if (method != null && method.getName().equalsIgnoreCase(math.getOperation().name()) && tool.getMetaAccess().lookupJavaType(Math.class).equals(method.getDeclaringClass())) {
            return;
        }
        StructuredGraph graph = math.graph();
        ForeignCallNode call = math.graph().add(new ForeignCallNode(this.foreignCalls.getDescriptor(math.getOperation().foreignCallSignature), math.getValue()));
        graph.addAfterFixed(tool.lastFixedNode(), call);
        math.replaceAtUsages(call);
    }

    protected void lowerVerifyHeap(VerifyHeapNode n) {
        GraphUtil.removeFixedWithUnusedInputs(n);
    }

    public AddressNode createOffsetAddress(StructuredGraph graph, ValueNode object, long offset) {
        ConstantNode o = ConstantNode.forIntegerKind(this.target.wordJavaKind, offset, graph);
        return graph.unique(new OffsetAddressNode(object, o));
    }

    public AddressNode createFieldAddress(StructuredGraph graph, ValueNode object, ResolvedJavaField field) {
        int offset = this.fieldOffset(field);
        if (offset >= 0) {
            return this.createOffsetAddress(graph, object, offset);
        }
        return null;
    }

    public final JavaKind getStorageKind(ResolvedJavaField field) {
        return this.getStorageKind(field.getType());
    }

    public final JavaKind getStorageKind(JavaType type) {
        return this.metaAccessExtensionProvider.getStorageKind(type);
    }

    protected void lowerLoadFieldNode(LoadFieldNode loadField, LoweringTool tool) {
        assert (loadField.getStackKind() != JavaKind.Illegal);
        StructuredGraph graph = loadField.graph();
        ResolvedJavaField field = loadField.field();
        ValueNode object = loadField.isStatic() ? this.staticFieldBase(graph, field) : loadField.object();
        object = this.createNullCheckedValue(object, loadField, tool);
        Stamp loadStamp = this.loadStamp(loadField.stamp(NodeView.DEFAULT), this.getStorageKind(field));
        AddressNode address = this.createFieldAddress(graph, object, field);
        assert (address != null) : "Field that is loaded must not be eliminated: " + field.getDeclaringClass().toJavaName(true) + "." + field.getName();
        ReadNode memoryRead = null;
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.fieldLoadBarrierType(field, this.getStorageKind(field));
        memoryRead = loadField.isVolatile() ? (ReadNode)graph.add(new VolatileReadNode(address, loadStamp, barrierType)) : graph.add(new ReadNode(address, this.fieldLocationIdentity(field), loadStamp, barrierType));
        ValueNode readValue = this.implicitLoadConvert(graph, this.getStorageKind(field), memoryRead);
        loadField.replaceAtUsages(readValue);
        graph.replaceFixed(loadField, memoryRead);
    }

    protected void lowerStoreFieldNode(StoreFieldNode storeField, LoweringTool tool) {
        StructuredGraph graph = storeField.graph();
        ResolvedJavaField field = storeField.field();
        ValueNode object = storeField.isStatic() ? this.staticFieldBase(graph, field) : storeField.object();
        object = this.createNullCheckedValue(object, storeField, tool);
        ValueNode value = this.implicitStoreConvert(graph, this.getStorageKind(storeField.field()), storeField.value());
        AddressNode address = this.createFieldAddress(graph, object, field);
        assert (address != null);
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.fieldStoreBarrierType(field, this.getStorageKind(field));
        WriteNode memoryWrite = null;
        memoryWrite = storeField.isVolatile() ? (WriteNode)graph.add(new VolatileWriteNode(address, this.fieldLocationIdentity(field), value, barrierType)) : graph.add(new WriteNode(address, this.fieldLocationIdentity(field), value, barrierType));
        memoryWrite.setStateAfter(storeField.stateAfter());
        graph.replaceFixedWithFixed(storeField, memoryWrite);
    }

    protected ValueNode createPositiveIndex(StructuredGraph graph, ValueNode index, GuardingNode boundsCheck) {
        return graph.maybeAddOrUnique(PiNode.create(index, POSITIVE_ARRAY_INDEX_STAMP, boundsCheck != null ? boundsCheck.asNode() : null));
    }

    public AddressNode createArrayIndexAddress(StructuredGraph graph, ValueNode array, JavaKind elementKind, ValueNode index, GuardingNode boundsCheck) {
        return this.createArrayAddress(graph, array, elementKind, this.createPositiveIndex(graph, index, boundsCheck));
    }

    public AddressNode createArrayAddress(StructuredGraph graph, ValueNode array, JavaKind elementKind, ValueNode index) {
        return this.createArrayAddress(graph, array, elementKind, elementKind, index);
    }

    public AddressNode createArrayAddress(StructuredGraph graph, ValueNode array, JavaKind arrayKind, JavaKind elementKind, ValueNode index) {
        int base = this.metaAccess.getArrayBaseOffset(arrayKind);
        return this.createArrayAddress(graph, array, base, elementKind, index);
    }

    public AddressNode createArrayAddress(StructuredGraph graph, ValueNode array, int arrayBaseOffset, JavaKind elementKind, ValueNode index) {
        ValueNode wordIndex;
        if (this.target.wordSize > 4) {
            wordIndex = graph.unique(new SignExtendNode(index, this.target.wordSize * 8));
        } else {
            assert (this.target.wordSize == 4) : "unsupported word size";
            wordIndex = index;
        }
        int shift = CodeUtil.log2((int)this.metaAccess.getArrayIndexScale(elementKind));
        ValueNode scaledIndex = graph.unique(new LeftShiftNode(wordIndex, ConstantNode.forInt(shift, graph)));
        ValueNode offset = graph.unique(new AddNode(scaledIndex, ConstantNode.forIntegerKind(this.target.wordJavaKind, arrayBaseOffset, graph)));
        return graph.unique(new OffsetAddressNode(array, offset));
    }

    protected void lowerIndexAddressNode(IndexAddressNode indexAddress) {
        AddressNode lowered = this.createArrayAddress(indexAddress.graph(), indexAddress.getArray(), indexAddress.getArrayKind(), indexAddress.getElementKind(), indexAddress.getIndex());
        indexAddress.replaceAndDelete(lowered);
    }

    public void lowerLoadIndexedNode(LoadIndexedNode loadIndexed, LoweringTool tool) {
        int arrayBaseOffset = this.metaAccess.getArrayBaseOffset(loadIndexed.elementKind());
        this.lowerLoadIndexedNode(loadIndexed, tool, arrayBaseOffset);
    }

    public void lowerLoadIndexedNode(LoadIndexedNode loadIndexed, LoweringTool tool, int arrayBaseOffset) {
        StructuredGraph graph = loadIndexed.graph();
        ValueNode array = loadIndexed.array();
        array = this.createNullCheckedValue(array, loadIndexed, tool);
        JavaKind elementKind = loadIndexed.elementKind();
        Stamp loadStamp = this.loadStamp(loadIndexed.stamp(NodeView.DEFAULT), elementKind);
        GuardingNode boundsCheck = this.getBoundsCheck(loadIndexed, array, tool);
        ValueNode index = loadIndexed.index();
        if (SpectrePHTMitigations.Options.SpectrePHTIndexMasking.getValue(graph.getOptions()).booleanValue()) {
            index = graph.addOrUniqueWithInputs(this.proxyIndex(loadIndexed, index, array, tool));
        }
        ValueNode positiveIndex = this.createPositiveIndex(graph, index, boundsCheck);
        AddressNode address = this.createArrayAddress(graph, array, arrayBaseOffset, elementKind, positiveIndex);
        ReadNode memoryRead = graph.add(new ReadNode(address, NamedLocationIdentity.getArrayLocation(elementKind), loadStamp, OnHeapMemoryAccess.BarrierType.NONE));
        memoryRead.setGuard(boundsCheck);
        ValueNode readValue = this.implicitLoadConvert(graph, elementKind, memoryRead);
        loadIndexed.replaceAtUsages(readValue);
        graph.replaceFixed(loadIndexed, memoryRead);
    }

    public void lowerStoreIndexedNode(StoreIndexedNode storeIndexed, LoweringTool tool) {
        int arrayBaseOffset = this.metaAccess.getArrayBaseOffset(storeIndexed.elementKind());
        this.lowerStoreIndexedNode(storeIndexed, tool, arrayBaseOffset);
    }

    public void lowerStoreIndexedNode(StoreIndexedNode storeIndexed, LoweringTool tool, int arrayBaseOffset) {
        StructuredGraph graph = storeIndexed.graph();
        ValueNode value = storeIndexed.value();
        ValueNode array = storeIndexed.array();
        array = this.createNullCheckedValue(array, storeIndexed, tool);
        GuardingNode boundsCheck = this.getBoundsCheck(storeIndexed, array, tool);
        JavaKind storageKind = storeIndexed.elementKind();
        LogicNode condition = null;
        if (storeIndexed.getStoreCheck() == null && storageKind == JavaKind.Object && !StampTool.isPointerAlwaysNull(value)) {
            LogicNode typeTest;
            TypeReference arrayType = StampTool.typeReferenceOrNull(array);
            if (arrayType != null && arrayType.isExact()) {
                ResolvedJavaType elementType = arrayType.getType().getComponentType();
                if (!elementType.isJavaLangObject()) {
                    TypeReference typeReference = TypeReference.createTrusted(storeIndexed.graph().getAssumptions(), elementType);
                    typeTest = graph.addOrUniqueWithInputs(InstanceOfNode.create(typeReference, value));
                    condition = LogicNode.or(graph.unique(IsNullNode.create(value)), typeTest, BranchProbabilityNode.NOT_LIKELY_PROFILE);
                }
            } else {
                ValueNode arrayClass = this.createReadHub(graph, array, tool);
                ValueNode componentHub = this.createReadArrayComponentHub(graph, arrayClass, storeIndexed);
                typeTest = graph.unique(InstanceOfDynamicNode.create(graph.getAssumptions(), tool.getConstantReflection(), componentHub, value, false));
                condition = LogicNode.or(graph.unique(IsNullNode.create(value)), typeTest, BranchProbabilityNode.NOT_LIKELY_PROFILE);
            }
        }
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.arrayStoreBarrierType(storageKind);
        ValueNode positiveIndex = this.createPositiveIndex(graph, storeIndexed.index(), boundsCheck);
        AddressNode address = this.createArrayAddress(graph, array, arrayBaseOffset, storageKind, positiveIndex);
        WriteNode memoryWrite = graph.add(new WriteNode(address, NamedLocationIdentity.getArrayLocation(storageKind), this.implicitStoreConvert(graph, storageKind, value), barrierType));
        memoryWrite.setGuard(boundsCheck);
        if (condition != null) {
            tool.createGuard(storeIndexed, condition, DeoptimizationReason.ArrayStoreException, DeoptimizationAction.InvalidateReprofile);
        }
        memoryWrite.setStateAfter(storeIndexed.stateAfter());
        graph.replaceFixedWithFixed(storeIndexed, memoryWrite);
    }

    protected void lowerArrayLengthNode(ArrayLengthNode arrayLengthNode, LoweringTool tool) {
        arrayLengthNode.replaceAtUsages(this.createReadArrayLength(arrayLengthNode.array(), arrayLengthNode, tool));
        StructuredGraph graph = arrayLengthNode.graph();
        graph.removeFixed(arrayLengthNode);
    }

    protected ReadNode createReadArrayLength(ValueNode array, FixedNode before, LoweringTool tool) {
        StructuredGraph graph = array.graph();
        ValueNode canonicalArray = this.createNullCheckedValue(GraphUtil.skipPiWhileNonNullArray(array), before, tool);
        AddressNode address = this.createOffsetAddress(graph, canonicalArray, this.arrayLengthOffset());
        ReadNode readArrayLength = graph.add(new ReadNode(address, NamedLocationIdentity.ARRAY_LENGTH_LOCATION, StampFactory.positiveInt(), OnHeapMemoryAccess.BarrierType.NONE));
        graph.addBeforeFixed(before, readArrayLength);
        return readArrayLength;
    }

    protected void lowerLoadHubNode(LoadHubNode loadHub, LoweringTool tool) {
        StructuredGraph graph = loadHub.graph();
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            return;
        }
        ValueNode hub = this.createReadHub(graph, loadHub.getValue(), tool);
        loadHub.replaceAtUsagesAndDelete(hub);
    }

    protected void lowerLoadHubOrNullNode(LoadHubOrNullNode loadHubOrNullNode, LoweringTool tool) {
        StructuredGraph graph = loadHubOrNullNode.graph();
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            return;
        }
        FixedWithNextNode predecessor = tool.lastFixedNode();
        ValueNode value = loadHubOrNullNode.getValue();
        AbstractPointerStamp stamp = (AbstractPointerStamp)value.stamp(NodeView.DEFAULT);
        LogicNode isNull = graph.addOrUniqueWithInputs(IsNullNode.create(value));
        EndNode trueEnd = graph.add(new EndNode());
        EndNode falseEnd = graph.add(new EndNode());
        IfNode ifNode = graph.add(new IfNode(isNull, trueEnd, falseEnd, ProfileData.BranchProbabilityData.unknown()));
        MergeNode merge = graph.add(new MergeNode());
        merge.addForwardEnd(trueEnd);
        merge.addForwardEnd(falseEnd);
        AbstractPointerStamp hubStamp = (AbstractPointerStamp)loadHubOrNullNode.stamp(NodeView.DEFAULT);
        ConstantNode nullHub = ConstantNode.forConstant(hubStamp.asAlwaysNull(), (Constant)JavaConstant.NULL_POINTER, tool.getMetaAccess(), graph);
        ValueNode nonNullValue = graph.addOrUniqueWithInputs(PiNode.create(value, stamp.asNonNull(), ifNode.falseSuccessor()));
        ValueNode hub = this.createReadHub(graph, nonNullValue, tool);
        ValueNode[] values = new ValueNode[]{nullHub, hub};
        PhiNode hubPhi = graph.unique(new ValuePhiNode(hubStamp, merge, values));
        FixedNode oldNext = predecessor.next();
        predecessor.setNext(ifNode);
        merge.setNext(oldNext);
        loadHubOrNullNode.replaceAtUsagesAndDelete(hubPhi);
    }

    protected void lowerLoadArrayComponentHubNode(LoadArrayComponentHubNode loadHub) {
        StructuredGraph graph = loadHub.graph();
        ValueNode hub = this.createReadArrayComponentHub(graph, loadHub.getValue(), loadHub);
        graph.replaceFixed(loadHub, hub);
    }

    protected void lowerCompareAndSwapNode(UnsafeCompareAndSwapNode cas) {
        StructuredGraph graph = cas.graph();
        JavaKind valueKind = cas.getValueKind();
        ValueNode expectedValue = this.implicitStoreConvert(graph, valueKind, cas.expected());
        ValueNode newValue = this.implicitStoreConvert(graph, valueKind, cas.newValue());
        AddressNode address = graph.unique(new OffsetAddressNode(cas.object(), cas.offset()));
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.guessStoreBarrierType(cas.object(), newValue);
        LogicCompareAndSwapNode atomicNode = graph.add(new LogicCompareAndSwapNode(address, expectedValue, newValue, cas.getKilledLocationIdentity(), barrierType, cas.getMemoryOrder()));
        atomicNode.setStateAfter(cas.stateAfter());
        graph.replaceFixedWithFixed(cas, atomicNode);
    }

    protected void lowerCompareAndExchangeNode(UnsafeCompareAndExchangeNode cas) {
        StructuredGraph graph = cas.graph();
        JavaKind valueKind = cas.getValueKind();
        ValueNode expectedValue = this.implicitStoreConvert(graph, valueKind, cas.expected());
        ValueNode newValue = this.implicitStoreConvert(graph, valueKind, cas.newValue());
        AddressNode address = graph.unique(new OffsetAddressNode(cas.object(), cas.offset()));
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.guessStoreBarrierType(cas.object(), newValue);
        ValueCompareAndSwapNode atomicNode = graph.add(new ValueCompareAndSwapNode(address, expectedValue, newValue, cas.getKilledLocationIdentity(), barrierType, cas.getMemoryOrder()));
        ValueNode coercedNode = this.implicitLoadConvert(graph, valueKind, atomicNode, true);
        atomicNode.setStateAfter(cas.stateAfter());
        cas.replaceAtUsages(coercedNode);
        graph.replaceFixedWithFixed(cas, atomicNode);
    }

    protected void lowerAtomicReadAndWriteNode(AtomicReadAndWriteNode n) {
        StructuredGraph graph = n.graph();
        JavaKind valueKind = n.getValueKind();
        ValueNode newValue = this.implicitStoreConvert(graph, valueKind, n.newValue());
        AddressNode address = graph.unique(new OffsetAddressNode(n.object(), n.offset()));
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.guessStoreBarrierType(n.object(), newValue);
        LIRKind lirAccessKind = LIRKind.fromJavaKind(this.target.arch, valueKind);
        LoweredAtomicReadAndWriteNode memoryRead = graph.add(new LoweredAtomicReadAndWriteNode(address, n.getKilledLocationIdentity(), newValue, lirAccessKind, barrierType));
        memoryRead.setStateAfter(n.stateAfter());
        ValueNode readValue = this.implicitLoadConvert(graph, valueKind, memoryRead);
        n.stateAfter().replaceFirstInput(n, memoryRead);
        n.replaceAtUsages(readValue);
        graph.replaceFixedWithFixed(n, memoryRead);
    }

    protected void lowerAtomicReadAndAddNode(AtomicReadAndAddNode n) {
        StructuredGraph graph = n.graph();
        JavaKind valueKind = n.getValueKind();
        ValueNode delta = this.implicitStoreConvert(graph, valueKind, n.delta());
        AddressNode address = graph.unique(new OffsetAddressNode(n.object(), n.offset()));
        OnHeapMemoryAccess.BarrierType barrierType = this.barrierSet.guessStoreBarrierType(n.object(), delta);
        LIRKind lirAccessKind = LIRKind.fromJavaKind(this.target.arch, valueKind);
        LoweredAtomicReadAndAddNode memoryRead = graph.add(new LoweredAtomicReadAndAddNode(address, n.getKilledLocationIdentity(), delta, lirAccessKind, barrierType));
        memoryRead.setStateAfter(n.stateAfter());
        ValueNode readValue = this.implicitLoadConvert(graph, valueKind, memoryRead);
        n.stateAfter().replaceFirstInput(n, memoryRead);
        n.replaceAtUsages(readValue);
        graph.replaceFixedWithFixed(n, memoryRead);
    }

    protected void lowerUnsafeLoadNode(RawLoadNode load, LoweringTool tool) {
        StructuredGraph graph = load.graph();
        if (load instanceof GuardedUnsafeLoadNode) {
            GuardedUnsafeLoadNode guardedLoad = (GuardedUnsafeLoadNode)load;
            GuardingNode guard = guardedLoad.getGuard();
            if (guard == null) {
                ReadNode memoryRead = this.createUnsafeRead(graph, load, null);
                memoryRead.setForceFixed(false);
                graph.replaceFixedWithFixed(load, memoryRead);
            } else {
                ReadNode memoryRead = this.createUnsafeRead(graph, load, guard);
                graph.replaceFixedWithFixed(load, memoryRead);
            }
        } else {
            ReadNode memoryRead = this.createUnsafeRead(graph, load, null);
            graph.replaceFixedWithFixed(load, memoryRead);
        }
    }

    protected AddressNode createUnsafeAddress(StructuredGraph graph, ValueNode object, ValueNode offset) {
        if (object.isConstant() && object.asConstant().isDefaultForKind()) {
            return graph.addOrUniqueWithInputs(OffsetAddressNode.create(offset));
        }
        return graph.unique(new OffsetAddressNode(object, offset));
    }

    protected ReadNode createUnsafeRead(StructuredGraph graph, RawLoadNode load, GuardingNode guard) {
        boolean compressible = load.accessKind() == JavaKind.Object;
        JavaKind readKind = load.accessKind();
        Stamp loadStamp = this.loadStamp(load.stamp(NodeView.DEFAULT), readKind, compressible);
        AddressNode address = this.createUnsafeAddress(graph, load.object(), load.offset());
        ReadNode memoryRead = null;
        memoryRead = load.isVolatile() ? new VolatileReadNode(address, loadStamp, this.barrierSet.readBarrierType(load)) : new ReadNode(address, load.getLocationIdentity(), loadStamp, this.barrierSet.readBarrierType(load));
        memoryRead = graph.add(memoryRead);
        if (guard == null) {
            memoryRead.setForceFixed(true);
        } else {
            memoryRead.setGuard(guard);
        }
        ValueNode readValue = DefaultJavaLoweringProvider.performBooleanCoercionIfNecessary(this.implicitLoadConvert(graph, readKind, memoryRead, compressible), readKind);
        load.replaceAtUsages(readValue);
        return memoryRead;
    }

    protected void lowerUnsafeMemoryLoadNode(UnsafeMemoryLoadNode load) {
        StructuredGraph graph = load.graph();
        JavaKind readKind = load.getKind();
        assert (readKind != JavaKind.Object);
        Stamp loadStamp = this.loadStamp(load.stamp(NodeView.DEFAULT), readKind, false);
        AddressNode address = graph.addOrUniqueWithInputs(OffsetAddressNode.create(load.getAddress()));
        ReadNode memoryRead = graph.add(new ReadNode(address, load.getLocationIdentity(), loadStamp, OnHeapMemoryAccess.BarrierType.NONE));
        memoryRead.setForceFixed(true);
        ValueNode readValue = DefaultJavaLoweringProvider.performBooleanCoercionIfNecessary(this.implicitLoadConvert(graph, readKind, memoryRead, false), readKind);
        load.replaceAtUsages(readValue);
        graph.replaceFixedWithFixed(load, memoryRead);
    }

    private static ValueNode performBooleanCoercionIfNecessary(ValueNode readValue, JavaKind readKind) {
        if (readKind == JavaKind.Boolean) {
            StructuredGraph graph = readValue.graph();
            IntegerEqualsNode eq = graph.addOrUnique(new IntegerEqualsNode(readValue, ConstantNode.forInt(0, graph)));
            return graph.addOrUnique(new ConditionalNode(eq, ConstantNode.forBoolean(false, graph), ConstantNode.forBoolean(true, graph)));
        }
        return readValue;
    }

    protected void lowerUnsafeStoreNode(RawStoreNode store) {
        StructuredGraph graph = store.graph();
        boolean compressible = store.value().getStackKind() == JavaKind.Object;
        JavaKind valueKind = store.accessKind();
        ValueNode value = this.implicitStoreConvert(graph, valueKind, store.value(), compressible);
        AddressNode address = this.createUnsafeAddress(graph, store.object(), store.offset());
        WriteNode write = null;
        write = store.isVolatile() ? new VolatileWriteNode(address, store.getLocationIdentity(), value, this.barrierSet.storeBarrierType(store)) : new WriteNode(address, store.getLocationIdentity(), value, this.barrierSet.storeBarrierType(store));
        write = graph.add(write);
        write.setStateAfter(store.stateAfter());
        graph.replaceFixedWithFixed(store, write);
    }

    protected void lowerUnsafeMemoryStoreNode(UnsafeMemoryStoreNode store) {
        StructuredGraph graph = store.graph();
        assert (store.getValue().getStackKind() != JavaKind.Object);
        JavaKind valueKind = store.getKind();
        ValueNode value = this.implicitStoreConvert(graph, valueKind, store.getValue(), false);
        AddressNode address = graph.addOrUniqueWithInputs(OffsetAddressNode.create(store.getAddress()));
        WriteNode write = graph.add(new WriteNode(address, store.getKilledLocationIdentity(), value, OnHeapMemoryAccess.BarrierType.NONE));
        write.setStateAfter(store.stateAfter());
        graph.replaceFixedWithFixed(store, write);
    }

    protected void lowerJavaReadNode(JavaReadNode read) {
        StructuredGraph graph = read.graph();
        JavaKind valueKind = read.getReadKind();
        Stamp loadStamp = this.loadStamp(read.stamp(NodeView.DEFAULT), valueKind, read.isCompressible());
        ReadNode memoryRead = graph.add(new ReadNode(read.getAddress(), read.getLocationIdentity(), loadStamp, read.getBarrierType()));
        GuardingNode guard = read.getGuard();
        ValueNode readValue = this.implicitLoadConvert(graph, valueKind, memoryRead, read.isCompressible());
        if (guard == null) {
            memoryRead.setForceFixed(true);
        } else {
            memoryRead.setGuard(guard);
        }
        read.replaceAtUsages(readValue);
        graph.replaceFixed(read, memoryRead);
    }

    protected void lowerJavaWriteNode(JavaWriteNode write) {
        StructuredGraph graph = write.graph();
        ValueNode value = this.implicitStoreConvert(graph, write.getWriteKind(), write.value(), write.isCompressible());
        WriteNode memoryWrite = null;
        memoryWrite = write.hasSideEffect() ? graph.add(new WriteNode(write.getAddress(), write.getKilledLocationIdentity(), value, write.getBarrierType())) : (WriteNode)graph.add(new SideEffectFreeWrite(write.getAddress(), write.getKilledLocationIdentity(), value, write.getBarrierType()));
        memoryWrite.setStateAfter(write.stateAfter());
        graph.replaceFixedWithFixed(write, memoryWrite);
        memoryWrite.setGuard(write.getGuard());
    }

    protected void lowerCommitAllocationNode(CommitAllocationNode commit, LoweringTool tool) {
        StructuredGraph graph = commit.graph();
        if (graph.getGuardsStage() == StructuredGraph.GuardsStage.FIXED_DEOPTS) {
            ResolvedJavaField field;
            ValueNode value;
            int i;
            ValueNode newObject;
            Throwable throwable;
            DebugCloseable nsp;
            int objIndex;
            ArrayList<ValueNode> recursiveLowerings = new ArrayList<ValueNode>();
            ValueNode[] allocations = new ValueNode[commit.getVirtualObjects().size()];
            BitSet omittedValues = new BitSet();
            int valuePos = 0;
            for (objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
                VirtualObjectNode virtualObjectNode = commit.getVirtualObjects().get(objIndex);
                nsp = graph.withNodeSourcePosition(virtualObjectNode);
                throwable = null;
                try {
                    int entryCount = virtualObjectNode.entryCount();
                    if (virtualObjectNode instanceof VirtualInstanceNode) {
                        newObject = graph.add(new NewInstanceNode(virtualObjectNode.type(), true));
                    } else {
                        assert (virtualObjectNode instanceof VirtualArrayNode);
                        newObject = graph.add(new NewArrayNode(((VirtualArrayNode)virtualObjectNode).componentType(), ConstantNode.forInt(entryCount, graph), true));
                    }
                    ((AbstractNewObjectNode)newObject).clearEmitMemoryBarrier();
                    recursiveLowerings.add(newObject);
                    graph.addBeforeFixed(commit, (FixedWithNextNode)newObject);
                    allocations[objIndex] = newObject;
                    for (i = 0; i < entryCount; ++i) {
                        value = commit.getValues().get(valuePos);
                        if (value instanceof VirtualObjectNode) {
                            value = allocations[commit.getVirtualObjects().indexOf(value)];
                        }
                        if (value == null) {
                            omittedValues.set(valuePos);
                        } else if (!value.isConstant() || !value.asConstant().isDefaultForKind()) {
                            JavaKind valueKind = value.getStackKind();
                            JavaKind storageKind = virtualObjectNode.entryKind(tool.getProviders().getMetaAccessExtensionProvider(), i);
                            assert (valueKind.getStackKind() == storageKind.getStackKind() || valueKind == JavaKind.Long || valueKind == JavaKind.Double || valueKind == JavaKind.Int && virtualObjectNode instanceof VirtualArrayNode || valueKind == JavaKind.Float && virtualObjectNode instanceof VirtualArrayNode);
                            AddressNode address = null;
                            OnHeapMemoryAccess.BarrierType barrierType = null;
                            if (virtualObjectNode instanceof VirtualInstanceNode) {
                                field = ((VirtualInstanceNode)virtualObjectNode).field(i);
                                long offset = this.fieldOffset(field);
                                if (offset >= 0L) {
                                    address = this.createOffsetAddress(graph, newObject, offset);
                                    barrierType = this.barrierSet.fieldStoreBarrierType(field, this.getStorageKind(field));
                                }
                            } else {
                                assert (virtualObjectNode instanceof VirtualArrayNode);
                                address = this.createOffsetAddress(graph, newObject, this.metaAccess.getArrayBaseOffset(storageKind) + i * this.metaAccess.getArrayIndexScale(storageKind));
                                barrierType = this.barrierSet.arrayStoreBarrierType(storageKind);
                            }
                            if (address != null) {
                                WriteNode write = new WriteNode(address, LocationIdentity.init(), this.arrayImplicitStoreConvert(graph, storageKind, value, commit, virtualObjectNode, valuePos), barrierType);
                                graph.addAfterFixed((FixedWithNextNode)newObject, graph.add(write));
                            }
                        }
                        ++valuePos;
                    }
                    continue;
                }
                catch (Throwable entryCount) {
                    throwable = entryCount;
                    throw entryCount;
                }
                finally {
                    if (nsp != null) {
                        if (throwable != null) {
                            try {
                                nsp.close();
                            }
                            catch (Throwable entryCount) {
                                throwable.addSuppressed(entryCount);
                            }
                        } else {
                            nsp.close();
                        }
                    }
                }
            }
            valuePos = 0;
            for (objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
                VirtualObjectNode virtualObjectNode = commit.getVirtualObjects().get(objIndex);
                nsp = graph.withNodeSourcePosition(virtualObjectNode);
                throwable = null;
                try {
                    int entryCount = virtualObjectNode.entryCount();
                    newObject = allocations[objIndex];
                    for (i = 0; i < entryCount; ++i) {
                        if (omittedValues.get(valuePos)) {
                            value = commit.getValues().get(valuePos);
                            assert (value instanceof VirtualObjectNode);
                            ValueNode allocValue = allocations[commit.getVirtualObjects().indexOf(value)];
                            if (!allocValue.isConstant() || !allocValue.asConstant().isDefaultForKind()) {
                                OnHeapMemoryAccess.BarrierType barrierType;
                                AddressNode address;
                                assert (virtualObjectNode.entryKind(this.metaAccessExtensionProvider, i) == JavaKind.Object && allocValue.getStackKind() == JavaKind.Object);
                                if (virtualObjectNode instanceof VirtualInstanceNode) {
                                    VirtualInstanceNode virtualInstance = (VirtualInstanceNode)virtualObjectNode;
                                    field = virtualInstance.field(i);
                                    address = this.createFieldAddress(graph, newObject, field);
                                    barrierType = this.barrierSet.fieldStoreBarrierType(field, this.getStorageKind(field));
                                } else {
                                    assert (virtualObjectNode instanceof VirtualArrayNode);
                                    address = this.createArrayAddress(graph, newObject, virtualObjectNode.entryKind(this.metaAccessExtensionProvider, i), ConstantNode.forInt(i, graph));
                                    barrierType = this.barrierSet.arrayStoreBarrierType(virtualObjectNode.entryKind(this.metaAccessExtensionProvider, i));
                                }
                                if (address != null) {
                                    WriteNode write = new WriteNode(address, LocationIdentity.init(), this.implicitStoreConvert(graph, JavaKind.Object, allocValue), barrierType);
                                    graph.addBeforeFixed(commit, graph.add(write));
                                }
                            }
                        }
                        ++valuePos;
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nsp != null) {
                        if (throwable != null) {
                            try {
                                nsp.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            nsp.close();
                        }
                    }
                }
            }
            this.finishAllocatedObjects(tool, commit, commit, allocations);
            graph.removeFixed(commit);
            for (AbstractNewObjectNode abstractNewObjectNode : recursiveLowerings) {
                abstractNewObjectNode.lower(tool);
            }
        }
    }

    public void finishAllocatedObjects(LoweringTool tool, FixedWithNextNode insertAfter, CommitAllocationNode commit, ValueNode[] allocations) {
        FixedWithNextNode insertionPoint = insertAfter;
        StructuredGraph graph = commit.graph();
        for (int objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
            FixedValueAnchorNode anchor = graph.add(new FixedValueAnchorNode(allocations[objIndex]));
            allocations[objIndex] = anchor;
            graph.addAfterFixed(insertionPoint, anchor);
            insertionPoint = anchor;
        }
        ArrayList<MonitorEnterNode> enters = null;
        FrameState stateBefore = SnippetTemplate.findLastFrameState(insertionPoint);
        for (int objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
            List<MonitorIdNode> locks = commit.getLocks(objIndex);
            if (locks.size() > 1) {
                ArrayList<MonitorIdNode> newList = new ArrayList<MonitorIdNode>(locks);
                newList.sort((a, b) -> Integer.compare(a.getLockDepth(), b.getLockDepth()));
                locks = newList;
            }
            int lastDepth = -1;
            for (MonitorIdNode monitorId : locks) {
                assert (lastDepth < monitorId.getLockDepth());
                lastDepth = monitorId.getLockDepth();
                MonitorEnterNode enter = graph.add(new MonitorEnterNode(allocations[objIndex], monitorId));
                graph.addAfterFixed(insertionPoint, enter);
                enter.setStateAfter(stateBefore.duplicate());
                insertionPoint = enter;
                if (enters == null) {
                    enters = new ArrayList<MonitorEnterNode>();
                }
                enters.add(enter);
            }
        }
        for (Node usage : commit.usages().snapshot()) {
            if (usage instanceof AllocatedObjectNode) {
                AllocatedObjectNode addObject = (AllocatedObjectNode)usage;
                int index = commit.getVirtualObjects().indexOf(addObject.getVirtualObject());
                addObject.replaceAtUsagesAndDelete(allocations[index]);
                continue;
            }
            assert (enters != null);
            commit.replaceAtUsages((Node)enters.get(enters.size() - 1), InputType.Memory);
        }
        if (enters != null) {
            for (MonitorEnterNode enter : enters) {
                enter.lower(tool);
            }
        }
        assert (commit.hasNoUsages());
        DefaultJavaLoweringProvider.insertAllocationBarrier(insertAfter, commit, graph);
    }

    private static void insertAllocationBarrier(FixedWithNextNode insertAfter, CommitAllocationNode commit, StructuredGraph graph) {
        int barrier = 8;
        block0: for (VirtualObjectNode vobj : commit.getVirtualObjects()) {
            for (ResolvedJavaField field : vobj.type().getInstanceFields(true)) {
                if (!field.isFinal()) continue;
                barrier |= 2;
                break block0;
            }
        }
        graph.addAfterFixed(insertAfter, graph.add(new MembarNode(barrier, LocationIdentity.init())));
    }

    public abstract int fieldOffset(ResolvedJavaField var1);

    public FieldLocationIdentity fieldLocationIdentity(ResolvedJavaField field) {
        return new FieldLocationIdentity(field);
    }

    public abstract ValueNode staticFieldBase(StructuredGraph var1, ResolvedJavaField var2);

    public abstract int arrayLengthOffset();

    public Stamp loadStamp(Stamp stamp, JavaKind kind) {
        return this.loadStamp(stamp, kind, true);
    }

    private boolean useCompressedOops(JavaKind kind, boolean compressible) {
        return kind == JavaKind.Object && compressible && this.useCompressedOops;
    }

    protected abstract Stamp loadCompressedStamp(ObjectStamp var1);

    protected Stamp loadStamp(Stamp stamp, JavaKind kind, boolean compressible) {
        if (this.useCompressedOops(kind, compressible)) {
            return this.loadCompressedStamp((ObjectStamp)stamp);
        }
        switch (kind) {
            case Boolean: 
            case Byte: {
                return IntegerStamp.OPS.getNarrow().foldStamp(32, 8, stamp);
            }
            case Char: 
            case Short: {
                return IntegerStamp.OPS.getNarrow().foldStamp(32, 16, stamp);
            }
        }
        return stamp;
    }

    public final ValueNode implicitLoadConvert(StructuredGraph graph, JavaKind kind, ValueNode value) {
        return this.implicitLoadConvert(graph, kind, value, true);
    }

    public ValueNode implicitLoadConvert(JavaKind kind, ValueNode value) {
        return this.implicitLoadConvert(kind, value, true);
    }

    protected final ValueNode implicitLoadConvert(StructuredGraph graph, JavaKind kind, ValueNode value, boolean compressible) {
        ValueNode ret = this.implicitLoadConvert(kind, value, compressible);
        if (!ret.isAlive()) {
            ret = graph.addOrUnique(ret);
        }
        return ret;
    }

    protected abstract ValueNode newCompressionNode(CompressionNode.CompressionOp var1, ValueNode var2);

    protected ValueNode implicitLoadConvert(JavaKind kind, ValueNode value, boolean compressible) {
        if (this.useCompressedOops(kind, compressible)) {
            return this.newCompressionNode(CompressionNode.CompressionOp.Uncompress, value);
        }
        switch (kind) {
            case Byte: 
            case Short: {
                return new SignExtendNode(value, 32);
            }
            case Boolean: 
            case Char: {
                return new ZeroExtendNode(value, 32);
            }
        }
        return value;
    }

    public ValueNode arrayImplicitStoreConvert(StructuredGraph graph, JavaKind entryKind, ValueNode value, CommitAllocationNode commit, VirtualObjectNode virtual, int valuePos) {
        if (!virtual.isVirtualByteArray(this.metaAccessExtensionProvider)) {
            return this.implicitStoreConvert(graph, entryKind, value);
        }
        int bytes = 1;
        for (int entryIndex = valuePos + 1; entryIndex < commit.getValues().size() && commit.getValues().get(entryIndex).isIllegalConstant(); ++entryIndex) {
            ++bytes;
        }
        assert (bytes <= value.getStackKind().getByteCount());
        ValueNode entry = value;
        if (value.getStackKind() == JavaKind.Float) {
            entry = graph.addOrUnique(ReinterpretNode.create(JavaKind.Int, entry, NodeView.DEFAULT));
        } else if (value.getStackKind() == JavaKind.Double) {
            entry = graph.addOrUnique(ReinterpretNode.create(JavaKind.Long, entry, NodeView.DEFAULT));
        }
        if (bytes < value.getStackKind().getByteCount()) {
            entry = graph.unique(new NarrowNode(entry, bytes << 3));
        }
        return entry;
    }

    public final ValueNode implicitStoreConvert(StructuredGraph graph, JavaKind kind, ValueNode value) {
        return this.implicitStoreConvert(graph, kind, value, true);
    }

    public ValueNode implicitStoreConvert(JavaKind kind, ValueNode value) {
        return this.implicitStoreConvert(kind, value, true);
    }

    protected final ValueNode implicitStoreConvert(StructuredGraph graph, JavaKind kind, ValueNode value, boolean compressible) {
        ValueNode ret = this.implicitStoreConvert(kind, value, compressible);
        if (!ret.isAlive()) {
            ret = graph.addOrUnique(ret);
        }
        return ret;
    }

    protected ValueNode implicitStoreConvert(JavaKind kind, ValueNode value, boolean compressible) {
        if (this.useCompressedOops(kind, compressible)) {
            return this.newCompressionNode(CompressionNode.CompressionOp.Compress, value);
        }
        switch (kind) {
            case Boolean: 
            case Byte: {
                return new NarrowNode(value, 8);
            }
            case Char: 
            case Short: {
                return new NarrowNode(value, 16);
            }
        }
        return value;
    }

    protected abstract ValueNode createReadHub(StructuredGraph var1, ValueNode var2, LoweringTool var3);

    protected abstract ValueNode createReadArrayComponentHub(StructuredGraph var1, ValueNode var2, FixedNode var3);

    protected ValueNode proxyIndex(AccessIndexedNode n, ValueNode index, ValueNode array, LoweringTool tool) {
        StructuredGraph graph = index.graph();
        ValueNode arrayLength = this.readOrCreateArrayLength(n, array, tool, graph);
        ValueNode lengthMinusOne = SubNode.create(arrayLength, ConstantNode.forInt(1), NodeView.DEFAULT);
        return BinaryArithmeticNode.branchlessMax(BinaryArithmeticNode.branchlessMin(index, lengthMinusOne, NodeView.DEFAULT), ConstantNode.forInt(0), NodeView.DEFAULT);
    }

    protected GuardingNode getBoundsCheck(AccessIndexedNode n, ValueNode array, LoweringTool tool) {
        if (n.getBoundsCheck() != null) {
            return n.getBoundsCheck();
        }
        StructuredGraph graph = n.graph();
        ValueNode arrayLength = this.readOrCreateArrayLength(n, array, tool, graph);
        LogicNode boundsCheck = IntegerBelowNode.create(n.index(), arrayLength, NodeView.DEFAULT);
        if (boundsCheck.isTautology()) {
            return null;
        }
        return tool.createGuard(n, graph.addOrUniqueWithInputs(boundsCheck), DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateReprofile);
    }

    private ValueNode readOrCreateArrayLength(AccessIndexedNode n, ValueNode array, LoweringTool tool, StructuredGraph graph) {
        ValueNode arrayLength = ArrayLengthNode.readArrayLength(array, tool.getConstantReflection());
        arrayLength = arrayLength == null ? this.createReadArrayLength(array, n, tool) : (arrayLength.isAlive() ? arrayLength : graph.addOrUniqueWithInputs(arrayLength));
        return arrayLength;
    }

    protected GuardingNode createNullCheck(ValueNode object, FixedNode before, LoweringTool tool) {
        if (StampTool.isPointerNonNull(object)) {
            return null;
        }
        return tool.createGuard(before, before.graph().unique(IsNullNode.create(object)), DeoptimizationReason.NullCheckException, DeoptimizationAction.InvalidateReprofile, SpeculationLog.NO_SPECULATION, true, null);
    }

    protected ValueNode createNullCheckedValue(ValueNode object, FixedNode before, LoweringTool tool) {
        GuardingNode nullCheck = this.createNullCheck(object, before, tool);
        if (nullCheck == null) {
            return object;
        }
        return before.graph().maybeAddOrUnique(PiNode.create(object, object.stamp(NodeView.DEFAULT).join(StampFactory.objectNonNull()), (ValueNode)((Object)nullCheck)));
    }

    @Override
    public ValueNode reconstructArrayIndex(JavaKind elementKind, AddressNode address) {
        StructuredGraph graph = address.graph();
        ValueNode offset = ((OffsetAddressNode)address).getOffset();
        int base = this.metaAccess.getArrayBaseOffset(elementKind);
        ValueNode scaledIndex = graph.unique(new SubNode(offset, ConstantNode.forIntegerStamp(offset.stamp(NodeView.DEFAULT), base, graph)));
        int shift = CodeUtil.log2((int)this.metaAccess.getArrayIndexScale(elementKind));
        ValueNode ret = graph.unique(new RightShiftNode(scaledIndex, ConstantNode.forInt(shift, graph)));
        return IntegerConvertNode.convert(ret, StampFactory.forKind(JavaKind.Int), graph, NodeView.DEFAULT);
    }

    @Override
    public boolean supportsOptimizedFilling(OptionValues options) {
        return false;
    }
}

