/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.bytecode.BytecodeDisassembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DisassemblerProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.alloc.Trace;
import org.graalvm.compiler.core.common.alloc.TraceBuilderResult;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.debug.IntervalDumper;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.CFGPrinter;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class CFGPrinterObserver
implements DebugDumpHandler {
    private CFGPrinter cfgPrinter;
    private File cfgFile;
    private JavaMethod curMethod;
    private CompilationIdentifier curCompilation;
    private List<String> curDecorators = Collections.emptyList();
    private LIR lastLIR = null;
    private IntervalDumper delayedIntervals = null;

    @Override
    public void dump(DebugContext debug, Object object, String format, Object ... arguments) {
        String message = String.format(format, arguments);
        try {
            this.dumpSandboxed(debug, object, message);
        }
        catch (Throwable ex) {
            TTY.println("CFGPrinter: Exception during output of " + message + ": " + ex);
            ex.printStackTrace();
        }
    }

    private boolean checkMethodScope(DebugContext debug) {
        Object method = null;
        Object compilation = null;
        ArrayList<String> decorators = new ArrayList<String>();
        for (Object o : debug.context()) {
            if (o instanceof JavaMethod) {
                method = (JavaMethod)o;
                decorators.clear();
                continue;
            }
            if (o instanceof StructuredGraph) {
                StructuredGraph graph = (StructuredGraph)o;
                if (graph.method() == null) continue;
                method = graph.method();
                decorators.clear();
                compilation = graph.compilationId();
                continue;
            }
            if (o instanceof DebugDumpScope) {
                DebugDumpScope debugDumpScope = (DebugDumpScope)o;
                if (!debugDumpScope.decorator) continue;
                decorators.add(debugDumpScope.name);
                continue;
            }
            if (!(o instanceof CompilationResult)) continue;
            CompilationResult compilationResult = (CompilationResult)o;
            compilation = compilationResult.getCompilationId();
        }
        if (method == null && compilation == null) {
            return false;
        }
        if (compilation != null) {
            if (!compilation.equals(this.curCompilation) || !this.curDecorators.equals(decorators)) {
                this.cfgPrinter.printCompilation((CompilationIdentifier)compilation);
            }
        } else if (!method.equals(this.curMethod) || !this.curDecorators.equals(decorators)) {
            this.cfgPrinter.printCompilation((JavaMethod)method);
        }
        this.curCompilation = compilation;
        this.curMethod = method;
        this.curDecorators = decorators;
        return true;
    }

    private static boolean isFrontendObject(Object object) {
        return object instanceof Graph || object instanceof BciBlockMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSandboxed(DebugContext debug, Object object, String message) {
        OptionValues options = debug.getOptions();
        boolean dumpFrontend = DebugOptions.PrintCFG.getValue(options);
        if (!dumpFrontend && CFGPrinterObserver.isFrontendObject(object)) {
            return;
        }
        if (this.cfgPrinter == null) {
            try {
                Path dumpFile = debug.getDumpPath(".cfg", false);
                this.cfgFile = dumpFile.toFile();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.cfgFile));
                this.cfgPrinter = new CFGPrinter(out);
            }
            catch (IOException e) {
                throw (GraalError)new GraalError("Could not open %s", this.cfgFile == null ? "[null]" : this.cfgFile.getAbsolutePath()).initCause(e);
            }
        }
        if (!this.checkMethodScope(debug)) {
            return;
        }
        try {
            CompilationResult compResult;
            CodeCacheProvider codeCache;
            if (this.curMethod instanceof ResolvedJavaMethod) {
                this.cfgPrinter.method = (ResolvedJavaMethod)this.curMethod;
            }
            this.cfgPrinter.lir = object instanceof LIR ? (LIR)object : debug.contextLookup(LIR.class);
            this.cfgPrinter.nodeLirGenerator = debug.contextLookup(NodeLIRBuilder.class);
            this.cfgPrinter.res = debug.contextLookup(LIRGenerationResult.class);
            if (this.cfgPrinter.nodeLirGenerator != null) {
                this.cfgPrinter.target = this.cfgPrinter.nodeLirGenerator.getLIRGeneratorTool().target();
            }
            if (this.cfgPrinter.lir != null && this.cfgPrinter.lir.getControlFlowGraph() instanceof ControlFlowGraph) {
                this.cfgPrinter.cfg = (ControlFlowGraph)this.cfgPrinter.lir.getControlFlowGraph();
            }
            if ((codeCache = debug.contextLookup(CodeCacheProvider.class)) != null) {
                this.cfgPrinter.target = codeCache.getTarget();
            }
            if (object instanceof BciBlockMapping) {
                BciBlockMapping blockMap = (BciBlockMapping)object;
                this.cfgPrinter.printCFG(message, blockMap);
                if (blockMap.code.getCode() != null) {
                    this.cfgPrinter.printBytecodes(new BytecodeDisassembler(false).disassemble(blockMap.code));
                }
            } else if (object instanceof LIR) {
                this.cfgPrinter.printCFG(message, this.cfgPrinter.lir.codeEmittingOrder(), false);
                this.lastLIR = (LIR)object;
                if (this.delayedIntervals != null) {
                    this.cfgPrinter.printIntervals(message, this.delayedIntervals);
                    this.delayedIntervals = null;
                }
            } else if (object instanceof StructuredGraph.ScheduleResult) {
                this.cfgPrinter.printSchedule(message, (StructuredGraph.ScheduleResult)object);
            } else if (object instanceof StructuredGraph) {
                StructuredGraph.ScheduleResult scheduleResult;
                StructuredGraph graph = (StructuredGraph)object;
                if (this.cfgPrinter.cfg == null && (scheduleResult = GraalDebugHandlersFactory.tryGetSchedule(debug, graph)) != null) {
                    this.cfgPrinter.cfg = scheduleResult.getCFG();
                }
                if (this.cfgPrinter.cfg != null) {
                    if (graph.nodeIdCount() > this.cfgPrinter.cfg.getNodeToBlock().capacity()) {
                        this.cfgPrinter.cfg = ControlFlowGraph.compute(graph, true, true, true, false);
                    }
                    this.cfgPrinter.printCFG(message, this.cfgPrinter.cfg.getBlocks(), true);
                }
            } else if (object instanceof CompilationResult) {
                compResult = (CompilationResult)object;
                this.cfgPrinter.printMachineCode(CFGPrinterObserver.disassemble(options, codeCache, compResult, null), message);
            } else if (object instanceof InstalledCode) {
                compResult = debug.contextLookup(CompilationResult.class);
                if (compResult != null) {
                    this.cfgPrinter.printMachineCode(CFGPrinterObserver.disassemble(options, codeCache, compResult, (InstalledCode)object), message);
                }
            } else if (object instanceof IntervalDumper) {
                if (this.lastLIR == this.cfgPrinter.lir) {
                    this.cfgPrinter.printIntervals(message, (IntervalDumper)object);
                } else {
                    if (this.delayedIntervals != null) {
                        debug.log("Some delayed intervals were dropped (%s)", this.delayedIntervals);
                    }
                    this.delayedIntervals = (IntervalDumper)object;
                }
            } else if (object instanceof AbstractBlockBase[]) {
                this.cfgPrinter.printCFG(message, (AbstractBlockBase[])object, false);
            } else if (object instanceof Trace) {
                this.cfgPrinter.printCFG(message, ((Trace)object).getBlocks(), false);
            } else if (object instanceof TraceBuilderResult) {
                this.cfgPrinter.printTraces(message, (TraceBuilderResult)object);
            }
        }
        finally {
            this.cfgPrinter.target = null;
            this.cfgPrinter.lir = null;
            this.cfgPrinter.res = null;
            this.cfgPrinter.nodeLirGenerator = null;
            this.cfgPrinter.cfg = null;
            this.cfgPrinter.flush();
        }
    }

    private static DisassemblerProvider selectDisassemblerProvider(OptionValues options) {
        DisassemblerProvider selected = null;
        String arch = (String)Services.getSavedProperties().get("os.arch");
        boolean isAArch64 = arch.equals("aarch64");
        for (DisassemblerProvider d : GraalServices.load(DisassemblerProvider.class)) {
            String name = d.getName();
            if (isAArch64 && name.equals("objdump") && d.isAvailable(options)) {
                return d;
            }
            if (!name.equals("hcf")) continue;
            if (!isAArch64) {
                return d;
            }
            selected = d;
        }
        if (selected == null) {
            selected = new DisassemblerProvider(){

                @Override
                public String getName() {
                    return "nop";
                }
            };
        }
        return selected;
    }

    private static String disassemble(OptionValues options, CodeCacheProvider codeCache, CompilationResult compResult, InstalledCode installedCode) {
        DisassemblerProvider dis = CFGPrinterObserver.selectDisassemblerProvider(options);
        if (installedCode != null) {
            return dis.disassembleInstalledCode(codeCache, compResult, installedCode);
        }
        return dis.disassembleCompiledCode(options, codeCache, compResult);
    }

    @Override
    public void close() {
        if (this.cfgPrinter != null) {
            this.cfgPrinter.close();
            this.cfgPrinter = null;
            this.curDecorators = Collections.emptyList();
            this.curMethod = null;
            this.curCompilation = null;
        }
    }

    public String getDumpPath() {
        if (this.cfgFile != null) {
            return this.cfgFile.getAbsolutePath();
        }
        return null;
    }
}

