/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.util;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.nodes.spi.CoreProvidersImpl;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.word.WordTypes;

public class Providers
extends CoreProvidersImpl
implements CodeGenProviders {
    private final CodeCacheProvider codeCache;
    private final SnippetReflectionProvider snippetReflection;
    private final WordTypes wordTypes;

    public Providers(MetaAccessProvider metaAccess, CodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, ForeignCallsProvider foreignCalls, LoweringProvider lowerer, Replacements replacements, StampProvider stampProvider, PlatformConfigurationProvider platformConfigurationProvider, MetaAccessExtensionProvider metaAccessExtensionProvider, SnippetReflectionProvider snippetReflection, WordTypes wordTypes, LoopsDataProvider loopsDataProvider) {
        super(metaAccess, constantReflection, constantFieldProvider, lowerer, replacements, stampProvider, foreignCalls, platformConfigurationProvider, metaAccessExtensionProvider, loopsDataProvider);
        this.codeCache = codeCache;
        this.snippetReflection = snippetReflection;
        this.wordTypes = wordTypes;
    }

    public Providers(Providers copyFrom) {
        this(copyFrom.getMetaAccess(), copyFrom.getCodeCache(), copyFrom.getConstantReflection(), copyFrom.getConstantFieldProvider(), copyFrom.getForeignCalls(), copyFrom.getLowerer(), copyFrom.getReplacements(), copyFrom.getStampProvider(), copyFrom.getPlatformConfigurationProvider(), copyFrom.getMetaAccessExtensionProvider(), copyFrom.getSnippetReflection(), copyFrom.getWordTypes(), copyFrom.getLoopsDataProvider());
    }

    @Override
    public CodeCacheProvider getCodeCache() {
        return this.codeCache;
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    public WordTypes getWordTypes() {
        return this.wordTypes;
    }

    @Override
    public Providers copyWith(ConstantReflectionProvider substitution) {
        assert (this.getClass() == Providers.class) : "must override";
        return new Providers(this.metaAccess, this.codeCache, substitution, this.constantFieldProvider, this.foreignCalls, this.lowerer, this.replacements, this.stampProvider, this.platformConfigurationProvider, this.metaAccessExtensionProvider, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }

    @Override
    public Providers copyWith(ConstantFieldProvider substitution) {
        assert (this.getClass() == Providers.class) : "must override";
        return new Providers(this.metaAccess, this.codeCache, this.constantReflection, substitution, this.foreignCalls, this.lowerer, this.replacements, this.stampProvider, this.platformConfigurationProvider, this.metaAccessExtensionProvider, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }

    @Override
    public Providers copyWith(Replacements substitution) {
        assert (this.getClass() == Providers.class) : "must override in " + this.getClass();
        return new Providers(this.metaAccess, this.codeCache, this.constantReflection, this.constantFieldProvider, this.foreignCalls, this.lowerer, substitution, this.stampProvider, this.platformConfigurationProvider, this.metaAccessExtensionProvider, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }

    public Providers copyWith(MetaAccessExtensionProvider substitution) {
        assert (this.getClass() == Providers.class) : this.getClass() + " must override";
        return new Providers(this.metaAccess, this.codeCache, this.constantReflection, this.constantFieldProvider, this.foreignCalls, this.lowerer, this.replacements, this.stampProvider, this.platformConfigurationProvider, substitution, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }
}

