/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MultiKillingBeginNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.cfg.LocationSet;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.schedule.ScheduleVerification;
import org.graalvm.word.LocationIdentity;

public final class SchedulePhase
extends Phase {
    private final SchedulingStrategy selectedStrategy;
    private final boolean immutableGraph;

    public SchedulePhase(OptionValues options) {
        this(false, options);
    }

    public SchedulePhase(boolean immutableGraph, OptionValues options) {
        this(GraalOptions.OptScheduleOutOfLoops.getValue(options) != false ? SchedulingStrategy.LATEST_OUT_OF_LOOPS : SchedulingStrategy.LATEST, immutableGraph);
    }

    public SchedulePhase(SchedulingStrategy strategy) {
        this(strategy, false);
    }

    public SchedulePhase(SchedulingStrategy strategy, boolean immutableGraph) {
        this.selectedStrategy = strategy;
        this.immutableGraph = immutableGraph;
    }

    private Graph.NodeEventScope verifyImmutableGraph(StructuredGraph graph) {
        if (this.immutableGraph && Assertions.assertionsEnabled()) {
            return graph.trackNodeEvents(new Graph.NodeEventListener(){

                @Override
                public void changed(Graph.NodeEvent e, Node node) {
                    assert (false) : "graph changed: " + (Object)((Object)e) + " on node " + node;
                }
            });
        }
        return null;
    }

    @Override
    protected void run(StructuredGraph graph) {
        try (Graph.NodeEventScope scope = this.verifyImmutableGraph(graph);){
            Instance inst = new Instance();
            inst.run(graph, this.selectedStrategy, this.immutableGraph);
        }
    }

    public static void run(StructuredGraph graph, SchedulingStrategy strategy, ControlFlowGraph cfg) {
        Instance inst = new Instance(cfg);
        inst.run(graph, strategy, false);
    }

    public static class Instance {
        private static final double IMPLICIT_NULL_CHECK_OPPORTUNITY_PROBABILITY_FACTOR = 2.0;
        protected ControlFlowGraph cfg;
        protected BlockMap<List<Node>> blockToNodesMap;
        protected NodeMap<Block> nodeToBlockMap;

        public Instance() {
            this(null);
        }

        public Instance(ControlFlowGraph cfg) {
            this.cfg = cfg;
        }

        public void run(StructuredGraph graph, SchedulingStrategy selectedStrategy, boolean immutableGraph) {
            if (this.cfg == null) {
                this.cfg = ControlFlowGraph.compute(graph, true, true, true, false);
            }
            NodeMap<Block> currentNodeMap = graph.createNodeMap();
            NodeBitMap visited = graph.createNodeBitMap();
            BlockMap<List<Node>> earliestBlockToNodesMap = new BlockMap<List<Node>>(this.cfg);
            this.nodeToBlockMap = currentNodeMap;
            this.blockToNodesMap = earliestBlockToNodesMap;
            this.scheduleEarliestIterative(earliestBlockToNodesMap, currentNodeMap, visited, graph, immutableGraph, selectedStrategy == SchedulingStrategy.EARLIEST_WITH_GUARD_ORDER);
            if (!selectedStrategy.isEarliest()) {
                BlockMap<List<Node>> latestBlockToNodesMap = new BlockMap<List<Node>>(this.cfg);
                for (Block b : this.cfg.getBlocks()) {
                    latestBlockToNodesMap.put(b, new ArrayList());
                }
                BlockMap<ArrayList<FloatingReadNode>> watchListMap = this.calcLatestBlocks(selectedStrategy, currentNodeMap, earliestBlockToNodesMap, visited, latestBlockToNodesMap, immutableGraph);
                Instance.sortNodesLatestWithinBlock(this.cfg, earliestBlockToNodesMap, latestBlockToNodesMap, currentNodeMap, watchListMap, visited);
                assert (Instance.verifySchedule(this.cfg, latestBlockToNodesMap, currentNodeMap));
                assert (!Assertions.detailedAssertionsEnabled(graph.getOptions()) || ScheduleVerification.check(this.cfg.getStartBlock(), latestBlockToNodesMap, currentNodeMap));
                this.blockToNodesMap = latestBlockToNodesMap;
            }
            this.cfg.setNodeToBlock(currentNodeMap);
            graph.setLastSchedule(new StructuredGraph.ScheduleResult(this.cfg, this.nodeToBlockMap, this.blockToNodesMap));
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="false positive found by findbugs")
        private BlockMap<ArrayList<FloatingReadNode>> calcLatestBlocks(SchedulingStrategy strategy, NodeMap<Block> currentNodeMap, BlockMap<List<Node>> earliestBlockToNodesMap, NodeBitMap visited, BlockMap<List<Node>> latestBlockToNodesMap, boolean immutableGraph) {
            BlockMap<ArrayList<FloatingReadNode>> watchListMap = new BlockMap<ArrayList<FloatingReadNode>>(this.cfg);
            Block[] reversePostOrder = this.cfg.reversePostOrder();
            for (int j = reversePostOrder.length - 1; j >= 0; --j) {
                Block currentBlock = reversePostOrder[j];
                List<Node> blockToNodes = earliestBlockToNodesMap.get(currentBlock);
                LocationSet killed = null;
                int previousIndex = blockToNodes.size();
                for (int i = blockToNodes.size() - 1; i >= 0; --i) {
                    FloatingReadNode floatingReadNode;
                    LocationIdentity location;
                    Node currentNode = blockToNodes.get(i);
                    assert (currentNodeMap.get(currentNode) == currentBlock);
                    assert (!(currentNode instanceof PhiNode) && !(currentNode instanceof ProxyNode));
                    assert (visited.isMarked(currentNode));
                    if (currentNode instanceof FixedNode) continue;
                    Block latestBlock = null;
                    if (currentBlock.getFirstDominated() == null && !(currentNode instanceof VirtualState)) {
                        latestBlock = currentBlock;
                    }
                    LocationIdentity constrainingLocation = null;
                    if (latestBlock == null && currentNode instanceof FloatingReadNode && (location = (floatingReadNode = (FloatingReadNode)currentNode).getLocationIdentity()).isMutable()) {
                        constrainingLocation = location;
                        if (currentBlock.canKill(location)) {
                            if (killed == null) {
                                killed = new LocationSet();
                            }
                            Instance.fillKillSet(killed, blockToNodes.subList(i + 1, previousIndex));
                            previousIndex = i;
                            if (killed.contains(location)) {
                                latestBlock = currentBlock;
                            }
                        }
                    }
                    if (latestBlock == null) {
                        this.calcLatestBlock(currentBlock, strategy, currentNode, currentNodeMap, constrainingLocation, watchListMap, latestBlockToNodesMap, visited, immutableGraph);
                        continue;
                    }
                    Instance.selectLatestBlock(currentNode, currentBlock, latestBlock, currentNodeMap, watchListMap, constrainingLocation, latestBlockToNodesMap);
                }
            }
            return watchListMap;
        }

        protected static void selectLatestBlock(Node currentNode, Block currentBlock, Block latestBlock, NodeMap<Block> currentNodeMap, BlockMap<ArrayList<FloatingReadNode>> watchListMap, LocationIdentity constrainingLocation, BlockMap<List<Node>> latestBlockToNodesMap) {
            assert (Instance.checkLatestEarliestRelation(currentNode, currentBlock, latestBlock));
            if (currentBlock != latestBlock) {
                currentNodeMap.setAndGrow(currentNode, latestBlock);
                if (constrainingLocation != null && latestBlock.canKill(constrainingLocation)) {
                    if (watchListMap.get(latestBlock) == null) {
                        watchListMap.put(latestBlock, new ArrayList());
                    }
                    watchListMap.get(latestBlock).add((FloatingReadNode)currentNode);
                }
            }
            latestBlockToNodesMap.get(latestBlock).add(currentNode);
        }

        private static boolean checkLatestEarliestRelation(Node currentNode, Block earliestBlock, Block latestBlock) {
            assert (AbstractControlFlowGraph.dominates(earliestBlock, latestBlock) || currentNode instanceof VirtualState && latestBlock == earliestBlock.getDominator()) : String.format("%s %s (%s) %s (%s)", currentNode, earliestBlock, earliestBlock.getBeginNode(), latestBlock, latestBlock.getBeginNode());
            return true;
        }

        private static boolean verifySchedule(ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodesMap, NodeMap<Block> nodeMap) {
            for (Block b : cfg.getBlocks()) {
                List<Node> nodes = blockToNodesMap.get(b);
                for (Node n : nodes) {
                    assert (n.isAlive());
                    assert (nodeMap.get(n) == b);
                    StructuredGraph g = (StructuredGraph)n.graph();
                    if (g.hasLoops() && g.getGuardsStage() == StructuredGraph.GuardsStage.AFTER_FSA && n instanceof DeoptimizeNode) assert (b.getLoopDepth() == 0) : n;
                }
            }
            return true;
        }

        public static Block checkKillsBetween(Block earliestBlock, Block latestBlock, LocationIdentity location) {
            Block lastBlock;
            block10: {
                boolean foundKill;
                block12: {
                    block11: {
                        Block currentBlock;
                        assert (AbstractControlFlowGraph.strictlyDominates(earliestBlock, latestBlock));
                        ArrayList<Block> dominatorChain = new ArrayList<Block>();
                        dominatorChain.add(latestBlock);
                        for (Block current = (Block)latestBlock.getDominator(); current != earliestBlock; current = (Block)current.getDominator()) {
                            assert (AbstractControlFlowGraph.strictlyDominates(earliestBlock, current) && AbstractControlFlowGraph.strictlyDominates(current, latestBlock));
                            if (current.canKill(location)) {
                                dominatorChain.clear();
                            }
                            dominatorChain.add(current);
                        }
                        assert (dominatorChain.size() >= 1);
                        assert (((Block)dominatorChain.get(dominatorChain.size() - 1)).getDominator() == earliestBlock);
                        lastBlock = earliestBlock;
                        for (int i = dominatorChain.size() - 1; !(i < 0 || (currentBlock = (Block)dominatorChain.get(i)).getLoopDepth() > lastBlock.getLoopDepth() && currentBlock.getLoop() != null && ((HIRLoop)currentBlock.getLoop()).canKill(location) || currentBlock.canKillBetweenThisAndDominator(location)); --i) {
                            lastBlock = currentBlock;
                        }
                        if (lastBlock == earliestBlock) break block10;
                        foundKill = false;
                        if (!(lastBlock.getBeginNode() instanceof KillingBeginNode)) break block11;
                        LocationIdentity locationIdentity = ((KillingBeginNode)lastBlock.getBeginNode()).getKilledLocationIdentity();
                        if (!locationIdentity.isAny() && !locationIdentity.equals(location)) break block12;
                        foundKill = true;
                        break block12;
                    }
                    if (lastBlock.getBeginNode() instanceof MultiKillingBeginNode) {
                        for (LocationIdentity locationIdentity : ((MultiKillingBeginNode)lastBlock.getBeginNode()).getKilledLocationIdentities()) {
                            if (!locationIdentity.isAny() && !locationIdentity.equals(location)) continue;
                            foundKill = true;
                            break;
                        }
                    }
                }
                if (foundKill) {
                    lastBlock = (Block)lastBlock.getDominator();
                }
            }
            return lastBlock;
        }

        private static void fillKillSet(LocationSet killed, List<Node> subList) {
            if (!killed.isAny()) {
                for (Node n : subList) {
                    if (n instanceof SingleMemoryKill) {
                        LocationIdentity identity = ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity();
                        killed.add(identity);
                        if (!killed.isAny()) continue;
                        return;
                    }
                    if (!(n instanceof MultiMemoryKill)) continue;
                    for (LocationIdentity identity : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                        killed.add(identity);
                        if (!killed.isAny()) continue;
                        return;
                    }
                }
            }
        }

        private static void sortNodesLatestWithinBlock(ControlFlowGraph cfg, BlockMap<List<Node>> earliestBlockToNodesMap, BlockMap<List<Node>> latestBlockToNodesMap, NodeMap<Block> currentNodeMap, BlockMap<ArrayList<FloatingReadNode>> watchListMap, NodeBitMap visited) {
            for (Block b : cfg.getBlocks()) {
                Instance.sortNodesLatestWithinBlock(b, earliestBlockToNodesMap, latestBlockToNodesMap, currentNodeMap, watchListMap, visited);
            }
        }

        private static void sortNodesLatestWithinBlock(Block b, BlockMap<List<Node>> earliestBlockToNodesMap, BlockMap<List<Node>> latestBlockToNodesMap, NodeMap<Block> nodeMap, BlockMap<ArrayList<FloatingReadNode>> watchListMap, NodeBitMap unprocessed) {
            AbstractBeginNode beginNode;
            List<Node> earliestSorting = earliestBlockToNodesMap.get(b);
            ArrayList<Node> result = new ArrayList<Node>(earliestSorting.size());
            ArrayList<FloatingReadNode> watchList = null;
            if (watchListMap != null) {
                watchList = watchListMap.get(b);
                assert (watchList == null || !b.getKillLocations().isEmpty());
            }
            if ((beginNode = b.getBeginNode()) instanceof LoopExitNode) {
                LoopExitNode loopExitNode = (LoopExitNode)beginNode;
                for (ProxyNode proxy : loopExitNode.proxies()) {
                    unprocessed.clear(proxy);
                    ValueNode value = proxy.value();
                    if (value == null || nodeMap.get(value) != b || !unprocessed.isMarked(value)) continue;
                    Instance.sortIntoList(value, b, result, nodeMap, unprocessed, null);
                }
            }
            FixedNode endNode = b.getEndNode();
            FixedNode fixedEndNode = null;
            if (Instance.isFixedEnd(endNode)) {
                fixedEndNode = endNode;
            }
            for (Node n : earliestSorting) {
                if (n == fixedEndNode) continue;
                if (n instanceof FixedNode) {
                    assert (nodeMap.get(n) == b);
                    Instance.checkWatchList(b, nodeMap, unprocessed, result, watchList, n);
                    Instance.sortIntoList(n, b, result, nodeMap, unprocessed, null);
                    continue;
                }
                if (nodeMap.get(n) != b || !(n instanceof FloatingReadNode)) continue;
                FloatingReadNode floatingReadNode = (FloatingReadNode)n;
                if (Instance.isImplicitNullOpportunity(floatingReadNode, b)) {
                    Instance.sortIntoList(floatingReadNode, b, result, nodeMap, unprocessed, null);
                    continue;
                }
                LocationIdentity location = floatingReadNode.getLocationIdentity();
                if (!b.canKill(location)) continue;
                if (watchList == null) {
                    watchList = new ArrayList();
                }
                watchList.add(floatingReadNode);
            }
            for (Node n : latestBlockToNodesMap.get(b)) {
                assert (nodeMap.get(n) == b) : n;
                assert (!(n instanceof FixedNode));
                if (!unprocessed.isMarked(n)) continue;
                Instance.sortIntoList(n, b, result, nodeMap, unprocessed, fixedEndNode);
            }
            if (endNode != null && unprocessed.isMarked(endNode)) {
                Instance.sortIntoList(endNode, b, result, nodeMap, unprocessed, null);
            }
            latestBlockToNodesMap.put(b, result);
        }

        private static void checkWatchList(Block b, NodeMap<Block> nodeMap, NodeBitMap unprocessed, ArrayList<Node> result, ArrayList<FloatingReadNode> watchList, Node n) {
            if (watchList != null && !watchList.isEmpty()) {
                if (n instanceof SingleMemoryKill) {
                    LocationIdentity identity = ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity();
                    Instance.checkWatchList(watchList, identity, b, result, nodeMap, unprocessed);
                } else if (n instanceof MultiMemoryKill) {
                    for (LocationIdentity identity : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                        Instance.checkWatchList(watchList, identity, b, result, nodeMap, unprocessed);
                    }
                }
            }
        }

        private static void checkWatchList(ArrayList<FloatingReadNode> watchList, LocationIdentity identity, Block b, ArrayList<Node> result, NodeMap<Block> nodeMap, NodeBitMap unprocessed) {
            if (!identity.isImmutable()) {
                if (identity.isAny()) {
                    for (FloatingReadNode r : watchList) {
                        if (!unprocessed.isMarked(r)) continue;
                        Instance.sortIntoList(r, b, result, nodeMap, unprocessed, null);
                    }
                    watchList.clear();
                } else {
                    int index = 0;
                    while (index < watchList.size()) {
                        FloatingReadNode r = watchList.get(index);
                        LocationIdentity locationIdentity = r.getLocationIdentity();
                        assert (locationIdentity.isMutable());
                        if (unprocessed.isMarked(r)) {
                            if (identity.overlaps(locationIdentity)) {
                                Instance.sortIntoList(r, b, result, nodeMap, unprocessed, null);
                            } else {
                                ++index;
                                continue;
                            }
                        }
                        int lastIndex = watchList.size() - 1;
                        watchList.set(index, watchList.get(lastIndex));
                        watchList.remove(lastIndex);
                    }
                }
            }
        }

        private static void sortIntoList(Node n, Block b, ArrayList<Node> result, NodeMap<Block> nodeMap, NodeBitMap unprocessed, Node excludeNode) {
            assert (unprocessed.isMarked(n)) : n;
            assert (nodeMap.get(n) == b);
            if (n instanceof PhiNode) {
                return;
            }
            unprocessed.clear(n);
            for (Node input : n.inputs()) {
                if (nodeMap.get(input) != b || !unprocessed.isMarked(input) || input == excludeNode) continue;
                Instance.sortIntoList(input, b, result, nodeMap, unprocessed, excludeNode);
            }
            if (!(n instanceof ProxyNode)) {
                result.add(n);
            }
        }

        protected void calcLatestBlock(Block earliestBlock, SchedulingStrategy strategy, Node currentNode, NodeMap<Block> currentNodeMap, LocationIdentity constrainingLocation, BlockMap<ArrayList<FloatingReadNode>> watchListMap, BlockMap<List<Node>> latestBlockToNodesMap, NodeBitMap visited, boolean immutableGraph) {
            Block latestBlock = null;
            if (!currentNode.hasUsages()) {
                assert (currentNode instanceof GuardNode);
                latestBlock = earliestBlock;
            } else {
                assert (currentNode.hasUsages());
                for (Node usage : currentNode.usages()) {
                    if (immutableGraph && !visited.contains(usage)) continue;
                    latestBlock = Instance.calcBlockForUsage(currentNode, usage, latestBlock, currentNodeMap);
                }
                assert (latestBlock != null) : currentNode;
                if (strategy.scheduleOutOfLoops()) {
                    for (Block currentBlock = latestBlock; currentBlock.getLoopDepth() > earliestBlock.getLoopDepth() && currentBlock != earliestBlock.getDominator(); currentBlock = (Block)currentBlock.getDominator()) {
                        Block previousCurrentBlock = currentBlock;
                        if (!previousCurrentBlock.isLoopHeader() || !(currentBlock.getRelativeFrequency() < latestBlock.getRelativeFrequency()) && !((StructuredGraph)currentNode.graph()).hasValueProxies()) continue;
                        latestBlock = currentBlock;
                    }
                }
                if (latestBlock != earliestBlock && latestBlock != earliestBlock.getDominator() && constrainingLocation != null) {
                    latestBlock = Instance.checkKillsBetween(earliestBlock, latestBlock, constrainingLocation);
                }
            }
            if (latestBlock != earliestBlock && strategy.considerImplicitNullChecks() && Instance.isImplicitNullOpportunity(currentNode, earliestBlock) && earliestBlock.getRelativeFrequency() < latestBlock.getRelativeFrequency() * 2.0) {
                latestBlock = earliestBlock;
            }
            Instance.selectLatestBlock(currentNode, earliestBlock, latestBlock, currentNodeMap, watchListMap, constrainingLocation, latestBlockToNodesMap);
        }

        protected static boolean isImplicitNullOpportunity(Node currentNode, Block block) {
            if (currentNode instanceof FloatingReadNode) {
                IfNode ifNode;
                FloatingReadNode floatingReadNode = (FloatingReadNode)currentNode;
                Node pred = block.getBeginNode().predecessor();
                if (pred instanceof IfNode && (ifNode = (IfNode)pred).condition() instanceof IsNullNode && ifNode.getTrueSuccessorProbability() == 0.0) {
                    IsNullNode isNullNode = (IsNullNode)ifNode.condition();
                    if (Instance.getUnproxifiedUncompressed(floatingReadNode.getAddress().getBase()) == Instance.getUnproxifiedUncompressed(isNullNode.getValue())) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static Node getUnproxifiedUncompressed(Node node) {
            Node result = node;
            while (true) {
                ConvertNode convertNode;
                if (result instanceof ValueProxy) {
                    ValueProxy valueProxy = (ValueProxy)((Object)result);
                    result = valueProxy.getOriginalNode();
                    continue;
                }
                if (!(result instanceof ConvertNode) || !(convertNode = (ConvertNode)((Object)result)).mayNullCheckSkipConversion()) break;
                result = convertNode.getValue();
            }
            return result;
        }

        private static Block calcBlockForUsage(Node node, Node usage, Block startBlock, NodeMap<Block> currentNodeMap) {
            assert (!(node instanceof PhiNode));
            Block currentBlock = startBlock;
            if (usage instanceof PhiNode) {
                PhiNode phi = (PhiNode)usage;
                AbstractMergeNode merge = phi.merge();
                Block mergeBlock = currentNodeMap.get(merge);
                for (int i = 0; i < phi.valueCount(); ++i) {
                    if (phi.valueAt(i) != node) continue;
                    Block otherBlock = ((Block[])mergeBlock.getPredecessors())[i];
                    currentBlock = AbstractControlFlowGraph.commonDominatorTyped(currentBlock, otherBlock);
                }
            } else if (usage instanceof AbstractBeginNode) {
                AbstractBeginNode abstractBeginNode = (AbstractBeginNode)usage;
                if (abstractBeginNode instanceof StartNode) {
                    currentBlock = (Block)AbstractControlFlowGraph.commonDominatorTyped(currentBlock, (AbstractBlockBase)currentNodeMap.get(abstractBeginNode));
                } else {
                    Block otherBlock = (Block)currentNodeMap.get(abstractBeginNode).getDominator();
                    currentBlock = AbstractControlFlowGraph.commonDominatorTyped(currentBlock, otherBlock);
                }
            } else {
                Block otherBlock = currentNodeMap.get(usage);
                if (usage instanceof ProxyNode) {
                    ProxyNode proxyNode = (ProxyNode)usage;
                    otherBlock = currentNodeMap.get(proxyNode.proxyPoint());
                }
                currentBlock = AbstractControlFlowGraph.commonDominatorTyped(currentBlock, otherBlock);
            }
            return currentBlock;
        }

        private void scheduleEarliestIterative(BlockMap<List<Node>> blockToNodes, NodeMap<Block> nodeToBlock, NodeBitMap visited, StructuredGraph graph, boolean immutableGraph, boolean withGuardOrder) {
            NodeMap<MicroBlock> entries = graph.createNodeMap();
            NodeStack stack = new NodeStack();
            MicroBlock startBlock = null;
            int nextId = 1;
            Block[] blockArray = this.cfg.reversePostOrder();
            int n = blockArray.length;
            for (int i = 0; i < n; ++i) {
                Block b = blockArray[i];
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    MicroBlock microBlock = new MicroBlock(nextId++);
                    entries.set(current, microBlock);
                    boolean isNew = visited.checkAndMarkInc(current);
                    assert (isNew);
                    if (startBlock != null) continue;
                    startBlock = microBlock;
                }
            }
            if (graph.getGuardsStage().allowsFloatingGuards() && graph.getNodes(GuardNode.TYPE).isNotEmpty()) {
                if (GraalOptions.GuardPriorities.getValue(graph.getOptions()).booleanValue() && withGuardOrder) {
                    EnumMap guardsByPriority = new EnumMap(StaticDeoptimizingNode.GuardPriority.class);
                    for (GuardNode guard : graph.getNodes(GuardNode.TYPE)) {
                        guardsByPriority.computeIfAbsent(guard.computePriority(), p -> new ArrayList()).add(guard);
                    }
                    for (List guards : guardsByPriority.values()) {
                        Instance.processNodes(visited, entries, stack, startBlock, guards);
                    }
                    GuardOrder.resortGuards(graph, entries, stack);
                } else {
                    Instance.processNodes(visited, entries, stack, startBlock, graph.getNodes(GuardNode.TYPE));
                }
            } else assert (graph.getNodes(GuardNode.TYPE).isEmpty());
            for (Block b : this.cfg.reversePostOrder()) {
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    Instance.processNodes(visited, entries, stack, startBlock, current.inputs());
                }
            }
            if (visited.getCounter() < graph.getNodeCount()) {
                boolean changed;
                boolean unmarkedPhi;
                do {
                    changed = false;
                    unmarkedPhi = false;
                    for (LoopBeginNode loopBegin : graph.getNodes(LoopBeginNode.TYPE)) {
                        for (PhiNode phi : loopBegin.phis()) {
                            if (visited.isMarked(phi)) {
                                for (int i = 0; i < loopBegin.getLoopEndCount(); ++i) {
                                    ValueNode node = phi.valueAt(i + loopBegin.forwardEndCount());
                                    if (node == null || entries.get(node) != null) continue;
                                    changed = true;
                                    Instance.processStack(node, startBlock, entries, visited, stack);
                                }
                                continue;
                            }
                            unmarkedPhi = true;
                        }
                    }
                } while (unmarkedPhi && changed);
            }
            if (!immutableGraph && visited.getCounter() < graph.getNodeCount()) {
                for (Node n2 : graph.getNodes()) {
                    if (visited.isMarked(n2)) continue;
                    n2.clearInputs();
                    n2.markDeleted();
                }
            }
            for (Block b : this.cfg.reversePostOrder()) {
                FixedNode fixedNode = b.getEndNode();
                if (!(fixedNode instanceof ControlSplitNode)) continue;
                ControlSplitNode controlSplitNode = (ControlSplitNode)fixedNode;
                MicroBlock endBlock = entries.get(fixedNode);
                AbstractBeginNode primarySuccessor = controlSplitNode.getPrimarySuccessor();
                if (primarySuccessor != null) {
                    endBlock.prependChildrenTo(entries.get(primarySuccessor));
                    continue;
                }
                assert (endBlock.tail == null);
            }
            for (Block b : this.cfg.reversePostOrder()) {
                int totalCount = 0;
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    MicroBlock microBlock = entries.get(current);
                    totalCount += microBlock.getNodeCount() + 1;
                }
                ArrayList<Node> nodes = new ArrayList<Node>(totalCount);
                blockToNodes.put(b, nodes);
                for (FixedNode current : b.getBeginNode().getBlockNodes()) {
                    MicroBlock microBlock = entries.get(current);
                    nodeToBlock.set(current, b);
                    nodes.add(current);
                    for (NodeEntry next = microBlock.getFirstNode(); next != null; next = next.getNext()) {
                        Node nextNode = next.getNode();
                        nodeToBlock.set(nextNode, b);
                        nodes.add(nextNode);
                    }
                }
            }
            assert (!Assertions.detailedAssertionsEnabled(this.cfg.graph.getOptions()) || ScheduleVerification.check(this.cfg.getStartBlock(), blockToNodes, nodeToBlock));
        }

        private static void processNodes(NodeBitMap visited, NodeMap<MicroBlock> entries, NodeStack stack, MicroBlock startBlock, Iterable<? extends Node> nodes) {
            for (Node node : nodes) {
                if (entries.get(node) != null) continue;
                Instance.processStack(node, startBlock, entries, visited, stack);
            }
        }

        private static void processStackPhi(NodeStack stack, PhiNode phiNode, NodeMap<MicroBlock> nodeToBlock, NodeBitMap visited) {
            stack.pop();
            if (visited.checkAndMarkInc(phiNode)) {
                MicroBlock mergeBlock = nodeToBlock.get(phiNode.merge());
                assert (mergeBlock != null) : phiNode;
                nodeToBlock.set(phiNode, mergeBlock);
                AbstractMergeNode merge = phiNode.merge();
                for (int i = 0; i < merge.forwardEndCount(); ++i) {
                    ValueNode input = phiNode.valueAt(i);
                    if (input == null || nodeToBlock.get(input) != null) continue;
                    stack.push(input);
                }
            }
        }

        private static void processStackProxy(NodeStack stack, ProxyNode proxyNode, NodeMap<MicroBlock> nodeToBlock, NodeBitMap visited) {
            stack.pop();
            if (visited.checkAndMarkInc(proxyNode)) {
                nodeToBlock.set(proxyNode, nodeToBlock.get(proxyNode.proxyPoint()));
                ValueNode input = proxyNode.value();
                if (input != null && nodeToBlock.get(input) == null) {
                    stack.push(input);
                }
            }
        }

        private static void processStack(Node first, MicroBlock startBlock, NodeMap<MicroBlock> nodeToMicroBlock, NodeBitMap visited, NodeStack stack) {
            assert (stack.isEmpty());
            assert (!visited.isMarked(first));
            stack.push(first);
            Node current = first;
            while (true) {
                if (current instanceof PhiNode) {
                    Instance.processStackPhi(stack, (PhiNode)current, nodeToMicroBlock, visited);
                } else if (current instanceof ProxyNode) {
                    Instance.processStackProxy(stack, (ProxyNode)current, nodeToMicroBlock, visited);
                } else {
                    MicroBlock currentBlock = nodeToMicroBlock.get(current);
                    if (currentBlock == null) {
                        MicroBlock earliestBlock = Instance.processInputs(nodeToMicroBlock, stack, startBlock, current);
                        if (earliestBlock != null) {
                            stack.pop();
                            visited.checkAndMarkInc(current);
                            nodeToMicroBlock.set(current, earliestBlock);
                            earliestBlock.add(current);
                        }
                    } else {
                        stack.pop();
                    }
                }
                if (stack.isEmpty()) break;
                current = stack.peek();
            }
        }

        private static MicroBlock processInputs(NodeMap<MicroBlock> nodeToBlock, NodeStack stack, MicroBlock startBlock, Node current) {
            if (current.getNodeClass().isLeafNode()) {
                return startBlock;
            }
            MicroBlock earliestBlock = startBlock;
            for (Node input : current.inputs()) {
                MicroBlock inputBlock = nodeToBlock.get(input);
                if (inputBlock == null) {
                    earliestBlock = null;
                    stack.push(input);
                    continue;
                }
                if (earliestBlock == null || inputBlock.getId() <= earliestBlock.getId()) continue;
                earliestBlock = inputBlock;
            }
            return earliestBlock;
        }

        private static boolean isFixedEnd(FixedNode endNode) {
            return endNode instanceof ControlSplitNode || endNode instanceof ControlSinkNode || endNode instanceof AbstractEndNode;
        }

        public String printScheduleHelper(String desc) {
            Formatter buf = new Formatter();
            buf.format("=== %s / %s ===%n", this.getCFG().getStartBlock().getBeginNode().graph(), desc);
            for (Block b : this.getCFG().getBlocks()) {
                buf.format("==== b: %s (loopDepth: %s). ", b, b.getLoopDepth());
                buf.format("dom: %s. ", b.getDominator());
                buf.format("preds: %s. ", Arrays.toString(b.getPredecessors()));
                buf.format("succs: %s ====%n", Arrays.toString(b.getSuccessors()));
                if (this.blockToNodesMap.get(b) != null) {
                    for (Node node : this.nodesFor(b)) {
                        Instance.printNode(node);
                    }
                    continue;
                }
                for (Node node : b.getNodes()) {
                    Instance.printNode(node);
                }
            }
            buf.format("%n", new Object[0]);
            return buf.toString();
        }

        private static void printNode(Node n) {
            Formatter buf = new Formatter();
            buf.format("%s", n);
            if (n instanceof SingleMemoryKill) {
                buf.format(" // kills %s", ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity());
            } else if (n instanceof MultiMemoryKill) {
                buf.format(" // kills ", new Object[0]);
                for (LocationIdentity locid : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                    buf.format("%s, ", locid);
                }
            } else if (n instanceof FloatingReadNode) {
                FloatingReadNode frn = (FloatingReadNode)n;
                buf.format(" // from %s", frn.getLocationIdentity());
                buf.format(", lastAccess: %s", frn.getLastLocationAccess());
                buf.format(", address: %s", frn.getAddress());
            } else if (n instanceof GuardNode) {
                buf.format(", anchor: %s", ((GuardNode)n).getAnchor());
            }
            n.getDebug().log("%s", buf);
        }

        public ControlFlowGraph getCFG() {
            return this.cfg;
        }

        public List<Node> nodesFor(Block block) {
            return this.blockToNodesMap.get(block);
        }

        private static class GuardOrder {
            private GuardOrder() {
            }

            private static void resortGuards(StructuredGraph graph, NodeMap<MicroBlock> entries, NodeStack stack) {
                assert (stack.isEmpty());
                EconomicSet blocksWithGuards = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                for (GuardNode guard : graph.getNodes(GuardNode.TYPE)) {
                    MicroBlock block = entries.get(guard);
                    assert (block != null) : guard + "should already be scheduled to a micro-block";
                    blocksWithGuards.add((Object)block);
                }
                assert (!blocksWithGuards.isEmpty());
                NodeMap<StaticDeoptimizingNode.GuardPriority> priorities = graph.createNodeMap();
                NodeBitMap blockNodes = graph.createNodeBitMap();
                for (MicroBlock block : blocksWithGuards) {
                    MicroBlock newBlock = GuardOrder.resortGuards(block, stack, blockNodes, priorities);
                    assert (stack.isEmpty());
                    assert (blockNodes.isEmpty());
                    if (newBlock == null) continue;
                    assert (block.getNodeCount() == newBlock.getNodeCount());
                    block.head = newBlock.head;
                    block.tail = newBlock.tail;
                }
            }

            private static MicroBlock resortGuards(MicroBlock block, NodeStack stack, NodeBitMap blockNodes, NodeMap<StaticDeoptimizingNode.GuardPriority> priorities) {
                if (!GuardOrder.propagatePriority(block, stack, priorities, blockNodes)) {
                    return null;
                }
                Function<GuardNode, StaticDeoptimizingNode.GuardPriority> transitiveGuardPriorityGetter = priorities::get;
                Comparator<GuardNode> globalGuardPriorityComparator = Comparator.comparing(transitiveGuardPriorityGetter).thenComparing(StaticDeoptimizingNode::computePriority).thenComparingInt(Node::hashCode);
                TreeSet<GuardNode> availableGuards = new TreeSet<GuardNode>(globalGuardPriorityComparator);
                MicroBlock newBlock = new MicroBlock(block.getId());
                NodeBitMap sorted = blockNodes;
                sorted.invert();
                NodeEntry e = block.head;
                while (e != null) {
                    GuardOrder.checkIfAvailable(e.node, stack, sorted, newBlock, availableGuards, false);
                    e = e.next;
                }
                while (true) {
                    if (!stack.isEmpty()) {
                        GuardOrder.checkIfAvailable(stack.pop(), stack, sorted, newBlock, availableGuards, true);
                        continue;
                    }
                    Iterator iterator = availableGuards.iterator();
                    if (iterator.hasNext()) {
                        GuardOrder.addNodeToResort((Node)iterator.next(), stack, sorted, newBlock, true);
                        iterator.remove();
                    }
                    if (stack.isEmpty() && availableGuards.isEmpty()) break;
                }
                blockNodes.clearAll();
                return newBlock;
            }

            private static void checkIfAvailable(Node n, NodeStack stack, NodeBitMap sorted, MicroBlock newBlock, SortedSet<GuardNode> availableGuardNodes, boolean pushUsages) {
                if (sorted.isMarked(n)) {
                    return;
                }
                for (Node in : n.inputs()) {
                    if (sorted.isMarked(in)) continue;
                    return;
                }
                if (n instanceof GuardNode) {
                    availableGuardNodes.add((GuardNode)n);
                } else {
                    GuardOrder.addNodeToResort(n, stack, sorted, newBlock, pushUsages);
                }
            }

            private static void addNodeToResort(Node n, NodeStack stack, NodeBitMap sorted, MicroBlock newBlock, boolean pushUsages) {
                sorted.mark(n);
                newBlock.add(n);
                if (pushUsages) {
                    for (Node u : n.usages()) {
                        if (sorted.isMarked(u)) continue;
                        stack.push(u);
                    }
                }
            }

            private static boolean propagatePriority(MicroBlock block, NodeStack stack, NodeMap<StaticDeoptimizingNode.GuardPriority> priorities, NodeBitMap blockNodes) {
                assert (stack.isEmpty());
                assert (blockNodes.isEmpty());
                StaticDeoptimizingNode.GuardPriority lowestPriority = StaticDeoptimizingNode.GuardPriority.highest();
                NodeEntry e = block.head;
                while (e != null) {
                    blockNodes.mark(e.node);
                    if (e.node instanceof GuardNode) {
                        GuardNode guard = (GuardNode)e.node;
                        StaticDeoptimizingNode.GuardPriority priority = guard.computePriority();
                        if (lowestPriority != null) {
                            if (priority.isLowerPriorityThan(lowestPriority)) {
                                lowestPriority = priority;
                            } else if (priority.isHigherPriorityThan(lowestPriority)) {
                                lowestPriority = null;
                            }
                        }
                        stack.push(guard);
                        priorities.set(guard, priority);
                    }
                    e = e.next;
                }
                if (lowestPriority != null) {
                    stack.clear();
                    blockNodes.clearAll();
                    return false;
                }
                do {
                    Node current = stack.pop();
                    assert (blockNodes.isMarked(current));
                    StaticDeoptimizingNode.GuardPriority priority = priorities.get(current);
                    for (Node input : current.inputs()) {
                        StaticDeoptimizingNode.GuardPriority inputPriority;
                        if (!blockNodes.isMarked(input) || (inputPriority = priorities.get(input)) != null && !inputPriority.isLowerPriorityThan(priority)) continue;
                        priorities.set(input, priority);
                        stack.push(input);
                    }
                } while (!stack.isEmpty());
                return true;
            }
        }

        private static class NodeEntry {
            private final Node node;
            private NodeEntry next;

            NodeEntry(Node node) {
                this.node = node;
                this.next = null;
            }

            public NodeEntry getNext() {
                return this.next;
            }

            public Node getNode() {
                return this.node;
            }
        }

        private static class MicroBlock {
            private final int id;
            private int nodeCount;
            private NodeEntry head;
            private NodeEntry tail;

            MicroBlock(int id) {
                this.id = id;
            }

            public void add(Node node) {
                assert (!(node instanceof FixedNode)) : node;
                NodeEntry newTail = new NodeEntry(node);
                if (this.tail == null) {
                    this.tail = this.head = newTail;
                } else {
                    this.tail.next = newTail;
                    this.tail = newTail;
                }
                ++this.nodeCount;
            }

            public int getNodeCount() {
                assert (this.getActualNodeCount() == this.nodeCount) : this.getActualNodeCount() + " != " + this.nodeCount;
                return this.nodeCount;
            }

            private int getActualNodeCount() {
                int count = 0;
                NodeEntry e = this.head;
                while (e != null) {
                    ++count;
                    e = e.next;
                }
                return count;
            }

            public int getId() {
                return this.id;
            }

            public NodeEntry getFirstNode() {
                return this.head;
            }

            public void prependChildrenTo(MicroBlock newBlock) {
                if (this.tail != null) {
                    assert (this.head != null);
                    this.tail.next = newBlock.head;
                    newBlock.head = this.head;
                    this.tail = null;
                    this.head = null;
                    newBlock.nodeCount += this.nodeCount;
                    this.nodeCount = 0;
                }
            }

            public String toString() {
                return String.format("MicroBlock[id=%d]", this.id);
            }

            public int hashCode() {
                return this.id;
            }
        }
    }

    public static enum SchedulingStrategy {
        EARLIEST_WITH_GUARD_ORDER,
        EARLIEST,
        LATEST,
        LATEST_OUT_OF_LOOPS,
        LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS;


        public boolean isEarliest() {
            return this == EARLIEST || this == EARLIEST_WITH_GUARD_ORDER;
        }

        public boolean isLatest() {
            return !this.isEarliest();
        }

        public boolean scheduleOutOfLoops() {
            return this == LATEST_OUT_OF_LOOPS || this == LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS;
        }

        public boolean considerImplicitNullChecks() {
            return this == LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS;
        }
    }
}

