/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.walker;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

public class InliningIterator {
    private final StartNode start;
    private final Deque<FixedNode> nodeQueue;
    private final NodeBitMap queuedNodes;

    public InliningIterator(StructuredGraph graph) {
        this.start = graph.start();
        this.nodeQueue = new ArrayDeque<FixedNode>();
        this.queuedNodes = graph.createNodeBitMap();
        assert (this.start.isAlive());
    }

    public LinkedList<Invoke> apply() {
        FixedNode current;
        LinkedList<Invoke> invokes = new LinkedList<Invoke>();
        this.forcedQueue(this.start);
        while ((current = this.nextQueuedNode()) != null) {
            assert (current.isAlive());
            if (current instanceof Invoke && ((Invoke)((Object)current)).callTarget() instanceof MethodCallTargetNode) {
                if (current != this.start) {
                    invokes.addLast((Invoke)((Object)current));
                }
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof LoopBeginNode) {
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof LoopEndNode) continue;
            if (current instanceof AbstractMergeNode) {
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof FixedWithNextNode) {
                this.queueSuccessors(current);
                continue;
            }
            if (current instanceof EndNode) {
                this.queueMerge((EndNode)current);
                continue;
            }
            if (current instanceof ControlSinkNode) continue;
            if (current instanceof ControlSplitNode) {
                this.queueSuccessors(current);
                continue;
            }
            assert (false) : current;
        }
        assert (invokes.size() == InliningIterator.count(this.start.graph().getInvokes()));
        return invokes;
    }

    private void queueSuccessors(FixedNode x) {
        for (Node node : x.successors()) {
            this.queue(node);
        }
    }

    private void queue(Node node) {
        if (node != null && !this.queuedNodes.isMarked(node)) {
            this.forcedQueue(node);
        }
    }

    private void forcedQueue(Node node) {
        this.queuedNodes.mark(node);
        this.nodeQueue.addFirst((FixedNode)node);
    }

    private FixedNode nextQueuedNode() {
        if (this.nodeQueue.isEmpty()) {
            return null;
        }
        FixedNode result = this.nodeQueue.removeFirst();
        assert (this.queuedNodes.isMarked(result));
        return result;
    }

    private void queueMerge(AbstractEndNode end) {
        AbstractMergeNode merge = end.merge();
        if (!this.queuedNodes.isMarked(merge) && this.visitedAllEnds(merge)) {
            this.queuedNodes.mark(merge);
            this.nodeQueue.add(merge);
        }
    }

    private boolean visitedAllEnds(AbstractMergeNode merge) {
        for (int i = 0; i < merge.forwardEndCount(); ++i) {
            if (this.queuedNodes.isMarked(merge.forwardEndAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int count(Iterable<Invoke> invokes) {
        int count = 0;
        Iterator<Invoke> iterator = invokes.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

