/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class WriteBarrierAdditionPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        BarrierSet barrierSet = context.getPlatformConfigurationProvider().getBarrierSet();
        for (FixedAccessNode n : graph.getNodes(FixedAccessNode.TYPE)) {
            DebugCloseable scope = n.graph().withNodeSourcePosition(n);
            Throwable throwable = null;
            try {
                barrierSet.addBarriers(n);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (scope == null) continue;
                if (throwable != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                scope.close();
            }
        }
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

