/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.EnumSet;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class ReassociationPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;

    public ReassociationPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSetNodeEventListener changedNodes = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.NODE_ADDED));
        try (Graph.NodeEventScope news = graph.trackNodeEvents(changedNodes);){
            ReassociationPhase.prepareGraphForReassociation(graph);
            ReassociationPhase.reassociateConstants(graph, context);
            ReassociationPhase.reassociateInvariants(graph, context);
        }
        this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)changedNodes.getNodes());
    }

    private static void reassociateInvariants(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        int iterations = 0;
        try (DebugContext.Scope s = debug.scope("ReassociateInvariants");){
            boolean changed = true;
            while (changed && iterations < 32) {
                changed = false;
                for (LoopEx loop : loopsData.loops()) {
                    changed |= loop.reassociateInvariants();
                }
                loopsData.deleteUnusedNodes();
                debug.dump(5, (Object)graph, "Reassociation: after iteration %d", ++iterations);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static void reassociateConstants(StructuredGraph graph, CoreProviders context) {
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        NodeBitMap loopNodes = graph.createNodeBitMap();
        for (LoopEx loop : loopsData.loops()) {
            loopNodes.union(loop.whole().nodes());
        }
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("ReassociateConstants");){
            for (BinaryArithmeticNode binary : graph.getNodes().filter(BinaryArithmeticNode.class)) {
                ValueNode result;
                if (!binary.isAssociative() || !loopNodes.isNew(binary) && loopNodes.contains(binary) || (result = BinaryArithmeticNode.reassociateUnmatchedValues(binary, ValueNode.isConstantPredicate(), NodeView.DEFAULT)) == binary) continue;
                if (!result.isAlive()) {
                    assert (!result.isDeleted());
                    result = graph.addOrUniqueWithInputs(result);
                }
                if (debug.isLogEnabled()) {
                    debug.log("%s : Re-associated %s into %s", (Object)graph.method().format("%H::%n"), (Object)binary, (Object)result);
                }
                binary.replaceAtUsages(result);
                GraphUtil.killWithUnusedFloatingInputs(binary);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static void prepareGraphForReassociation(StructuredGraph graph) {
        DebugContext debug = graph.getDebug();
        EconomicSetNodeEventListener nev = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.NODE_ADDED));
        try (Graph.NodeEventScope news = graph.trackNodeEvents(nev);){
            for (LeftShiftNode l : graph.getNodes().filter(LeftShiftNode.class)) {
                l.tryReplaceWithMulNode();
            }
        }
        debug.dump(5, graph, "Reassociation: after creating mul nodes from shifts");
        for (Node newNode : nev.getNodes()) {
            if (!(newNode instanceof MulNode)) continue;
            assert (((MulNode)newNode).getY().isConstant());
            MulNode mul = (MulNode)newNode;
            for (Node usage : newNode.usages()) {
                MulNode newMul;
                long i;
                if (usage instanceof AddNode) {
                    if ((((BinaryArithmeticNode)usage).getX() != mul.getX() || ((BinaryArithmeticNode)usage).getY() != mul) && (((BinaryArithmeticNode)usage).getY() != mul.getX() || ((BinaryArithmeticNode)usage).getX() != mul)) continue;
                    i = ((PrimitiveConstant)mul.getY().asConstant()).asLong();
                    newMul = graph.addOrUnique(new MulNode(mul.getX(), ConstantNode.forIntegerStamp(mul.getY().stamp(NodeView.DEFAULT), i + 1L, graph)));
                    usage.replaceAtUsages(newMul);
                    continue;
                }
                if (!(usage instanceof SubNode) || ((BinaryArithmeticNode)usage).getX() != mul || ((BinaryArithmeticNode)usage).getY() != mul.getX()) continue;
                i = ((PrimitiveConstant)mul.getY().asConstant()).asLong();
                newMul = graph.addOrUnique(new MulNode(mul.getX(), ConstantNode.forIntegerStamp(mul.getY().stamp(NodeView.DEFAULT), i - 1L, graph)));
                usage.replaceAtUsages(newMul);
            }
        }
        debug.dump(5, graph, "Reassociation: after creating mul from add/sub");
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }
}

