/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.OSRMonitorEnterNode;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;

public class LockEliminationPhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        for (MonitorExitNode monitorExitNode : graph.getNodes(MonitorExitNode.TYPE)) {
            MonitorIdNode exitId;
            FixedNode next = monitorExitNode.next();
            if (!(next instanceof MonitorEnterNode)) continue;
            assert (!(next instanceof OSRMonitorEnterNode));
            AccessMonitorNode monitorEnterNode = (AccessMonitorNode)next;
            if (!LockEliminationPhase.isCompatibleLock(monitorEnterNode, monitorExitNode)) continue;
            MonitorIdNode enterId = monitorEnterNode.getMonitorId();
            if (enterId != (exitId = monitorExitNode.getMonitorId())) {
                enterId.replaceAndDelete(exitId);
            }
            GraphUtil.removeFixedWithUnusedInputs(monitorEnterNode);
            GraphUtil.removeFixedWithUnusedInputs(monitorExitNode);
        }
    }

    public static boolean isCompatibleLock(AccessMonitorNode lock1, AccessMonitorNode lock2) {
        ValueNode object2;
        ValueNode object1 = GraphUtil.unproxify(lock1.object());
        return object1 == (object2 = GraphUtil.unproxify(lock2.object())) && lock1.getMonitorId().getLockDepth() == lock2.getMonitorId().getLockDepth();
    }
}

