/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;

public class BoxNodeOptimizationPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        ControlFlowGraph cfg = null;
        Graph.Mark before = graph.getMark();
        block0: for (BoxNode box : graph.getNodes(BoxNode.TYPE)) {
            if (!box.isAlive()) continue;
            ValueNode primitiveVal = box.getValue();
            assert (primitiveVal != null) : "Box " + box + " has no value";
            block1: for (Node usage : primitiveVal.usages().snapshot()) {
                BoxNode boxUsageOnBoxedVal;
                if (usage == box || !(usage instanceof BoxNode) || (boxUsageOnBoxedVal = (BoxNode)usage).getBoxingKind() != box.getBoxingKind()) continue;
                if (cfg == null) {
                    cfg = ControlFlowGraph.compute(graph, true, true, true, false);
                }
                if (graph.isNew(before, boxUsageOnBoxedVal) || graph.isNew(before, box)) continue;
                Block boxUsageOnBoxedValBlock = cfg.blockFor(boxUsageOnBoxedVal);
                Block originalBoxBlock = cfg.blockFor(box);
                if (boxUsageOnBoxedValBlock.getLoop() != null && originalBoxBlock.getLoop() != boxUsageOnBoxedValBlock.getLoop() || !AbstractControlFlowGraph.dominates(boxUsageOnBoxedValBlock, originalBoxBlock)) continue;
                if (boxUsageOnBoxedValBlock == originalBoxBlock) {
                    for (FixedNode f : boxUsageOnBoxedValBlock.getNodes()) {
                        if (f == boxUsageOnBoxedVal) break;
                        if (f != box) continue;
                        continue block1;
                    }
                }
                box.replaceAtUsages(boxUsageOnBoxedVal);
                graph.getDebug().dump(5, graph, "After replacing %s with %s", box, boxUsageOnBoxedVal);
                GraphUtil.removeFixedWithUnusedInputs(box);
                continue block0;
            }
        }
    }
}

