/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.EnsureVirtualizedNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Alloc {i#virtualObjects}", allowedUsageTypes={InputType.Extension, InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="We don't know statically how many, and which, allocations are done.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="We don't know statically how much code for which allocations has to be generated.")
public final class CommitAllocationNode
extends FixedWithNextNode
implements VirtualizableAllocation,
Lowerable,
Simplifiable,
SingleMemoryKill {
    public static final NodeClass<CommitAllocationNode> TYPE = NodeClass.create(CommitAllocationNode.class);
    @Node.Input
    NodeInputList<VirtualObjectNode> virtualObjects = new NodeInputList(this);
    @Node.Input
    NodeInputList<ValueNode> values = new NodeInputList(this);
    @Node.Input(value=InputType.Association)
    NodeInputList<MonitorIdNode> locks = new NodeInputList(this);
    protected ArrayList<Integer> lockIndexes = new ArrayList<Integer>(Arrays.asList(0));
    protected ArrayList<Boolean> ensureVirtual = new ArrayList();

    public CommitAllocationNode() {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
    }

    public List<VirtualObjectNode> getVirtualObjects() {
        return this.virtualObjects;
    }

    public List<ValueNode> getValues() {
        return this.values;
    }

    public List<MonitorIdNode> getLocks(int objIndex) {
        return this.locks.subList(this.lockIndexes.get(objIndex), this.lockIndexes.get(objIndex + 1));
    }

    public List<Boolean> getEnsureVirtual() {
        return this.ensureVirtual;
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.virtualObjects.size() + 1 == this.lockIndexes.size(), "lockIndexes size doesn't match %s, %s", this.virtualObjects, this.lockIndexes);
        this.assertTrue(this.lockIndexes.get(this.lockIndexes.size() - 1).intValue() == this.locks.size(), "locks size doesn't match %s,%s", this.lockIndexes, this.locks);
        int valueCount = 0;
        for (VirtualObjectNode virtual : this.virtualObjects) {
            valueCount += virtual.entryCount();
        }
        this.assertTrue(this.values.size() == valueCount, "values size doesn't match", new Object[0]);
        this.assertTrue(this.virtualObjects.size() == this.ensureVirtual.size(), "ensureVirtual size doesn't match", new Object[0]);
        return super.verify();
    }

    @Override
    public void lower(LoweringTool tool) {
        for (int i = 0; i < this.virtualObjects.size(); ++i) {
            if (!this.ensureVirtual.get(i).booleanValue()) continue;
            EnsureVirtualizedNode.ensureVirtualFailure(this, ((VirtualObjectNode)this.virtualObjects.get(i)).stamp(NodeView.DEFAULT));
        }
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locks.isEmpty() ? LocationIdentity.init() : LocationIdentity.any();
    }

    @Override
    public void afterClone(Node other) {
        this.lockIndexes = new ArrayList<Integer>(this.lockIndexes);
    }

    public void addLocks(List<MonitorIdNode> monitorIds) {
        this.locks.addAll((Collection<MonitorIdNode>)monitorIds);
        this.lockIndexes.add(this.locks.size());
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        int pos = 0;
        for (int i = 0; i < this.virtualObjects.size(); ++i) {
            VirtualObjectNode virtualObject = (VirtualObjectNode)this.virtualObjects.get(i);
            int entryCount = virtualObject.entryCount();
            tool.createVirtualObject(virtualObject, this.values.subList(pos, pos + entryCount).toArray(new ValueNode[entryCount]), this.getLocks(i), this.ensureVirtual.get(i));
            pos += entryCount;
        }
        tool.delete();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> properties = super.getDebugProperties(map);
        int valuePos = 0;
        for (int objIndex = 0; objIndex < this.virtualObjects.size(); ++objIndex) {
            VirtualObjectNode virtual = (VirtualObjectNode)this.virtualObjects.get(objIndex);
            if (virtual == null) {
                properties.put("object(" + objIndex + ")", "null");
                continue;
            }
            StringBuilder s = new StringBuilder();
            s.append(virtual.type().toJavaName(false)).append("[");
            for (int i = 0; i < virtual.entryCount(); ++i) {
                ValueNode value = (ValueNode)this.values.get(valuePos++);
                s.append(i == 0 ? "" : ",").append(value == null ? "_" : value.toString(Verbosity.Id));
            }
            s.append("]");
            if (!this.getLocks(objIndex).isEmpty()) {
                s.append(" locked(").append(this.getLocks(objIndex)).append(")");
            }
            properties.put("object(" + virtual.toString(Verbosity.Id) + ")", s.toString());
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void simplify(SimplifierTool tool) {
        boolean progress;
        boolean[] used = new boolean[this.virtualObjects.size()];
        int usedCount = 0;
        for (AllocatedObjectNode allocatedObjectNode : this.usages().filter(AllocatedObjectNode.class)) {
            int index = this.virtualObjects.indexOf(allocatedObjectNode.getVirtualObject());
            assert (!used[index]);
            used[index] = true;
            ++usedCount;
        }
        if (usedCount == 0) {
            List<Node> inputSnapshot = this.inputs().snapshot();
            this.graph().removeFixed(this);
            for (Node input : inputSnapshot) {
                tool.removeIfUnused(input);
            }
            return;
        }
        do {
            progress = false;
            boolean bl = false;
            for (int objIndex = 0; objIndex < this.virtualObjects.size(); ++objIndex) {
                VirtualObjectNode virtualObject = (VirtualObjectNode)this.virtualObjects.get(objIndex);
                if (used[objIndex]) {
                    for (int i = 0; i < virtualObject.entryCount(); ++i) {
                        void var5_9;
                        int index = this.virtualObjects.indexOf(this.values.get((int)(var5_9 + i)));
                        if (index == -1 || used[index]) continue;
                        progress = true;
                        used[index] = true;
                        ++usedCount;
                    }
                }
                var5_9 += virtualObject.entryCount();
            }
        } while (progress);
        if (usedCount < this.virtualObjects.size()) {
            ArrayList<VirtualObjectNode> arrayList = new ArrayList<VirtualObjectNode>(usedCount);
            ArrayList<MonitorIdNode> newLocks = new ArrayList<MonitorIdNode>(usedCount);
            ArrayList<Integer> newLockIndexes = new ArrayList<Integer>(usedCount + 1);
            ArrayList<Boolean> newEnsureVirtual = new ArrayList<Boolean>(usedCount);
            newLockIndexes.add(0);
            ArrayList newValues = new ArrayList();
            int valuePos = 0;
            for (int objIndex = 0; objIndex < this.virtualObjects.size(); ++objIndex) {
                VirtualObjectNode virtualObject = (VirtualObjectNode)this.virtualObjects.get(objIndex);
                if (used[objIndex]) {
                    arrayList.add(virtualObject);
                    newLocks.addAll(this.getLocks(objIndex));
                    newLockIndexes.add(newLocks.size());
                    newValues.addAll(this.values.subList(valuePos, valuePos + virtualObject.entryCount()));
                    newEnsureVirtual.add(this.ensureVirtual.get(objIndex));
                }
                valuePos += virtualObject.entryCount();
            }
            this.virtualObjects.clear();
            this.virtualObjects.addAll((Collection<VirtualObjectNode>)arrayList);
            this.locks.clear();
            this.locks.addAll((Collection<MonitorIdNode>)newLocks);
            this.values.clear();
            this.values.addAll(newValues);
            this.lockIndexes = newLockIndexes;
            this.ensureVirtual = newEnsureVirtual;
        }
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        List<VirtualObjectNode> v = this.getVirtualObjects();
        int fieldWriteCount = 0;
        for (int i = 0; i < v.size(); ++i) {
            VirtualObjectNode node = v.get(i);
            if (node == null) {
                return NodeCycles.CYCLES_UNKNOWN;
            }
            fieldWriteCount += node.entryCount();
        }
        int rawValueWrites = NodeCycles.compute((NodeCycles)WriteNode.TYPE.cycles(), (int)fieldWriteCount).value;
        int rawValuesTlabBumps = AbstractNewObjectNode.TYPE.cycles().value;
        return NodeCycles.compute(rawValueWrites + rawValuesTlabBumps);
    }

    @Override
    public NodeSize estimatedNodeSize() {
        List<VirtualObjectNode> v = this.getVirtualObjects();
        int fieldWriteCount = 0;
        for (int i = 0; i < v.size(); ++i) {
            VirtualObjectNode node = v.get(i);
            if (node == null) {
                return NodeSize.SIZE_UNKNOWN;
            }
            fieldWriteCount += node.entryCount();
        }
        int rawValueWrites = NodeSize.compute((NodeSize)WriteNode.TYPE.size(), (int)fieldWriteCount).value;
        int rawValuesTlabBumps = AbstractNewObjectNode.TYPE.size().value;
        return NodeSize.compute(rawValueWrites + rawValuesTlabBumps);
    }
}

