/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.spi;

import java.util.List;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;

public interface VirtualizerTool {
    public CoreProviders getProviders();

    public MetaAccessProvider getMetaAccess();

    public ConstantReflectionProvider getConstantReflection();

    public MetaAccessExtensionProvider getMetaAccessExtensionProvider();

    public int getMaximumEntryCount();

    public void createVirtualObject(VirtualObjectNode var1, ValueNode[] var2, List<MonitorIdNode> var3, boolean var4);

    public ValueNode getAlias(ValueNode var1);

    public boolean setVirtualEntry(VirtualObjectNode var1, int var2, ValueNode var3, JavaKind var4, long var5);

    default public void setVirtualEntry(VirtualObjectNode virtualObject, int index, ValueNode value) {
        if (!this.setVirtualEntry(virtualObject, index, value, null, 0L)) {
            throw new GraalError("unexpected failure when updating virtual entry");
        }
    }

    public ValueNode getEntry(VirtualObjectNode var1, int var2);

    public void addLock(VirtualObjectNode var1, MonitorIdNode var2);

    public MonitorIdNode removeLock(VirtualObjectNode var1);

    public void setEnsureVirtualized(VirtualObjectNode var1, boolean var2);

    public boolean getEnsureVirtualized(VirtualObjectNode var1);

    public void replaceWithVirtual(VirtualObjectNode var1);

    public void replaceWithValue(ValueNode var1);

    public void delete();

    public void replaceFirstInput(Node var1, Node var2);

    public void addNode(ValueNode var1);

    public void replaceWith(ValueNode var1);

    public boolean ensureMaterialized(VirtualObjectNode var1);

    public boolean canVirtualizeLargeByteArrayUnsafeAccess();

    public OptionValues getOptions();

    public DebugContext getDebug();
}

