/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory.address;

import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;

@NodeInfo(allowedUsageTypes={InputType.Association})
public class OffsetAddressNode
extends AddressNode
implements Canonicalizable {
    public static final NodeClass<OffsetAddressNode> TYPE = NodeClass.create(OffsetAddressNode.class);
    @Node.Input
    ValueNode base;
    @Node.Input
    ValueNode offset;

    public OffsetAddressNode(ValueNode base, ValueNode offset) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.base = base;
        this.offset = offset;
        assert (base != null && (base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(base.stamp(NodeView.DEFAULT)) == 64) && offset != null && IntegerStamp.getBits(offset.stamp(NodeView.DEFAULT)) == 64) : "both values must have 64 bits";
    }

    public static OffsetAddressNode create(ValueNode base) {
        ConstantNode offset = base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp ? ConstantNode.forIntegerBits(64, 0L) : ConstantNode.forIntegerBits(PrimitiveStamp.getBits(base.stamp(NodeView.DEFAULT)), 0L);
        return new OffsetAddressNode(base, offset);
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        this.updateUsages(this.base, base);
        this.base = base;
        assert (base != null && (base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(base.stamp(NodeView.DEFAULT)) == 64));
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public void setOffset(ValueNode offset) {
        this.updateUsages(this.offset, offset);
        this.offset = offset;
        assert (offset != null && IntegerStamp.getBits(offset.stamp(NodeView.DEFAULT)) == 64);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        AddNode add;
        if (this.base instanceof OffsetAddressNode) {
            NodeView view = NodeView.from(tool);
            OffsetAddressNode b = (OffsetAddressNode)this.base;
            return new OffsetAddressNode(b.getBase(), BinaryArithmeticNode.add(b.getOffset(), this.getOffset(), view));
        }
        if (this.base instanceof AddNode && (add = (AddNode)this.base).getY().isConstant()) {
            return new OffsetAddressNode(add.getX(), new AddNode(add.getY(), this.getOffset()));
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native AddressNode.Address address(Object var0, long var1);

    @Override
    public long getMaxConstantDisplacement() {
        IntegerStamp integerStamp;
        Stamp curStamp = this.offset.stamp(NodeView.DEFAULT);
        if (curStamp instanceof IntegerStamp && (integerStamp = (IntegerStamp)curStamp).lowerBound() >= 0L) {
            return integerStamp.upperBound();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public ValueNode getIndex() {
        return null;
    }
}

