/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CanonicalizableLocation;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FloatableAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Read#{p#location/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class ReadNode
extends FloatableAccessNode
implements LIRLowerableAccess,
Canonicalizable,
Virtualizable,
GuardingNode {
    public static final NodeClass<ReadNode> TYPE = NodeClass.create(ReadNode.class);

    public ReadNode(AddressNode address, LocationIdentity location, Stamp stamp, OnHeapMemoryAccess.BarrierType barrierType) {
        this((NodeClass<? extends ReadNode>)TYPE, address, location, stamp, (GuardingNode)null, barrierType, false, (FrameState)null);
    }

    protected ReadNode(NodeClass<? extends ReadNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, OnHeapMemoryAccess.BarrierType barrierType, boolean nullCheck, FrameState stateBefore) {
        super((NodeClass<? extends FloatableAccessNode>)c, address, location, stamp, guard, barrierType, nullCheck, stateBefore);
        this.lastLocationAccess = null;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind readKind = gen.getLIRGeneratorTool().getLIRKind(this.getAccessStamp(NodeView.DEFAULT));
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().getArithmetic().emitLoad(readKind, gen.operand(this.address), gen.state(this)));
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (!this.getNullCheck()) {
            return ReadNode.canonicalizeRead(this, this.getAddress(), this.getLocationIdentity(), tool);
        }
        return this;
    }

    @Override
    public FloatingAccessNode asFloatingNode() {
        try (DebugCloseable position = this.withNodeSourcePosition();){
            FloatingAccessNode floatingAccessNode = this.graph().unique(new FloatingReadNode(this.getAddress(), this.getLocationIdentity(), this.lastLocationAccess, this.stamp(NodeView.DEFAULT), this.getGuard(), this.getBarrierType()));
            return floatingAccessNode;
        }
    }

    @Override
    public boolean isAllowedUsageType(InputType type) {
        return this.getNullCheck() && type == InputType.Guard ? true : super.isAllowedUsageType(type);
    }

    public static ValueNode canonicalizeRead(ValueNode read, AddressNode address, LocationIdentity locationIdentity, CanonicalizerTool tool) {
        NodeView view = NodeView.from(tool);
        MetaAccessProvider metaAccess = tool.getMetaAccess();
        if (tool.canonicalizeReads() && address instanceof OffsetAddressNode) {
            ValueNode length;
            OffsetAddressNode objAddress = (OffsetAddressNode)address;
            ValueNode object = objAddress.getBase();
            if (metaAccess != null && object.isConstant() && !object.isNullConstant() && objAddress.getOffset().isConstant()) {
                long displacement = objAddress.getOffset().asJavaConstant().asLong();
                int stableDimension = ((ConstantNode)object).getStableDimension();
                if (locationIdentity.isImmutable() || stableDimension > 0) {
                    boolean isDefaultStable;
                    Constant constant = read.stamp(view).readConstant(tool.getConstantReflection().getMemoryAccessProvider(), object.asConstant(), displacement);
                    boolean bl = isDefaultStable = locationIdentity.isImmutable() || ((ConstantNode)object).isDefaultStable();
                    if (constant != null && (isDefaultStable || !constant.isDefaultForKind())) {
                        return ConstantNode.forConstant(read.stamp(view), constant, Math.max(stableDimension - 1, 0), isDefaultStable, metaAccess);
                    }
                }
            }
            if (locationIdentity.equals(NamedLocationIdentity.ARRAY_LENGTH_LOCATION) && (length = GraphUtil.arrayLength(object, ArrayLengthProvider.FindLengthMode.CANONICALIZE_READ, tool.getConstantReflection())) != null) {
                return length;
            }
            if (locationIdentity instanceof CanonicalizableLocation) {
                CanonicalizableLocation canonicalize = (CanonicalizableLocation)locationIdentity;
                ValueNode result = canonicalize.canonicalizeRead(read, address, object, tool);
                assert (result != null && result.stamp(view).isCompatible(read.stamp(view)));
                return result;
            }
        }
        return read;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        throw GraalError.shouldNotReachHere("unexpected ReadNode before PEA");
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.stamp(view);
    }
}

