/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;

public class LoopsData {
    private final EconomicMap<LoopBeginNode, LoopEx> loopBeginToEx;
    private final ControlFlowGraph cfg;
    private final List<LoopEx> loops;

    static LoopsData compute(StructuredGraph graph) {
        return new LoopsData(graph);
    }

    protected LoopsData(ControlFlowGraph cfg, List<LoopEx> loops, EconomicMap<LoopBeginNode, LoopEx> loopBeginToEx) {
        this.cfg = cfg;
        this.loops = loops;
        this.loopBeginToEx = loopBeginToEx;
    }

    protected LoopsData(StructuredGraph graph) {
        this.loopBeginToEx = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("ControlFlowGraph");){
            this.cfg = ControlFlowGraph.compute(graph, true, true, true, true);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        assert (LoopsData.checkLoopOrder(this.cfg.getLoops()));
        this.loops = new ArrayList<LoopEx>(this.cfg.getLoops().size());
        for (Loop loop : this.cfg.getLoops()) {
            LoopEx ex = new LoopEx(loop, this);
            this.loops.add(ex);
            this.loopBeginToEx.put((Object)ex.loopBegin(), (Object)ex);
        }
    }

    protected static boolean checkLoopOrder(Iterable<Loop<Block>> loops) {
        EconomicSet seen = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (Loop<Block> loop : loops) {
            if (loop.getParent() != null && !seen.contains(loop.getParent())) {
                return false;
            }
            seen.add(loop);
        }
        return true;
    }

    public LoopEx loop(Loop<Block> loop) {
        return (LoopEx)this.loopBeginToEx.get((Object)((LoopBeginNode)loop.getHeader().getBeginNode()));
    }

    public LoopEx loop(LoopBeginNode loopBegin) {
        return (LoopEx)this.loopBeginToEx.get((Object)loopBegin);
    }

    public List<LoopEx> loops() {
        return this.loops;
    }

    public List<LoopEx> outerFirst() {
        return this.loops;
    }

    public List<LoopEx> countedLoops() {
        ArrayList<LoopEx> counted = new ArrayList<LoopEx>();
        for (LoopEx loop : this.loops()) {
            if (!loop.isCounted()) continue;
            counted.add(loop);
        }
        return counted;
    }

    public void detectedCountedLoops() {
        for (LoopEx loop : this.loops()) {
            loop.detectCounted();
        }
    }

    public ControlFlowGraph getCFG() {
        return this.cfg;
    }

    public InductionVariable getInductionVariable(ValueNode value) {
        InductionVariable match = null;
        for (LoopEx loop : this.loops()) {
            InductionVariable iv = (InductionVariable)loop.getInductionVariables().get((Object)value);
            if (iv == null) continue;
            if (match != null) {
                return null;
            }
            match = iv;
        }
        return match;
    }

    public void deleteUnusedNodes() {
        for (LoopEx loop : this.loops()) {
            loop.deleteUnusedNodes();
        }
    }
}

