/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.loop.LoopEx;

public abstract class InductionVariable {
    protected final LoopEx loop;

    public abstract StructuredGraph graph();

    public InductionVariable(LoopEx loop) {
        this.loop = loop;
    }

    public LoopEx getLoop() {
        return this.loop;
    }

    public abstract Direction direction();

    public abstract ValueNode valueNode();

    public abstract ValueNode initNode();

    public abstract ValueNode strideNode();

    public abstract boolean isConstantInit();

    public abstract boolean isConstantStride();

    public abstract long constantInit();

    public abstract long constantStride();

    public ValueNode extremumNode() {
        return this.extremumNode(false, this.valueNode().stamp(NodeView.DEFAULT));
    }

    public abstract ValueNode extremumNode(boolean var1, Stamp var2);

    public abstract boolean isConstantExtremum();

    public abstract long constantExtremum();

    public abstract ValueNode exitValueNode();

    public abstract void deleteUnusedNodes();

    public boolean isConstantScale(InductionVariable ref) {
        return this == ref;
    }

    public long constantScale(InductionVariable ref) {
        assert (this == ref);
        return 1L;
    }

    public boolean offsetIsZero(InductionVariable ref) {
        return this == ref;
    }

    public ValueNode offsetNode(InductionVariable ref) {
        assert (!this.offsetIsZero(ref));
        return null;
    }

    public static enum Direction {
        Up,
        Down;


        public Direction opposite() {
            switch (this) {
                case Up: {
                    return Down;
                }
                case Down: {
                    return Up;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }
}

