/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.loop.DerivedInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;

public class DerivedConvertedInductionVariable
extends DerivedInductionVariable {
    protected final Stamp stamp;
    protected final ValueNode value;

    public DerivedConvertedInductionVariable(LoopEx loop, InductionVariable base, Stamp stamp, ValueNode value) {
        super(loop, base);
        this.stamp = stamp;
        this.value = value;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public InductionVariable.Direction direction() {
        return this.base.direction();
    }

    @Override
    public ValueNode initNode() {
        return this.op(this.base.initNode());
    }

    @Override
    public ValueNode strideNode() {
        return this.op(this.base.strideNode());
    }

    @Override
    public boolean isConstantInit() {
        return this.base.isConstantInit();
    }

    @Override
    public boolean isConstantStride() {
        return this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.base.constantInit();
    }

    @Override
    public long constantStride() {
        return this.base.constantStride();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp s) {
        return this.base.extremumNode(assumeLoopEntered, s);
    }

    @Override
    public ValueNode exitValueNode() {
        return this.op(this.base.exitValueNode());
    }

    @Override
    public boolean isConstantExtremum() {
        return this.base.isConstantExtremum();
    }

    @Override
    public long constantExtremum() {
        return this.base.constantExtremum();
    }

    @Override
    public void deleteUnusedNodes() {
    }

    public ValueNode op(ValueNode v) {
        return IntegerConvertNode.convert(v, this.stamp, this.graph(), NodeView.DEFAULT);
    }

    public String toString() {
        return String.format("DerivedConvertedInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.stamp);
    }

    @Override
    public InductionVariable copy(InductionVariable newBase, ValueNode newValue) {
        return new DerivedConvertedInductionVariable(this.loop, newBase, this.stamp, newValue);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase) {
        return this.op(newBase.valueNode());
    }
}

