/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.util.UnsignedLong;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.MathUtil;
import org.graalvm.compiler.nodes.util.IntegerHelper;
import org.graalvm.compiler.nodes.util.SignedIntegerHelper;
import org.graalvm.compiler.nodes.util.UnsignedIntegerHelper;

public class CountedLoopInfo {
    protected final LoopEx loop;
    protected InductionVariable iv;
    protected ValueNode end;
    protected boolean isLimitIncluded;
    protected AbstractBeginNode body;
    protected IfNode ifNode;
    protected final boolean unsigned;

    protected CountedLoopInfo(LoopEx loop, InductionVariable iv, IfNode ifNode, ValueNode end, boolean isLimitIncluded, AbstractBeginNode body, boolean unsigned) {
        assert (iv.direction() != null);
        this.loop = loop;
        this.iv = iv;
        this.end = end;
        this.isLimitIncluded = isLimitIncluded;
        this.body = body;
        this.ifNode = ifNode;
        this.unsigned = unsigned;
    }

    public ValueNode maxTripCountNode() {
        return this.maxTripCountNode(false);
    }

    public boolean isUnsignedCheck() {
        return this.unsigned;
    }

    public ValueNode maxTripCountNode(boolean assumeLoopEntered) {
        return this.maxTripCountNode(assumeLoopEntered, this.getCounterIntegerHelper());
    }

    protected ValueNode maxTripCountNode(boolean assumeLoopEntered, IntegerHelper integerHelper) {
        ValueNode min;
        ValueNode max;
        ValueNode absStride;
        StructuredGraph graph = this.iv.valueNode().graph();
        Stamp stamp = this.iv.valueNode().stamp(NodeView.DEFAULT);
        if (this.iv.direction() == InductionVariable.Direction.Up) {
            absStride = this.iv.strideNode();
            max = this.end;
            min = this.iv.initNode();
        } else {
            assert (this.iv.direction() == InductionVariable.Direction.Down);
            absStride = NegateNode.create(this.iv.strideNode(), NodeView.DEFAULT);
            max = this.iv.initNode();
            min = this.end;
        }
        ValueNode range = BinaryArithmeticNode.sub(max, min);
        ConstantNode one = ConstantNode.forIntegerStamp(stamp, 1L, graph);
        if (this.isLimitIncluded) {
            range = BinaryArithmeticNode.add(range, one);
        }
        ValueNode denominator = BinaryArithmeticNode.add(graph, range, BinaryArithmeticNode.sub(absStride, one), NodeView.DEFAULT);
        ValueNode div = MathUtil.unsignedDivBefore(graph, this.loop.entryPoint(), denominator, absStride, null);
        if (assumeLoopEntered) {
            return graph.addOrUniqueWithInputs(div);
        }
        ConstantNode zero = ConstantNode.forIntegerStamp(stamp, 0L, graph);
        LogicNode noEntryCheck = integerHelper.createCompareNode(max, min, NodeView.DEFAULT);
        return graph.addOrUniqueWithInputs(ConditionalNode.create(noEntryCheck, zero, div, NodeView.DEFAULT));
    }

    public boolean loopMightBeEntered() {
        LogicNode entryCheck;
        ValueNode min;
        ValueNode max;
        Stamp stamp = this.iv.valueNode().stamp(NodeView.DEFAULT);
        if (this.iv.direction() == InductionVariable.Direction.Up) {
            max = this.end;
            min = this.iv.initNode();
        } else {
            assert (this.iv.direction() == InductionVariable.Direction.Down);
            max = this.iv.initNode();
            min = this.end;
        }
        if (this.isLimitIncluded) {
            StructuredGraph graph = this.iv.valueNode().graph();
            max = BinaryArithmeticNode.add(max, ConstantNode.forIntegerStamp(stamp, 1L, graph), NodeView.DEFAULT);
        }
        return !(entryCheck = this.getCounterIntegerHelper().createCompareNode(min, max, NodeView.DEFAULT)).isContradiction();
    }

    public IfNode getCountCheck() {
        return this.ifNode;
    }

    public boolean isConstantMaxTripCount() {
        return this.end instanceof ConstantNode && this.iv.isConstantInit() && this.iv.isConstantStride();
    }

    public UnsignedLong constantMaxTripCount() {
        assert (this.isConstantMaxTripCount());
        return new UnsignedLong(this.rawConstantMaxTripCount());
    }

    private long rawConstantMaxTripCount() {
        long absStride;
        long range;
        assert (this.iv.direction() != null);
        long endValue = this.end.asJavaConstant().asLong();
        long initValue = this.iv.constantInit();
        IntegerHelper helper = this.getCounterIntegerHelper(64);
        if (this.iv.direction() == InductionVariable.Direction.Up) {
            if (helper.compare(endValue, initValue) < 0) {
                return 0L;
            }
            range = endValue - this.iv.constantInit();
            absStride = this.iv.constantStride();
        } else {
            assert (this.iv.direction() == InductionVariable.Direction.Down);
            if (helper.compare(initValue, endValue) < 0) {
                return 0L;
            }
            range = this.iv.constantInit() - endValue;
            absStride = -this.iv.constantStride();
        }
        if (this.isLimitIncluded) {
            ++range;
        }
        long denominator = range + absStride - 1L;
        return Long.divideUnsigned(denominator, absStride);
    }

    public IntegerHelper getCounterIntegerHelper() {
        IntegerStamp stamp = (IntegerStamp)this.iv.valueNode().stamp(NodeView.DEFAULT);
        return this.getCounterIntegerHelper(stamp.getBits());
    }

    public IntegerHelper getCounterIntegerHelper(int bits) {
        IntegerHelper helper = this.isUnsignedCheck() ? new UnsignedIntegerHelper(bits) : new SignedIntegerHelper(bits);
        return helper;
    }

    public boolean isExactTripCount() {
        return this.loop.loop().getNaturalExits().size() == 1;
    }

    public ValueNode exactTripCountNode() {
        assert (this.isExactTripCount());
        return this.maxTripCountNode();
    }

    public boolean isConstantExactTripCount() {
        assert (this.isExactTripCount());
        return this.isConstantMaxTripCount();
    }

    public UnsignedLong constantExactTripCount() {
        assert (this.isExactTripCount());
        return this.constantMaxTripCount();
    }

    public String toString() {
        return "iv=" + this.iv + " until " + this.end + (this.isLimitIncluded ? (this.iv.direction() == InductionVariable.Direction.Up ? "+1" : "-1") : "");
    }

    public ValueNode getLimit() {
        return this.end;
    }

    public IfNode getLimitTest() {
        return this.ifNode;
    }

    public ValueNode getStart() {
        return this.iv.initNode();
    }

    public boolean isLimitIncluded() {
        return this.isLimitIncluded;
    }

    public AbstractBeginNode getBody() {
        return this.body;
    }

    public AbstractBeginNode getCountedExit() {
        if (this.getLimitTest().trueSuccessor() == this.getBody()) {
            return this.getLimitTest().falseSuccessor();
        }
        assert (this.getLimitTest().falseSuccessor() == this.getBody());
        return this.getLimitTest().trueSuccessor();
    }

    public InductionVariable.Direction getDirection() {
        return this.iv.direction();
    }

    public InductionVariable getCounter() {
        return this.iv;
    }

    public GuardingNode getOverFlowGuard() {
        return this.loop.loopBegin().getOverflowGuard();
    }

    public boolean counterNeverOverflows() {
        if (this.loop.loopBegin().canNeverOverflow()) {
            return true;
        }
        if (!this.isLimitIncluded && this.iv.isConstantStride() && Math.abs(this.iv.constantStride()) == 1L) {
            return true;
        }
        IntegerStamp endStamp = (IntegerStamp)this.end.stamp(NodeView.DEFAULT);
        ValueNode strideNode = this.iv.strideNode();
        IntegerStamp strideStamp = (IntegerStamp)strideNode.stamp(NodeView.DEFAULT);
        IntegerHelper integerHelper = this.getCounterIntegerHelper();
        if (this.getDirection() == InductionVariable.Direction.Up) {
            long max = integerHelper.maxValue();
            return integerHelper.compare(endStamp.upperBound(), max - (strideStamp.upperBound() - 1L) - (long)(this.isLimitIncluded ? 1 : 0)) <= 0;
        }
        if (this.getDirection() == InductionVariable.Direction.Down) {
            long min = integerHelper.minValue();
            return integerHelper.compare(min + (1L - strideStamp.lowerBound()) + (long)(this.isLimitIncluded ? 1 : 0), endStamp.lowerBound()) <= 0;
        }
        return false;
    }

    public GuardingNode createOverFlowGuard() {
        GuardingNode overflowGuard = this.getOverFlowGuard();
        if (overflowGuard != null || this.counterNeverOverflows()) {
            return overflowGuard;
        }
        try (DebugCloseable position = this.loop.loopBegin().withNodeSourcePosition();){
            LogicNode cond;
            ValueNode v1;
            IntegerStamp stamp = (IntegerStamp)this.iv.valueNode().stamp(NodeView.DEFAULT);
            IntegerHelper integerHelper = this.getCounterIntegerHelper();
            StructuredGraph graph = this.iv.valueNode().graph();
            ConstantNode one = ConstantNode.forIntegerStamp(stamp, 1L, graph);
            if (this.iv.direction() == InductionVariable.Direction.Up) {
                v1 = BinaryArithmeticNode.sub(ConstantNode.forIntegerStamp(stamp, integerHelper.maxValue()), BinaryArithmeticNode.sub(this.iv.strideNode(), one));
                if (this.isLimitIncluded) {
                    v1 = BinaryArithmeticNode.sub(v1, one);
                }
                cond = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(v1, this.end, NodeView.DEFAULT));
            } else {
                assert (this.iv.direction() == InductionVariable.Direction.Down);
                v1 = BinaryArithmeticNode.add(ConstantNode.forIntegerStamp(stamp, integerHelper.minValue()), BinaryArithmeticNode.sub(one, this.iv.strideNode()));
                if (this.isLimitIncluded) {
                    v1 = BinaryArithmeticNode.add(v1, one);
                }
                cond = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(this.end, v1, NodeView.DEFAULT));
            }
            assert (graph.getGuardsStage().allowsFloatingGuards());
            SpeculationLog speculationLog = graph.getSpeculationLog();
            SpeculationLog.Speculation speculation = SpeculationLog.NO_SPECULATION;
            if (speculationLog != null) {
                SpeculationLog.SpeculationReason speculationReason = LoopBeginNode.LOOP_OVERFLOW_DEOPT.createSpeculationReason(graph.method(), this.iv.loop.loopBegin().stateAfter().bci);
                if (speculationLog.maySpeculate(speculationReason)) {
                    speculation = speculationLog.speculate(speculationReason);
                    LoopBeginNode.overflowSpeculationTaken.increment(graph.getDebug());
                } else {
                    GraalError.shouldNotReachHere("Must not create overflow guard for loop " + this.loop.loopBegin() + " where the speculation guard already failed, this can create deopt loops");
                }
            }
            overflowGuard = graph.unique(new GuardNode(cond, AbstractBeginNode.prevBegin(this.loop.entryPoint()), DeoptimizationReason.LoopLimitCheck, DeoptimizationAction.InvalidateRecompile, true, speculation, null));
            this.loop.loopBegin().setOverflowGuard(overflowGuard);
            GuardingNode guardingNode = overflowGuard;
            return guardingNode;
        }
    }

    public IntegerStamp getStamp() {
        return (IntegerStamp)this.iv.valueNode().stamp(NodeView.DEFAULT);
    }

    public boolean isInverted() {
        return false;
    }
}

