/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.spi.UncheckedInterfaceProvider;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo
public class MethodCallTargetNode
extends CallTargetNode
implements IterableNodeType,
Simplifiable {
    public static final NodeClass<MethodCallTargetNode> TYPE = NodeClass.create(MethodCallTargetNode.class);
    protected JavaTypeProfile profile;

    public MethodCallTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, JavaTypeProfile profile) {
        this(TYPE, invokeKind, targetMethod, arguments, returnStamp, profile);
    }

    protected MethodCallTargetNode(NodeClass<? extends MethodCallTargetNode> c, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, JavaTypeProfile profile) {
        super(c, arguments, targetMethod, invokeKind, returnStamp);
        this.profile = profile;
    }

    public ValueNode receiver() {
        return this.isStatic() ? null : (ValueNode)this.arguments().get(0);
    }

    public boolean isStatic() {
        return this.invokeKind() == CallTargetNode.InvokeKind.Static;
    }

    public JavaKind returnKind() {
        return this.targetMethod().getSignature().getReturnKind();
    }

    @Override
    public boolean verify() {
        assert (this.getUsageCount() <= 1) : "call target may only be used by a single invoke";
        for (Node n : this.usages()) {
            this.assertTrue(n instanceof Invoke, "call target can only be used from an invoke (%s)", n);
        }
        if (this.invokeKind().isDirect()) {
            this.assertTrue(this.targetMethod().isConcrete(), "special calls or static calls are only allowed for concrete methods (%s)", this.targetMethod());
        }
        if (this.invokeKind() == CallTargetNode.InvokeKind.Static) {
            this.assertTrue(this.targetMethod().isStatic(), "static calls are only allowed for static methods (%s)", this.targetMethod());
        } else {
            this.assertFalse(this.targetMethod().isStatic(), "static calls are only allowed for non-static methods (%s)", this.targetMethod());
        }
        return super.verify();
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Long) {
            return super.toString(Verbosity.Short) + "(" + this.targetMethod() + ")";
        }
        return super.toString(verbosity);
    }

    public static ResolvedJavaMethod findSpecialCallTarget(CallTargetNode.InvokeKind invokeKind, ValueNode receiver, ResolvedJavaMethod targetMethod, ResolvedJavaType contextType) {
        if (invokeKind.isDirect()) {
            return null;
        }
        if (targetMethod.canBeStaticallyBound()) {
            return targetMethod;
        }
        return MethodCallTargetNode.devirtualizeCall(invokeKind, targetMethod, contextType, receiver.graph().getAssumptions(), receiver.stamp(NodeView.DEFAULT));
    }

    public static ResolvedJavaMethod devirtualizeCall(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ResolvedJavaType contextType, Assumptions assumptions, Stamp receiverStamp) {
        TypeReference type = StampTool.typeReferenceOrNull(receiverStamp);
        if (type == null && invokeKind == CallTargetNode.InvokeKind.Virtual) {
            type = TypeReference.createTrusted(assumptions, targetMethod.getDeclaringClass());
        }
        if (type != null) {
            ResolvedJavaMethod resolvedMethod = type.getType().resolveConcreteMethod(targetMethod, contextType);
            if (resolvedMethod != null && (resolvedMethod.canBeStaticallyBound() || type.isExact() || type.getType().isArray())) {
                return resolvedMethod;
            }
            Assumptions.AssumptionResult uniqueConcreteMethod = type.getType().findUniqueConcreteMethod(targetMethod);
            if (uniqueConcreteMethod != null && uniqueConcreteMethod.canRecordTo(assumptions)) {
                uniqueConcreteMethod.recordTo(assumptions);
                return (ResolvedJavaMethod)uniqueConcreteMethod.getResult();
            }
        }
        return null;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.invoke().getContextMethod() == null) {
            assert (this.invoke().stateAfter() != null && BytecodeFrame.isPlaceholderBci((int)this.invoke().stateAfter().bci) || BytecodeFrame.isPlaceholderBci((int)this.invoke().stateDuring().bci));
            return;
        }
        ResolvedJavaType contextType = this.invoke().stateAfter() == null && this.invoke().stateDuring() == null ? null : this.invoke().getContextType();
        ResolvedJavaMethod specialCallTarget = MethodCallTargetNode.findSpecialCallTarget(this.invokeKind, this.receiver(), this.targetMethod, contextType);
        if (specialCallTarget != null) {
            this.setTargetMethod(specialCallTarget);
            this.setInvokeKind(CallTargetNode.InvokeKind.Special);
            return;
        }
        if (this.invokeKind.isInterface()) {
            MethodCallTargetNode result = MethodCallTargetNode.tryDevirtualizeInterfaceCall(this.receiver(), this.targetMethod, this.profile, this.graph().getAssumptions(), contextType, this, this.invoke().asNode());
            assert (result == this);
        }
    }

    public static MethodCallTargetNode tryDevirtualizeInterfaceCall(ValueNode receiver, ResolvedJavaMethod targetMethod, JavaTypeProfile profile, Assumptions assumptions, ResolvedJavaType contextType, MethodCallTargetNode callTarget, FixedNode insertionPoint) {
        MethodCallTargetNode callTargetResult;
        TypeReference speculatedType;
        UncheckedInterfaceProvider uncheckedInterfaceProvider;
        Stamp uncheckedStamp;
        TypeReference speculatedType2;
        MethodCallTargetNode callTargetResult2;
        ResolvedJavaType singleImplementor;
        if (assumptions == null) {
            return callTarget;
        }
        ResolvedJavaType referencedReceiverType = callTarget.referencedType();
        if (referencedReceiverType == null) {
            return callTarget;
        }
        ResolvedJavaType declaredReceiverType = targetMethod.getDeclaringClass();
        if (declaredReceiverType.isInterface() && (singleImplementor = referencedReceiverType.getSingleImplementor()) != null && !singleImplementor.equals(declaredReceiverType) && (callTargetResult2 = MethodCallTargetNode.tryCheckCastSingleImplementor(receiver, targetMethod, profile, contextType, speculatedType2 = TypeReference.createTrusted(assumptions, singleImplementor), insertionPoint, callTarget)) != null) {
            return callTargetResult2;
        }
        if (receiver instanceof UncheckedInterfaceProvider && (uncheckedStamp = (uncheckedInterfaceProvider = (UncheckedInterfaceProvider)((Object)receiver)).uncheckedStamp()) != null && (speculatedType = StampTool.typeReferenceOrNull(uncheckedStamp)) != null && referencedReceiverType.isAssignableFrom(speculatedType.getType()) && (callTargetResult = MethodCallTargetNode.tryCheckCastSingleImplementor(receiver, targetMethod, profile, contextType, speculatedType, insertionPoint, callTarget)) != null) {
            return callTargetResult;
        }
        return callTarget;
    }

    private static MethodCallTargetNode tryCheckCastSingleImplementor(ValueNode receiver, ResolvedJavaMethod targetMethod, JavaTypeProfile profile, ResolvedJavaType contextType, TypeReference speculatedType, FixedNode insertionPoint, MethodCallTargetNode callTarget) {
        ResolvedJavaMethod singleImplementorMethod;
        ResolvedJavaType singleImplementor = speculatedType.getType();
        if (singleImplementor != null && (singleImplementorMethod = singleImplementor.resolveConcreteMethod(targetMethod, contextType)) != null) {
            StructuredGraph graph = insertionPoint.graph();
            AbstractBeginNode anchor = BeginNode.prevBegin(insertionPoint);
            LogicNode condition = graph.addOrUniqueWithInputs(InstanceOfNode.create(speculatedType, receiver, profile, anchor));
            FixedGuardNode guard = graph.add(new FixedGuardNode(condition, DeoptimizationReason.OptimizedTypeCheckViolated, DeoptimizationAction.InvalidateRecompile, false));
            graph.addBeforeFixed(insertionPoint, guard);
            CallTargetNode.InvokeKind invokeKind = speculatedType.isExact() ? CallTargetNode.InvokeKind.Special : CallTargetNode.InvokeKind.Virtual;
            MethodCallTargetNode callTargetResult = callTarget;
            ValueNode valueNode = graph.addOrUnique(new PiNode(receiver, (Stamp)StampFactory.objectNonNull(speculatedType), guard));
            if (callTarget.isAlive()) {
                callTarget.arguments().set(0, (Object)valueNode);
                callTargetResult.setInvokeKind(invokeKind);
                callTargetResult.setTargetMethod(singleImplementorMethod);
            } else {
                ValueNode[] arguments = callTarget.arguments().toArray((A[])new ValueNode[callTarget.arguments().size()]);
                arguments[0] = valueNode;
                callTargetResult = new MethodCallTargetNode(invokeKind, singleImplementorMethod, arguments, callTarget.returnStamp, profile);
            }
            return callTargetResult;
        }
        return null;
    }

    public JavaTypeProfile getProfile() {
        return this.profile;
    }

    @Override
    public String targetName() {
        if (this.targetMethod() == null) {
            return "??Invalid!";
        }
        return this.targetMethod().format("%h.%n");
    }

    public static MethodCallTargetNode find(StructuredGraph graph, ResolvedJavaMethod method) {
        for (MethodCallTargetNode target : graph.getNodes(TYPE)) {
            if (!target.targetMethod().equals(method)) continue;
            return target;
        }
        return null;
    }

    public void setJavaTypeProfile(JavaTypeProfile profile) {
        this.profile = profile;
    }
}

