/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DynamicPiNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.PluginReplacementNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContextUtil;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.type.StampTool;

public interface GraphBuilderContext
extends GraphBuilderTool {
    public void push(JavaKind var1, ValueNode var2);

    default public ValueNode pop(JavaKind slotKind) {
        throw GraalError.unimplemented();
    }

    default public <T extends ValueNode> T add(T value) {
        if (value.graph() != null) {
            if (!1.$assertionsDisabled && value instanceof StateSplit && ((StateSplit)((Object)value)).stateAfter() == null) {
                throw new AssertionError();
            }
            return value;
        }
        return GraphBuilderContextUtil.setStateAfterIfNecessary(this, this.append(value));
    }

    default public ValueNode addNonNullCast(ValueNode value) {
        AbstractPointerStamp valueStamp = (AbstractPointerStamp)value.stamp(NodeView.DEFAULT);
        if (valueStamp.nonNull()) {
            return value;
        }
        LogicNode isNull = this.add(IsNullNode.create(value));
        FixedGuardNode fixedGuard = this.add(new FixedGuardNode(isNull, DeoptimizationReason.NullCheckException, DeoptimizationAction.None, true));
        Stamp newStamp = valueStamp.improveWith(StampFactory.objectNonNull());
        return this.add(PiNode.create(value, newStamp, fixedGuard));
    }

    default public <T extends ValueNode> T addPush(JavaKind kind, T value) {
        T equivalentValue = value.graph() != null ? value : this.append(value);
        this.push(kind, equivalentValue);
        return GraphBuilderContextUtil.setStateAfterIfNecessary(this, equivalentValue);
    }

    public Invoke handleReplacedInvoke(CallTargetNode.InvokeKind var1, ResolvedJavaMethod var2, ValueNode[] var3, boolean var4);

    public void handleReplacedInvoke(CallTargetNode var1, JavaKind var2);

    public boolean intrinsify(BytecodeProvider var1, ResolvedJavaMethod var2, ResolvedJavaMethod var3, InvocationPlugin.Receiver var4, ValueNode[] var5);

    public boolean intrinsify(ResolvedJavaMethod var1, StructuredGraph var2, InvocationPlugin.Receiver var3, ValueNode[] var4);

    public void setStateAfter(StateSplit var1);

    public GraphBuilderContext getParent();

    default public GraphBuilderContext getNonIntrinsicAncestor() {
        GraphBuilderContext ancestor;
        for (ancestor = this.getParent(); ancestor != null && ancestor.parsingIntrinsic(); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public Bytecode getCode();

    public ResolvedJavaMethod getMethod();

    public int bci();

    default public boolean bciCanBeDuplicated() {
        return false;
    }

    public CallTargetNode.InvokeKind getInvokeKind();

    public JavaType getInvokeReturnType();

    default public StampPair getInvokeReturnStamp(Assumptions assumptions) {
        JavaType returnType = this.getInvokeReturnType();
        return StampFactory.forDeclaredType(assumptions, returnType, false);
    }

    default public int getDepth() {
        int result = 0;
        for (GraphBuilderContext parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ++result;
        }
        return result;
    }

    default public List<Pair<ResolvedJavaMethod, Integer>> getCallingContext() {
        ArrayList<Pair<ResolvedJavaMethod, Integer>> callingContext = new ArrayList<Pair<ResolvedJavaMethod, Integer>>();
        for (GraphBuilderContext cur = this; cur != null; cur = cur.getParent()) {
            callingContext.add((Pair<ResolvedJavaMethod, Integer>)Pair.create((Object)cur.getMethod(), (Object)cur.bci()));
        }
        return callingContext;
    }

    @Override
    default public boolean parsingIntrinsic() {
        return this.getIntrinsic() != null;
    }

    default public boolean isPluginEnabled(GraphBuilderPlugin plugin) {
        return this.parsingIntrinsic() || !(plugin instanceof GeneratedInvocationPlugin) || !((GeneratedInvocationPlugin)plugin).isGeneratedFromFoldOrNodeIntrinsic();
    }

    public IntrinsicContext getIntrinsic();

    public BailoutException bailout(String var1);

    default public ValueNode nullCheckedValue(ValueNode value) {
        return this.nullCheckedValue(value, DeoptimizationAction.InvalidateReprofile);
    }

    default public ValueNode nullCheckedValue(ValueNode value, DeoptimizationAction action) {
        if (!StampTool.isPointerNonNull(value)) {
            LogicNode condition = this.getGraph().unique(IsNullNode.create(value));
            GuardingNode guardingNode = this.needsExplicitException() ? this.emitBytecodeExceptionCheck(condition, false, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ValueNode[0]) : (GuardingNode)this.append(new FixedGuardNode(condition, DeoptimizationReason.NullCheckException, action, true));
            return this.getGraph().addOrUniqueWithInputs(PiNode.create(value, StampFactory.objectNonNull(), guardingNode.asNode()));
        }
        return value;
    }

    default public AbstractBeginNode emitBytecodeExceptionCheck(LogicNode condition, boolean passingOnTrue, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        if (passingOnTrue ? condition.isTautology() : condition.isContradiction()) {
            return null;
        }
        AbstractBeginNode exceptionPath = this.genExplicitExceptionEdge(exceptionKind, arguments);
        AbstractBeginNode trueSuccessor = passingOnTrue ? null : exceptionPath;
        AbstractBeginNode falseSuccessor = passingOnTrue ? exceptionPath : null;
        boolean negate = !passingOnTrue;
        ProfileData.BranchProbabilityData probability = ProfileData.BranchProbabilityData.injected(0.999999, negate);
        IfNode ifNode = this.append(new IfNode(condition, trueSuccessor, falseSuccessor, probability));
        BeginNode passingSuccessor = this.append(new BeginNode());
        if (passingOnTrue) {
            ifNode.setTrueSuccessor(passingSuccessor);
        } else {
            ifNode.setFalseSuccessor(passingSuccessor);
        }
        return passingSuccessor;
    }

    default public void genCheckcastDynamic(ValueNode object, ValueNode javaClass) {
        LogicNode condition = InstanceOfDynamicNode.create(this.getAssumptions(), this.getConstantReflection(), javaClass, object, true);
        if (condition.isTautology()) {
            this.addPush(JavaKind.Object, object);
        } else {
            this.append(condition);
            GuardingNode guardingNode = this.needsExplicitException() ? this.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, object, javaClass) : (GuardingNode)this.add(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.InvalidateReprofile, false));
            this.addPush(JavaKind.Object, DynamicPiNode.create(this.getAssumptions(), this.getConstantReflection(), object, guardingNode, javaClass));
        }
    }

    default public ExternalInliningContext getExternalInliningContext() {
        return null;
    }

    default public ValueNode maskSubWordValue(ValueNode value, JavaKind kind) {
        if (kind == kind.getStackKind()) {
            return value;
        }
        ValueNode narrow = this.append(NarrowNode.create(value, kind.getBitCount(), NodeView.DEFAULT));
        if (kind.isUnsigned()) {
            return this.append(ZeroExtendNode.create(narrow, 32, NodeView.DEFAULT));
        }
        return this.append(SignExtendNode.create(narrow, 32, NodeView.DEFAULT));
    }

    default public boolean needsExplicitException() {
        return false;
    }

    default public AbstractBeginNode genExplicitExceptionEdge(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... exceptionArguments) {
        throw GraalError.unimplemented();
    }

    default public void replacePlugin(GeneratedInvocationPlugin plugin, ResolvedJavaMethod targetMethod, ValueNode[] args, PluginReplacementNode.ReplacementFunction replacementFunction) {
        throw GraalError.unimplemented();
    }

    default public void processInstruction(FixedWithNextNode instr) {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface ExternalInliningContext {
        public int getInlinedDepth();
    }
}

