/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import java.nio.ByteOrder;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public abstract class UnsafeAccessNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<UnsafeAccessNode> TYPE = NodeClass.create(UnsafeAccessNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;
    protected final JavaKind accessKind;
    protected final LocationIdentity locationIdentity;
    protected final boolean forceLocation;

    public abstract boolean isVolatile();

    protected UnsafeAccessNode(NodeClass<? extends UnsafeAccessNode> c, Stamp stamp, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        this.forceLocation = forceLocation;
        assert (accessKind != null);
        assert (locationIdentity != null);
        this.object = object;
        this.offset = offset;
        this.accessKind = accessKind;
        this.locationIdentity = locationIdentity;
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    public boolean isLocationForced() {
        return this.forceLocation;
    }

    public ValueNode object() {
        return this.object;
    }

    public ValueNode offset() {
        return this.offset;
    }

    public JavaKind accessKind() {
        return this.accessKind;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!this.isLocationForced()) {
            ResolvedJavaType receiverType;
            if (this.offset().isConstant()) {
                long constantOffset = this.offset().asJavaConstant().asLong();
                ResolvedJavaType receiverType2 = StampTool.typeOrNull(this.object());
                if (receiverType2 != null) {
                    ResolvedJavaField field = this.getStaticFieldUnsafeAccess(tool.getConstantReflection());
                    if (field == null) {
                        field = receiverType2.findInstanceFieldWithOffset(constantOffset, this.accessKind());
                    }
                    if (field != null && field.getJavaKind() == this.accessKind() && !field.isInternal()) {
                        assert (!this.graph().isAfterFloatingReadPhase()) : "cannot add more precise memory location after floating read phase";
                        return this.cloneAsFieldAccess(this.graph().getAssumptions(), field, this.isVolatile());
                    }
                }
            }
            if (this.getLocationIdentity().isAny() && (receiverType = StampTool.typeOrNull(this.object())) != null && receiverType.isArray()) {
                LocationIdentity identity = NamedLocationIdentity.getArrayLocation(receiverType.getComponentType().getJavaKind());
                assert (!this.graph().isAfterFloatingReadPhase()) : "cannot add more precise memory location after floating read phase";
                return this.cloneAsArrayAccess(this.offset(), identity, this.isVolatile());
            }
        }
        return this;
    }

    protected ValueNode cloneAsFieldAccess(Assumptions assumptions, ResolvedJavaField field) {
        return this.cloneAsFieldAccess(assumptions, field, field.isVolatile());
    }

    protected abstract ValueNode cloneAsFieldAccess(Assumptions var1, ResolvedJavaField var2, boolean var3);

    protected abstract ValueNode cloneAsArrayAccess(ValueNode var1, LocationIdentity var2, boolean var3);

    private ResolvedJavaField getStaticFieldUnsafeAccess(ConstantReflectionProvider constantReflection) {
        if (!this.object().isJavaConstant() || !this.offset().isJavaConstant() || this.object().isNullConstant() || this.offset().isNullConstant()) {
            return null;
        }
        JavaConstant objectConstant = this.object().asJavaConstant();
        JavaConstant offsetConstant = this.offset().asJavaConstant();
        assert (objectConstant != null && offsetConstant != null) : "Verified by the check at the beginning.";
        ResolvedJavaType staticReceiverType = constantReflection.asJavaType((Constant)objectConstant);
        if (staticReceiverType == null) {
            return null;
        }
        return UnsafeAccessNode.findStaticFieldWithOffset(staticReceiverType, offsetConstant.asLong(), this.accessKind);
    }

    private static ResolvedJavaField findStaticFieldWithOffset(ResolvedJavaType type, long offset, JavaKind expectedEntryKind) {
        try {
            ResolvedJavaField[] declaredFields = type.getStaticFields();
            return UnsafeAccessNode.findFieldWithOffset(offset, expectedEntryKind, declaredFields);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    private static ResolvedJavaField findFieldWithOffset(long offset, JavaKind expectedEntryKind, ResolvedJavaField[] declaredFields) {
        for (ResolvedJavaField field : declaredFields) {
            long resolvedFieldOffset = field.getOffset();
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN && expectedEntryKind.isPrimitive() && !expectedEntryKind.equals((Object)JavaKind.Void) && field.getJavaKind().isPrimitive()) {
                resolvedFieldOffset += (long)(field.getJavaKind().getByteCount() - Math.min(field.getJavaKind().getByteCount(), 4 + expectedEntryKind.getByteCount()));
            }
            if (resolvedFieldOffset != offset) continue;
            return field;
        }
        return null;
    }
}

