/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.extended.RawVolatileLoadNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class RawLoadNode
extends UnsafeAccessNode
implements Lowerable,
Virtualizable,
Canonicalizable {
    public static final NodeClass<RawLoadNode> TYPE = NodeClass.create(RawLoadNode.class);

    public RawLoadNode(ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity) {
        this(object, offset, accessKind, locationIdentity, false);
    }

    public RawLoadNode(ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation) {
        super(TYPE, StampFactory.forKind(accessKind.getStackKind()), object, offset, accessKind, locationIdentity, forceLocation);
    }

    public RawLoadNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode object, ValueNode offset, LocationIdentity locationIdentity, JavaKind accessKind) {
        super(TYPE, stamp, object, offset, accessKind, locationIdentity, false);
    }

    static Stamp computeStampForArrayAccess(ValueNode object, JavaKind accessKind, Stamp oldStamp) {
        TypeReference type = StampTool.typeReferenceOrNull(object);
        if (accessKind.isObject() && type != null && type.getType().isArray()) {
            TypeReference oldType = StampTool.typeReferenceOrNull(oldStamp);
            TypeReference componentType = TypeReference.create(object.graph().getAssumptions(), type.getType().getComponentType());
            if (oldType == null || oldType.getType().isAssignableFrom(componentType.getType())) {
                return StampFactory.object(componentType);
            }
        }
        if (oldStamp != null) {
            return oldStamp;
        }
        return StampFactory.forKind(accessKind);
    }

    protected RawLoadNode(NodeClass<? extends RawLoadNode> c, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity) {
        this(c, object, offset, accessKind, locationIdentity, false);
    }

    protected RawLoadNode(NodeClass<? extends RawLoadNode> c, ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, boolean forceLocation) {
        super(c, RawLoadNode.computeStampForArrayAccess(object, accessKind, null), object, offset, accessKind, locationIdentity, forceLocation);
    }

    @Override
    public boolean inferStamp() {
        if (this.accessKind.isObject()) {
            return this.updateStamp(RawLoadNode.computeStampForArrayAccess(this.object, this.accessKind, this.stamp));
        }
        return false;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            ValueNode offsetValue = tool.getAlias(this.offset());
            if (offsetValue.isConstant()) {
                long off = offsetValue.asJavaConstant().asLong();
                int entryIndex = virtual.entryIndexForOffset(tool.getMetaAccess(), off, this.accessKind());
                if (entryIndex != -1) {
                    ValueNode entry = tool.getEntry(virtual, entryIndex);
                    JavaKind entryKind = virtual.entryKind(tool.getMetaAccessExtensionProvider(), entryIndex);
                    if (virtual.isVirtualByteArrayAccess(tool.getMetaAccessExtensionProvider(), this.accessKind())) {
                        if (virtual.canVirtualizeLargeByteArrayUnsafeRead(entry, entryIndex, this.accessKind(), tool)) {
                            tool.replaceWith(VirtualArrayNode.virtualizeByteArrayRead(entry, this.accessKind(), this.stamp));
                        }
                    } else if (entry.getStackKind() == this.getStackKind() || entryKind == this.accessKind()) {
                        if (!entry.stamp(NodeView.DEFAULT).isCompatible(this.stamp(NodeView.DEFAULT))) {
                            if (entry.stamp(NodeView.DEFAULT) instanceof PrimitiveStamp && this.stamp instanceof PrimitiveStamp) {
                                int width2;
                                PrimitiveStamp p1 = (PrimitiveStamp)this.stamp;
                                PrimitiveStamp p2 = (PrimitiveStamp)entry.stamp(NodeView.DEFAULT);
                                int width1 = p1.getBits();
                                if (width1 == (width2 = p2.getBits())) {
                                    ValueNode replacement = ReinterpretNode.create(p2, entry, NodeView.DEFAULT);
                                    tool.replaceWith(replacement);
                                    return;
                                }
                                return;
                            }
                            return;
                        }
                        tool.replaceWith(entry);
                    }
                }
            }
        }
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!this.isLocationForced()) {
            int stableDimension;
            JavaConstant arrayConstant;
            ConstantNode objectConstant;
            ResolvedJavaType type;
            ValueNode targetObject = this.object();
            if (this.offset().isConstant() && targetObject.isConstant() && !targetObject.isNullConstant() && (type = StampTool.typeOrNull(objectConstant = (ConstantNode)targetObject)) != null && type.isArray() && (arrayConstant = objectConstant.asJavaConstant()) != null && (stableDimension = objectConstant.getStableDimension()) > 0) {
                NodeView view = NodeView.from(tool);
                long constantOffset = this.offset().asJavaConstant().asLong();
                Constant constant = this.stamp(view).readConstant(tool.getConstantReflection().getMemoryAccessProvider(), (Constant)arrayConstant, constantOffset);
                boolean isDefaultStable = objectConstant.isDefaultStable();
                if (constant != null && (isDefaultStable || !constant.isDefaultForKind())) {
                    return ConstantNode.forConstant(this.stamp(view), constant, stableDimension - 1, isDefaultStable, tool.getMetaAccess());
                }
            }
        }
        return super.canonical(tool);
    }

    @Override
    protected ValueNode cloneAsFieldAccess(Assumptions assumptions, ResolvedJavaField field, boolean volatileAccess) {
        return LoadFieldNode.create(assumptions, field.isStatic() ? null : this.object(), field, volatileAccess);
    }

    @Override
    protected ValueNode cloneAsArrayAccess(ValueNode location, LocationIdentity identity, boolean volatileAccess) {
        if (volatileAccess) {
            return new RawVolatileLoadNode(this.object(), location, this.accessKind(), identity);
        }
        return new RawLoadNode(this.object(), location, this.accessKind(), identity);
    }

    @Node.NodeIntrinsic
    public static native Object load(Object var0, long var1, @Node.ConstantNodeParameter JavaKind var3, @Node.ConstantNodeParameter LocationIdentity var4);
}

