/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import java.util.ArrayList;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class MultiGuardNode
extends FloatingNode
implements GuardingNode,
LIRLowerable,
Simplifiable,
Canonicalizable,
Node.ValueNumberable {
    public static final NodeClass<MultiGuardNode> TYPE = NodeClass.create(MultiGuardNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    NodeInputList<ValueNode> guards;

    public MultiGuardNode(ValueNode ... guards) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forVoid());
        this.guards = new NodeInputList((Node)this, (Node[])guards);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        this.guards.trim();
        if (this.guards.size() == 0) {
            return null;
        }
        if (this.guards.size() == 1) {
            return this.guards.get(0);
        }
        if (this.guards.filter(MultiGuardNode.class).isNotEmpty()) {
            ArrayList<ValueNode> list = new ArrayList<ValueNode>();
            for (ValueNode guard : this.guards) {
                if (guard instanceof MultiGuardNode) {
                    list.addAll(((MultiGuardNode)guard).guards);
                    continue;
                }
                list.add(guard);
            }
            return new MultiGuardNode(list.toArray(new ValueNode[0]));
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.usages().filter(node -> node instanceof ValueAnchorNode).isNotEmpty()) {
            ValueNode singleFloatingGuard = null;
            for (ValueNode guard : this.guards) {
                if (!GraphUtil.isFloatingNode(guard)) continue;
                if (singleFloatingGuard == null) {
                    singleFloatingGuard = guard;
                    continue;
                }
                if (singleFloatingGuard == guard) continue;
                return;
            }
            for (Node usage : this.usages().snapshot()) {
                if (!(usage instanceof ValueAnchorNode)) continue;
                usage.replaceFirstInput(this, singleFloatingGuard);
                tool.addToWorkList(usage);
            }
            if (this.usages().isEmpty()) {
                GraphUtil.killWithUnusedFloatingInputs(this);
            }
        }
    }

    public void addGuard(GuardingNode g) {
        this.guards.add((Object)g.asNode());
    }

    public static GuardingNode combine(GuardingNode first, GuardingNode second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        StructuredGraph graph = first.asNode().graph();
        return graph.unique(new MultiGuardNode(first.asNode(), second.asNode()));
    }

    public static GuardingNode addGuard(GuardingNode first, GuardingNode second) {
        if (first instanceof MultiGuardNode && second != null) {
            MultiGuardNode multi = (MultiGuardNode)first;
            multi.addGuard(second);
            return multi;
        }
        return MultiGuardNode.combine(first, second);
    }
}

