/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.StampProvider;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class LoadArrayComponentHubNode
extends FixedWithNextNode
implements Lowerable,
Canonicalizable.Unary<ValueNode> {
    public static final NodeClass<LoadArrayComponentHubNode> TYPE = NodeClass.create(LoadArrayComponentHubNode.class);
    @Node.Input
    private ValueNode value;

    public static ValueNode create(ValueNode value, StampProvider stampProvider, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        AbstractPointerStamp stamp = stampProvider.createHubStamp(null);
        return LoadArrayComponentHubNode.findSynonym(null, value, stamp, metaAccess, constantReflection);
    }

    protected LoadArrayComponentHubNode(Stamp stamp, ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.value = value;
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        return LoadArrayComponentHubNode.findSynonym(this, forValue, this.stamp, tool.getMetaAccess(), tool.getConstantReflection());
    }

    private static ValueNode findSynonym(LoadArrayComponentHubNode self, ValueNode forValue, Stamp stamp, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        ResolvedJavaType type;
        if (forValue.isConstant() && (type = constantReflection.asJavaType(forValue.asConstant())) != null) {
            return ConstantNode.forConstant(stamp, constantReflection.asObjectHub(type.getComponentType()), metaAccess);
        }
        return self != null ? self : new LoadArrayComponentHubNode(stamp, forValue);
    }
}

