/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.cfg.LocationSet;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

public final class Block
extends AbstractBlockBase<Block> {
    public static final Block[] EMPTY_ARRAY = new Block[0];
    protected final AbstractBeginNode beginNode;
    protected FixedNode endNode;
    protected double relativeFrequency;
    private Loop<Block> loop;
    protected Block postdominator;
    private LocationSet killLocations;
    private LocationSet killLocationsBetweenThisAndDominator;

    public Block(AbstractBeginNode node) {
        this.beginNode = node;
    }

    public AbstractBeginNode getBeginNode() {
        return this.beginNode;
    }

    public FixedNode getEndNode() {
        return this.endNode;
    }

    @Override
    public Loop<Block> getLoop() {
        return this.loop;
    }

    public void setLoop(Loop<Block> loop) {
        this.loop = loop;
    }

    @Override
    public int getLoopDepth() {
        return this.loop == null ? 0 : this.loop.getDepth();
    }

    @Override
    public boolean isLoopHeader() {
        return this.getBeginNode() instanceof LoopBeginNode;
    }

    @Override
    public boolean isLoopEnd() {
        return this.getEndNode() instanceof LoopEndNode;
    }

    @Override
    public boolean isExceptionEntry() {
        Node predecessor = this.getBeginNode().predecessor();
        return predecessor != null && predecessor instanceof WithExceptionNode && this.getBeginNode() == ((WithExceptionNode)predecessor).exceptionEdge();
    }

    public Block getFirstPredecessor() {
        return ((Block[])this.getPredecessors())[0];
    }

    public Block getFirstSuccessor() {
        return ((Block[])this.getSuccessors())[0];
    }

    public Block getEarliestPostDominated() {
        Block dom;
        Block b = this;
        while ((dom = (Block)b.getDominator()) != null && dom.getPostdominator() == b) {
            b = dom;
        }
        return b;
    }

    @Override
    public Block getPostdominator() {
        return this.postdominator;
    }

    public Iterable<FixedNode> getNodes() {
        return new Iterable<FixedNode>(){

            @Override
            public Iterator<FixedNode> iterator() {
                return new NodeIterator();
            }

            public String toString() {
                StringBuilder str = new StringBuilder().append('[');
                for (FixedNode node : this) {
                    str.append(node).append(", ");
                }
                if (str.length() > 1) {
                    str.setLength(str.length() - 2);
                }
                return str.append(']').toString();
            }
        };
    }

    @Override
    public String toString() {
        return this.toString(Verbosity.Id);
    }

    public String toString(Verbosity verbosity) {
        StringBuilder sb = new StringBuilder();
        sb.append('B').append(this.id);
        if (verbosity != Verbosity.Id) {
            int i;
            if (this.isLoopHeader()) {
                sb.append(" lh");
            }
            if (this.getSuccessorCount() > 0) {
                sb.append(" ->[");
                for (i = 0; i < this.getSuccessorCount(); ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append('B').append(((Block[])this.getSuccessors())[i].getId());
                }
                sb.append(']');
            }
            if (this.getPredecessorCount() > 0) {
                sb.append(" <-[");
                for (i = 0; i < this.getPredecessorCount(); ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append('B').append(((Block[])this.getPredecessors())[i].getId());
                }
                sb.append(']');
            }
        }
        return sb.toString();
    }

    @Override
    public double getRelativeFrequency() {
        return this.relativeFrequency;
    }

    public void setRelativeFrequency(double relativeFrequency) {
        assert (relativeFrequency >= 0.0 && Double.isFinite(relativeFrequency));
        this.relativeFrequency = relativeFrequency;
    }

    @Override
    public Block getDominator(int distance) {
        Block result = this;
        for (int i = 0; i < distance; ++i) {
            result = (Block)result.getDominator();
        }
        return result;
    }

    public boolean canKill(LocationIdentity location) {
        if (location.isImmutable()) {
            return false;
        }
        return this.getKillLocations().contains(location);
    }

    public LocationSet getKillLocations() {
        if (this.killLocations == null) {
            this.killLocations = this.calcKillLocations();
        }
        return this.killLocations;
    }

    private LocationSet calcKillLocations() {
        LocationSet result = new LocationSet();
        for (FixedNode node : this.getNodes()) {
            if (node instanceof SingleMemoryKill) {
                LocationIdentity identity = ((SingleMemoryKill)((Object)node)).getKilledLocationIdentity();
                result.add(identity);
            } else if (node instanceof MultiMemoryKill) {
                for (LocationIdentity identity : ((MultiMemoryKill)((Object)node)).getKilledLocationIdentities()) {
                    result.add(identity);
                }
            }
            if (!result.isAny()) continue;
            break;
        }
        return result;
    }

    public boolean canKillBetweenThisAndDominator(LocationIdentity location) {
        if (location.isImmutable()) {
            return false;
        }
        return this.getKillLocationsBetweenThisAndDominator().contains(location);
    }

    private LocationSet getKillLocationsBetweenThisAndDominator() {
        if (this.killLocationsBetweenThisAndDominator == null) {
            LocationSet dominatorResult = new LocationSet();
            Block stopBlock = (Block)this.getDominator();
            if (this.isLoopHeader()) {
                assert (stopBlock.getLoopDepth() < this.getLoopDepth());
                dominatorResult.addAll(((HIRLoop)this.getLoop()).getKillLocations());
            } else {
                for (Block b : (Block[])this.getPredecessors()) {
                    assert (!this.isLoopHeader());
                    if (b == stopBlock) continue;
                    dominatorResult.addAll(b.getKillLocations());
                    if (dominatorResult.isAny()) break;
                    b.calcKillLocationsBetweenThisAndTarget(dominatorResult, stopBlock);
                    if (dominatorResult.isAny()) break;
                }
            }
            this.killLocationsBetweenThisAndDominator = dominatorResult;
        }
        return this.killLocationsBetweenThisAndDominator;
    }

    private void calcKillLocationsBetweenThisAndTarget(LocationSet result, Block stopBlock) {
        assert (AbstractControlFlowGraph.dominates(stopBlock, this));
        if (stopBlock == this || result.isAny()) {
            return;
        }
        if (stopBlock == this.getDominator()) {
            result.addAll(this.getKillLocationsBetweenThisAndDominator());
        } else {
            this.calcKillLocationsBetweenThisAndTarget(result, (Block)this.getDominator());
            result.addAll(((Block)this.getDominator()).getKillLocations());
            if (result.isAny()) {
                return;
            }
            ((Block)this.getDominator()).calcKillLocationsBetweenThisAndTarget(result, stopBlock);
        }
    }

    @Override
    public void delete() {
        Block next = ((Block[])this.getSuccessors())[0];
        for (Block pred : (Block[])this.getPredecessors()) {
            Block[] predSuccs = (Block[])pred.successors;
            AbstractBlockBase[] newPredSuccs = new Block[predSuccs.length];
            for (int i = 0; i < predSuccs.length; ++i) {
                newPredSuccs[i] = predSuccs[i] == this ? next : predSuccs[i];
            }
            pred.setSuccessors(newPredSuccs);
        }
        ArrayList<Block> newPreds = new ArrayList<Block>();
        for (int i = 0; i < next.getPredecessorCount(); ++i) {
            Block curPred = ((Block[])next.getPredecessors())[i];
            if (curPred == this) {
                for (Block b : (Block[])this.getPredecessors()) {
                    newPreds.add(b);
                }
                continue;
            }
            newPreds.add(curPred);
        }
        next.setPredecessors(newPreds.toArray(new Block[0]));
    }

    protected void setPostDominator(Block postdominator) {
        this.postdominator = postdominator;
    }

    public boolean isInSameOrOuterLoopOf(Block block) {
        if (this.loop == null) {
            return true;
        }
        for (Loop<Block> l = block.loop; l != null; l = l.getParent()) {
            if (l != this.loop) continue;
            return true;
        }
        return false;
    }

    private class NodeIterator
    implements Iterator<FixedNode> {
        private FixedNode cur;

        NodeIterator() {
            this.cur = Block.this.getBeginNode();
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public FixedNode next() {
            FixedNode result = this.cur;
            if (result instanceof FixedWithNextNode) {
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)result;
                FixedNode next = fixedWithNextNode.next();
                if (next instanceof AbstractBeginNode) {
                    next = null;
                }
                this.cur = next;
            } else {
                this.cur = null;
            }
            assert (!(this.cur instanceof AbstractBeginNode));
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

