/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class RoundNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<RoundNode> TYPE = NodeClass.create(RoundNode.class);
    private final ArithmeticLIRGeneratorTool.RoundingMode mode;

    public RoundNode(ValueNode value, ArithmeticLIRGeneratorTool.RoundingMode mode) {
        super(TYPE, RoundNode.roundStamp((FloatStamp)value.stamp(NodeView.DEFAULT), mode), value);
        this.mode = mode;
    }

    public ArithmeticLIRGeneratorTool.RoundingMode mode() {
        return this.mode;
    }

    private static double round(ArithmeticLIRGeneratorTool.RoundingMode mode, double input) {
        switch (mode) {
            case DOWN: {
                return Math.floor(input);
            }
            case NEAREST: {
                return Math.rint(input);
            }
            case UP: {
                return Math.ceil(input);
            }
            case TRUNCATE: {
                return input < 0.0 ? Math.ceil(input) : Math.floor(input);
            }
        }
        throw GraalError.unimplemented("unimplemented RoundingMode " + (Object)((Object)mode));
    }

    private static FloatStamp roundStamp(FloatStamp stamp, ArithmeticLIRGeneratorTool.RoundingMode mode) {
        double min = stamp.lowerBound();
        min = Math.min(min, RoundNode.round(mode, min));
        double max = stamp.upperBound();
        max = Math.max(max, RoundNode.round(mode, max));
        return new FloatStamp(stamp.getBits(), min, max, stamp.isNonNaN());
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return RoundNode.roundStamp((FloatStamp)newStamp, this.mode);
    }

    public ValueNode tryFold(ValueNode input) {
        if (input.isConstant()) {
            JavaConstant c = input.asJavaConstant();
            if (c.getJavaKind() == JavaKind.Double) {
                return ConstantNode.forDouble(RoundNode.round(this.mode, c.asDouble()));
            }
            if (c.getJavaKind() == JavaKind.Float) {
                return ConstantNode.forFloat((float)RoundNode.round(this.mode, c.asFloat()));
            }
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = this.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitRound(builder.operand(this.getValue()), this.mode));
    }
}

