/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.LoadMethodNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(shortName="==")
public class PointerEqualsNode
extends CompareNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<PointerEqualsNode> TYPE = NodeClass.create(PointerEqualsNode.class);
    private static final PointerEqualsOp OP = new PointerEqualsOp();

    public PointerEqualsNode(ValueNode x, ValueNode y) {
        this((NodeClass<? extends PointerEqualsNode>)TYPE, x, y);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = PointerEqualsNode.findSynonym(x, y, view);
        if (result != null) {
            return result;
        }
        return new PointerEqualsNode(x, y);
    }

    protected PointerEqualsNode(NodeClass<? extends PointerEqualsNode> c, ValueNode x, ValueNode y) {
        super(c, CanonicalCondition.EQ, false, x, y);
        assert (x.stamp(NodeView.DEFAULT).isPointerStamp());
        assert (y.stamp(NodeView.DEFAULT).isPointerStamp());
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), CanonicalCondition.EQ, false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    public static LogicNode findSynonym(ValueNode forX, ValueNode forY, NodeView view) {
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return LogicConstantNode.tautology();
        }
        if (forX.stamp(view).alwaysDistinct(forY.stamp(view))) {
            return LogicConstantNode.contradiction();
        }
        if (forX.stamp(view) instanceof AbstractPointerStamp && ((AbstractPointerStamp)forX.stamp(view)).alwaysNull()) {
            return PointerEqualsNode.nullSynonym(forY, forX);
        }
        if (forY.stamp(view) instanceof AbstractPointerStamp && ((AbstractPointerStamp)forY.stamp(view)).alwaysNull()) {
            return PointerEqualsNode.nullSynonym(forX, forY);
        }
        if (forX instanceof BoxNode && forY instanceof BoxNode) {
            BoxNode boxX = (BoxNode)forX;
            BoxNode boxY = (BoxNode)forY;
            if (boxX.getValue().isConstant() && boxY.getValue().isConstant()) {
                if (boxX.getBoxingKind() != boxY.getBoxingKind()) {
                    return LogicConstantNode.contradiction();
                }
                if (boxX.getValue().asConstant().equals(boxY.getValue().asConstant())) {
                    return LogicConstantNode.tautology();
                }
                return LogicConstantNode.contradiction();
            }
        }
        return null;
    }

    private static LogicNode nullSynonym(ValueNode nonNullValue, ValueNode nullValue) {
        if (nullValue.isConstant()) {
            return IsNullNode.create(nonNullValue, nullValue.asJavaConstant());
        }
        return IsNullNode.create(nonNullValue);
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        Stamp newStamp;
        if (!negated && !(newStamp = xStamp.join(yStamp)).equals(xStamp)) {
            return newStamp;
        }
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        Stamp newStamp;
        if (!negated && !(newStamp = yStamp.join(xStamp)).equals(yStamp)) {
            return newStamp;
        }
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof ObjectStamp && yStampGeneric instanceof ObjectStamp) {
            ObjectStamp xStamp = (ObjectStamp)xStampGeneric;
            ObjectStamp yStamp = (ObjectStamp)yStampGeneric;
            if (xStamp.alwaysDistinct(yStamp)) {
                return TriState.FALSE;
            }
            if (xStamp.neverDistinct(yStamp)) {
                return TriState.TRUE;
            }
        }
        return TriState.UNKNOWN;
    }

    public static class PointerEqualsOp
    extends CompareNode.CompareOp {
        private static boolean isAlwaysFailingVirtualDispatchTest(CanonicalCondition condition, ValueNode forX, ValueNode forY) {
            LoadMethodNode lm;
            if (forY.isConstant() && forX instanceof LoadMethodNode && condition == CanonicalCondition.EQ && (lm = (LoadMethodNode)forX).getMethod().getEncoding().equals(forY.asConstant()) && lm.getHub() instanceof LoadHubNode) {
                ResolvedJavaMethod override;
                ValueNode object = ((LoadHubNode)lm.getHub()).getValue();
                ResolvedJavaType type = StampTool.typeOrNull(object);
                ResolvedJavaType declaringClass = lm.getMethod().getDeclaringClass();
                if (type != null && !type.equals(declaringClass) && declaringClass.isAssignableFrom(type) && (override = type.resolveMethod(lm.getMethod(), lm.getCallerType())) != null && !override.equals(lm.getMethod())) {
                    assert (declaringClass.isAssignableFrom(override.getDeclaringClass()));
                    return true;
                }
            }
            return false;
        }

        @Override
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode result = PointerEqualsNode.findSynonym(forX, forY, view);
            if (result != null) {
                return result;
            }
            if (PointerEqualsOp.isAlwaysFailingVirtualDispatchTest(condition, forX, forY)) {
                return LogicConstantNode.contradiction();
            }
            return super.canonical(constantReflection, metaAccess, options, smallestCompareWidth, condition, unorderedIsTrue, forX, forY, view);
        }

        @Override
        protected CompareNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            return new PointerEqualsNode(newX, newY);
        }
    }
}

